**Syntaxt: Article SRM: Meitinger, Braun & Behr "SEQUENCE MATTERS IN ONLINE PROBING: THE 
*IMPACT OF THE ORDER OF PROBES ON RESPONSE QUALITY, MOTIVATION OF RESPONDENTS, AND ANSWER CONTENT"


**Syntax for Table 5: Indications of Reduced Motivation in Percent: Respondents’ 
** Statements. Two-sided Fisher’s Exact Test 

clear      
use MeitingeretalSRM.dta

************************************************************************************
**Percentage of respondents indicating reduced motivation:

***Crd6_cop: Comprehension Probe
*By experimental condition - total:
bysort trigger: tab crd_6cop_99
*CSP probe first: By country
bysort country: tab crd_6cop_99 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cop_99 if trigger==2

***Crd6_sp: Specific Probe
*By experimental condition - total:
bysort trigger: tab crd6_sp_99
*CSP probe first: By country
bysort country: tab crd6_sp_99 if trigger==1
*COP probe first: By country
bysort country: tab crd6_sp_99 if trigger==2

***Crd6_cp: Category selection probe
*By experimental condition - total:
bysort trigger: tab crd_6cp_99
*CSP probe first: By country
bysort country: tab crd_6cp_99 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cp_99 if trigger==2

************************************************************************************
**Reduced motivation: Fisher's exact test
*Comprehension Probe:
*Total:
tab trigger crd_6cop_99,exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain)   
tab trigger crd_6cop_99 if country==1, exact
tab trigger crd_6cop_99 if country==2, exact
tab trigger crd_6cop_99 if country==3, exact
tab trigger crd_6cop_99 if country==4, exact
tab trigger crd_6cop_99 if country==5, exact

*Specific Probe: 
*Total:
tab trigger crd6_sp_99, exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain) 
tab trigger crd6_sp_99 if country==1, exact
tab trigger crd6_sp_99 if country==2, exact
tab trigger crd6_sp_99 if country==3, exact
tab trigger crd6_sp_99 if country==4, exact
tab trigger crd6_sp_99 if country==5, exact

*Category Selection Probe:
*Total:
tab trigger crd_6cp_99, exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain) 
tab trigger crd_6cp_99 if country==1, exact
tab trigger crd_6cp_99 if country==2, exact
tab trigger crd_6cp_99 if country==3, exact
tab trigger crd_6cp_99 if country==4, exact
tab trigger crd_6cp_99 if country==5, exact




**************************************************************************************
**Check relation between respondents that provided comprehension probe mimsmatch and overt complain
*Respondents providing mismatch at comprehension probe:
tab crd_6cop_6 if trigger==2
bysort country:tab crd_6cop_6 if trigger==2
**Respondents that overtly complain at category selection probe (if received as third probe)
tab crd_6cp_99 if trigger==2
bysort country:tab crd_6cp_99 if trigger==2

tab crd_6cop_6 crd_6cp_99 if trigger==2 & crd_6cp_99==1, column
**45% of respondents who had previously given a mismatching response to the comprehension 
**probe overtly complained when they received the category-selection as their third probe


