**Syntaxt: Article SRM: Meitinger, Braun & Behr "SEQUENCE MATTERS IN ONLINE PROBING: THE 
*IMPACT OF THE ORDER OF PROBES ON RESPONSE QUALITY, MOTIVATION OF RESPONDENTS, AND ANSWER CONTENT"


**Syntax for Table 3: Probe Nonresponse by Probe Type, Country, and Experimental 
** Group in Percent and Results for Two-sided Fisher’s Exact Test (FET) 

clear      
use MeitingeretalSRM.dta

************************************************************************************
**Percentage of nonresponse:

***Crd6_cop: Comprehension Probe
*By experimental condition - total:
bysort trigger: tab crd_6cop_97
*CSP probe first: By country
bysort country: tab crd_6cop_97 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cop_97 if trigger==2

***Crd6_sp: Specific Probe
*By experimental condition - total:
bysort trigger: tab crd6_sp_97
*CSP probe first: By country
bysort country: tab crd6_sp_97 if trigger==1
*COP probe first: By country
bysort country: tab crd6_sp_97 if trigger==2

***Crd6_cp: Category selection probe
*By experimental condition - total:
bysort trigger: tab crd_6cp_97
*CSP probe first: By country
bysort country: tab crd_6cp_97 if trigger==1
*COP probe first: By country
bysort country: tab crd_6cp_97 if trigger==2

************************************************************************************
**Nonresponse: Fisher's exact test
*Comprehension Probe:
*Total:
tab trigger crd_6cop_97,exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain)   
tab trigger crd_6cop_97 if country==1, exact
tab trigger crd_6cop_97 if country==2, exact
tab trigger crd_6cop_97 if country==3, exact
tab trigger crd_6cop_97 if country==4, exact
tab trigger crd_6cop_97 if country==5, exact

*Specific Probe: 
*Total:
tab trigger crd6_sp_97, exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain) 
tab trigger crd6_sp_97 if country==1, exact
tab trigger crd6_sp_97 if country==2, exact
tab trigger crd6_sp_97 if country==3, exact
tab trigger crd6_sp_97 if country==4, exact
tab trigger crd6_sp_97 if country==5, exact

*Category Selection Probe:
*Total:
tab trigger crd_6cp_97, exact
*By country: (1=Germany, 2=GB, 3=U.S., 4=Mexico, 5=Spain) 
tab trigger crd_6cp_97 if country==1, exact
tab trigger crd_6cp_97 if country==2, exact
tab trigger crd_6cp_97 if country==3, exact
tab trigger crd_6cp_97 if country==4, exact
tab trigger crd_6cp_97 if country==5, exact
