  	# Function generating a neighborhood that is in line with predefined stylized facts
  	# ---------------------------------------------------------------------------------
	    neighbs <- function(p_eth_total,p_gen1_total,eth_low_ses,range,steps,N_neighb,N_agents,movers=NULL) {

	    	## DEFINE MATRIX THAT CONTAINS THE DIFFERENT NEIGHBORHOOD IDEALTYPES THAT CAN EXIST

		    	# possible native proportions in neighborhood
			    p_ger<-seq(p_eth_total[1]-range,p_eth_total[1]+range,steps)/100 
			    p_eth_neighbs<-matrix(NA,length(p_ger),length(p_eth_total))      # matrix that will contain the different types of neighborhoods that exist
			    p_eth_neighbs[,1]<-sort(p_ger)									 # fill matrix with native proportions

		   		# given these native proportions in neighborhoods whats the proportion of each ethnic group among the immigrants in a neighborhood? 
			    p_eth_neighbs[,-1]<-matrix(p_eth_total[-1]/sum(p_eth_total[-1]),nrow(p_eth_neighbs[,-1]),ncol(p_eth_neighbs[,-1]),byrow=T)
			    p_eth_neighbs[,-1]<-p_eth_neighbs[,-1]*(1-p_eth_neighbs[,1])	# fill matrix with immigrant group proportions

			    # Note: relative size of ethnic groups in each neighborhood now equals that of the relative size in total 

			    # from group proportions to absolute numbers of agents
			    N_eth_neighbs<-p_eth_neighbs*N_agents

			    # account for stylized fact: low-ses ethnic groups rather in immigrant neighborhoods, high-ses ethnic groups rather in native neighborhoods
			    if (!is.null(movers)) {
		    		lower_nat<-1:(nrow(N_eth_neighbs)/2)
		    		upper_nat<-round((nrow(N_eth_neighbs)/2)+1):nrow(N_eth_neighbs)
			    	counter<-0
			    	while (counter<movers) {

			    		row_upper<-sample(upper_nat,1)#,prob=length(upper_nat):1/sum(length(upper_nat):1) )
			    		row_lower<-sample(lower_nat,1)#,prob=1:length(lower_nat)/sum(1:length(lower_nat)) )
			    		col_loses<-sample(which(eth_low_ses==1),1)
			    		col_hises<-sample(which(eth_low_ses==0),1)

			    		if (N_eth_neighbs[row_upper,col_loses]>0 & N_eth_neighbs[row_lower,col_hises]>0) {
			    			N_eth_neighbs[row_upper,col_loses]<-N_eth_neighbs[row_upper,col_loses]-1
			    			N_eth_neighbs[row_lower,col_loses]<-N_eth_neighbs[row_lower,col_loses]+1
			    			N_eth_neighbs[row_lower,col_hises]<-N_eth_neighbs[row_lower,col_hises]-1
			    			N_eth_neighbs[row_upper,col_hises]<-N_eth_neighbs[row_upper,col_hises]+1
			    			counter<-counter+2
			    		}
			    	}
				}

			    # Note: If p_move!=NULL, then relative size of ethnic groups in each neighborhood are not equal to those of the relative size in total, but biased in accordance with stylized fact. The overall proportions of ethnic groups are still correct. 

				# Within each ethnic immigrant group distinguish now between 1st and 2nd generation
				N_eth_gen_neighbs<-matrix(NA,nrow(N_eth_neighbs),ncol(N_eth_neighbs)*2-1)
				N_eth_gen_neighbs[,1]<-N_eth_neighbs[,1]
				j<-2
				for (i in seq(2,ncol(N_eth_gen_neighbs)-1,2)) {
					N_eth_gen_neighbs[,i  ]<-N_eth_neighbs[,j]*p_gen1_total[j]/100
					N_eth_gen_neighbs[,i+1]<-N_eth_neighbs[,j]*(100-p_gen1_total[j])/100
					j<-j+1
				}
				N_eth_gen_neighbs<-round(N_eth_gen_neighbs)

			## BASED ON NEIGHBORHOOD IDEAL TYPES CREATE ACTUAL NUMBER OF NEIGHBORHOODS (each type appears equally likely)
		    id_neighbs<-sample(1:nrow(N_eth_gen_neighbs),N_neighb,replace=T)
		    N_eth_gen_neighbs_final<-matrix(NA,N_neighb,ncol(N_eth_gen_neighbs))
		    for (i in 1:N_neighb) {
			    N_eth_gen_neighbs_final[i,]<-N_eth_gen_neighbs[id_neighbs[i],]
			}

			return(N_eth_gen_neighbs_final)
		}

		# Measuring Immigrant Proportions (H&S Measurement vs. Original)
		measure<-function(region) {
			imm_neighb_HS<-imm_neighb_orig<-c()
			for (i in 1:nrow(region)) { 

				fuppes<-region[i,]*p_correct
				natmig_HS<-c(fuppes[1],sum(fuppes[-1]))
				fuppes<-region[i,]*(1-p_correct)
				natmig_HS<-natmig_HS+c(sum(fuppes[-1]),fuppes[1])
				natmig_HS<-round(natmig_HS)

				fuppes<-region[i,]
				natmig<-c(fuppes[1],sum(fuppes[-1]))

				imm_neighb_HS[i]  <-natmig_HS[2]/sum(natmig_HS)
				imm_neighb_orig[i]<-natmig[2]/sum(natmig)
			}

			data<-as.data.frame(cbind(imm_neighb_HS,imm_neighb_orig))
			rm(fuppes)
			return(data)
		}		
