************************************************************
***** Name-based measures of neighborhood composition: *****
*****        how telling are neighbors' names?         *****
*****                                                  *****
*****                  Hanno Kruse                     *****
*****                 Joerg Dollmann                   *****
*****                                                  *****
*****                Data Preparation                  *****
*****          using CILS4EU W1 Data (v.1.2.0)         *****
*****          and   Stata 14                          *****
*****                                                  *****
*****     Aim: This Do-file creates a dataset that     *****
*****          will be used as input in the analyses   *****
*****          in R.                                   *****
*****                                                  *****
*****     Comment: Only run this Master Do-File;       *****
*****              all other Do-Files are then         *****
*****              automatically executed.             *****
*****                                                  *****
************************************************************

********************************************
***************** Globals ******************
********************************************

	* specify folder where datasets are stored
	global DATA_IN      "xxx"
	* specify folder where resulting dataset should be saved
	global DATA_OUT     "xxx"
	* specify folder where do-files are stored
	global DO_FILES     "xxx"

	
********************************************
************** Merge Data ******************
********************************************

	quietly do "${DO_FILES}01_merge.do"

	
********************************************
********** Individual Level Data  **********
********************************************	

	quietly do "${DO_FILES}02_ild.do"

	
********************************************
************** Save to file  ***************
********************************************

	keep youthid classid schoolid totwgts houwgt senwgt stratum correct error immgen ethgroups* HS_CODE
	drop if HS_CODE==.
	saveold "${DATA_OUT}cils4eu_w1_ger.dta", replace v(12)
