********************************************************
*****            Individual level Data             *****
*****                                              *****
*****             using CILS4EU Data               *****
*****                                              *****
********************************************************

*** Simplify immigrant generation variable
*		- collapse immigrant generational information from cils4eu data to three categories: 1st,2nd and none/native

	gen    immgen=y1_generationG
	recode immgen (1 2 3 4 = 1) (5 6 7 8 15 17 = 2) (9 10 11 12 13 14 19 16 = 0) (16 17 18 = .)		
	label def immgen 1 "1st gen." 2 "2nd gen." 0 "native"
	label val immgen immgen
		

*** Define ethnic background in seven categories
*		- collapse ethnic background information from cils4eu data to seven categories:
* 			turkey
* 			fsu
* 			poland
* 			fyr
*           other western
*           other non-western

	gen ethcat7=.
	replace ethcat7=0 if immgen==0
	replace ethcat7=1 if immgen!=0 & country==2 & inlist(y1_countorigG,792,904)
	replace ethcat7=2 if immgen!=0 & country==2 & inlist(y1_countorigG,51,31,112,268,398,417,428,440,498,643,804,810)
	replace ethcat7=3 if immgen!=0 & country==2 & inlist(y1_countorigG,616)
	replace ethcat7=4 if immgen!=0 & country==2 & inlist(y1_countorigG,70,191,499,688,705,807,890,891)
	replace ethcat7=5 if immgen!=0 & country==2 & inlist(y1_countorigG,8,20,36,40,56,100,124,196,200,203,208,233,246,250,276,300,304,336,338,348,352,372,380,428,442,470,492,528,554,578,620,642,703,724,744,752,756,826,830,832,833,840,903)
	replace ethcat7=6 if immgen!=0 & country==2 & ethcat7==.		
	label var ethcat7 "ethnicity in 7 categories"
	label define ethcat7 			0 "(0) Native", modify 
	label define ethcat7 			1 "(1) Turkish", modify 
	label define ethcat7 			2 "(2) FSU", modify 
	label define ethcat7 			3 "(3) Polish", modify 
	label define ethcat7 			4 "(4) FYR", modify 
	label define ethcat7 			5 "(5) Other western", modify 
	label define ethcat7 			6 "(6) Other non-western ", modify 	
	rename ethcat7 ethgroups

	
*** Validate name-based classification based on (parental) birth country
*		- create binary variable identifying whether onomastic specification was correct

	recode HS_CODE (99=.)
	gen correct=.
	replace correct=0 if HS_CODE<. & ethgroups<.
	replace correct=1 if (HS_CODE==0 & ethgroups==0) | (HS_CODE==1 & ethgroups>0 & ethgroups<.)
	label def correct 1 "correctly specified" 0 "incorrectly specified"
	label val correct correct	

	gen error=1-correct
	
