********************************************************************************
************************	META-ANALYSIS: Absolute bias	********************
********************************************************************************
*CC, 10/14/2016

use "${path}\${data}\Metaanalyse_basic.dta", clear
set more off
********************************************************************************

/// 	1. keep only studies & vars that are needed for the absolute bias meta-analysis
drop if  indicator==2
keep     year ///
		 n ///
		 N ///
		 es ///
		 es_b ///
		 rr ///
		 author ///
		 mode ///
		 mixed ///
		 web ///
		 sample ///
		 design ///
		 target ///
		 id ///
		 weight
/*
		 ///
		 Characteristic ///
		 NGroupSurvey_r  ///
		 NGroupBenchmark_r ///
		 DocType_e ///
		 BenchmarkQuality_e ///
		 Variable_e ///
*/

/// 	2. Compute absolute bias by category
rename es es_s
drop if year==.

drop if es_s==. //drop implausible values
drop if es_s==999
*drop if es_s==888
drop if es_b==888.0
drop if es_b==.

format es_s %9.1f

gen es_h= es_s - es_b
gen es=abs(es_h)
format es %9.2f
lab var es "Effect size"

//// compute variance
encode id, gen(id_num)

/*
centile es
bootstrap median=r(p50): sum es, detail
matrix list r(table)
matrix table=r(table)
gen es_var=.
replace es_var=(table[2,1])
*/

gen es_var=.
forval i=1/110 {
centile es if id_num==`i'
bootstrap median=r(p50) if id_num==`i', seed(2015): sum es, detail
matrix table_`i'=r(table)
replace es_var=(table_`i'[2,1]) if id_num==`i'
replace es=(table_`i'[1,1]) if id_num==`i'
}

///		3. Compute inverse variance
*gen es_var= es_s*(1-es_s)
gen vi=abs(1/(es_var^2))
format vi %9.6f
drop es_*
lab var vi "inverse variance"



///		4. generate new variable that contains the median value across a study as an effect size
encode id, gen(id_h)
sort id
/*
gen es_new=.

gen vi_new=.

foreach num of numlist 1/153 {
		
									sum es if id_h==`num', d
									replace es_new=r(p50) if id_h==`num'
									
							 }
							 

									

							 
foreach num of numlist 1/153 {
	
									sum vi if id_h==`num', d
									replace vi_new=r(p50) if id_h==`num'
									
							 }
					
format es_new %9.2f
format vi_new %9.6f
*/

gen numvars=.
foreach num of numlist 1/153 {
						
									sum es if id_h==`num', d
									replace numvars=r(N) if id_h==`num'
							 }

							 


* shorten dataset to only one effect size value per study that contains the median absolute bias for each study
set seed 27
sort id
sample 1, count by(id)

/*
drop es
drop vi
rename vi_new vi
rename es_new es
*/

lab var es "Effect size"
lab var vi "Inverse variance"
lab var numvars "Number of variables compared to a benchmark"

/*
///		5. recode sample variable
recode sample (2=0)
lab def sample 0 "Probability" 1 "Nonprobability"
lab val sample sample

*/

