********************************************************************************
*****************	META-ANALYSE: Preparation R-Indicator data	****************
********************************************************************************
*CC, 03/06/2016

use "${path}\${data}\Metaanalyse_basic.dta", clear
********************************************************************************

/// 1. keep only studies & vars that are needed for R-Indicator meta-analysis
drop if  indicator==1
keep     year ///
		 resp ///
		 n ///
		 ci ///
		 es ///
		 rr ///
		 author ///
		 doctype ///
		 mode ///
		 personal ///
		 telephone ///
		 web ///
		 mixed ///
		 mail ///
		 sample ///
		 design ///
		 target ///
		 paper ///
		 auxvars ///
		 business ///
		 author
/*		 ///
		 framevar ///
		 fieldworkvar ///
		 socdemvar ///
		 intobsvar ///
		 linkedvar
*/


/// 2. impute missing values on confidence intervals

///		 2.1 divide CISurvey Variable in Upper bound and lower bound 
replace  ci="." if ci=="999" 
replace  ci="." if ci=="888"
split 	 ci, p("-")
rename 	 ci1 ci_low
rename 	 ci2 ci_high
destring ci_low ci_high, replace
sum 	 ci_low // mean == 0.80
sum 	 ci_high // mean == 0.84

///      2.2 generate VI-variable without imputation
gen 	 vi= ((ci_high-ci_low)/(1.96*2))^2
*gen vi=sqrt(TotalN)*(ci_low-es)*(-1.96)
*gen vi_test=sqrt(TotalN)*(ci_high-es)*1.96
lab var  vi "VI (no imputation)"

///		 2.3 generate VI-variable using Predictive Mean Matching
gen 	vi_imp=vi
mi set 	mlong
mi register imputed vi_imp
*mi register regular year design sample target n rr mode business auxvars
mi register regular n rr

mi describe
mi misstable pattern
mi misstable nested

*mi impute pmm vi_imp=year design sample target n rr mode business auxvars, add(1) knn(5) force
mi impute pmm vi_imp=n rr, add(1) knn(5) force
lab var vi_imp "VI (imputation by response rate and R-Indicator)"
drop if vi_imp==.

///		2.4 generate a variable for whether vi is observed or imputed
rename 	_mi_m ci_reported 
lab var ci_reported "Confidence Interval reported"
lab def ci_reported 0 "Yes" 1 "No"
lab val ci_reported ci_reported

///		2.5 recode missings auxvars
recode auxvars (999=.)







