********************************************************************************
**********************	META-ANALYSIS: Data set generation	********************
********************************************************************************
*CC, 06.03.2016

/// 1. Export all three single tables from Access and save as .xls using path:
///		A:\WORK\3_Metaanalyse\Representativeness\Data

/// 2. Import and save all three single data sets

///		2.1 "Paper" data set
import 	 excel "${path}\${data}\Paper.xlsx", sheet("Paper") firstrow
rename 	 Note note_paper
duplicates drop PaperID, force
save 	 "${path}\${data}\Paper_${c_date}.dta", replace

clear

///		2.2 "Study" data set
import 	 excel "${path}\${data}\Study.xlsx", sheet("Study") firstrow
duplicates drop StudyID, force
rename 	 Note note_study
save 	 "${path}\${data}\Study_${c_date}.dta", replace

clear

///		2.3 "Statistics" data set
import 	 excel "${path}\${data}\Statistics.xlsx", sheet("Statistics") firstrow
rename 	 Note note_stat
save 	 "${path}\${data}\Statistics_${c_date}.dta", replace

clear

/// 3. Merge datasets
use 	 "${path}\${data}\Paper_${c_date}.dta", clear

///		3.1 Paper and Study
merge 	 1:m PaperID using "${path}\${data}\Study_${c_date}.dta", force
drop 	 _merge

///		3.2 (Paper and Study) and Statistics
merge 	 1:m StudyID using "${path}\${data}\Statistics_${c_date}", force
drop 	 _merge

///	4. Save combined data set
save 	 "${path}\${bdata}\${data}\Metaanalyse_${c_date}.dta", replace
