// 25/03/2017
// Francesco Sarracino
// f.sarracino@gmail.com
// Executing order of the dofiles to replicate the results of the paper: Bias  and efficiency loss in regression estimates due to duplicated observations: a Monte Carlo simulation
// by Francesco Sarracino and Malgorzata Mikucka

// To replicate the results of the paper, please, execute the dofiles in the following order:

// the file 11-duplicates-V03.do runs the simulations for Scenario 1. Duplicates are drawn according to the distribution of the Y variable. 
do 11-duplicates-V03.do

// the file 12-duplicates-V03.do analyses the data produced in the previous step. It computes all the results relative to Scenario 1: Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 12-duplicates-V03.do

// the file 13-duplicates-V03.do runs the simulations for Scenario 2. Duplicates are drawn according to the distribution of the Y variable.
do 13-duplicates-V03.do

// the file 14-duplicates-V03.do analyses the data produced in the previous step. It computes all the results relative to Scenario 2: Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 14-duplicates-V03.do

// the file 25-duplicates-V01.do runs the simulations for Scenario 3. Duplicates are drawn according to the distribution of the Y variable.
do 25-duplicates-V01.do

// the file 26-duplicates-V01.do analyses the data produced in the previous step. It computes all the results relative to Scenario 3: Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 26-duplicates-V01.do

// Robustness checks
//Varying sample sizes
// the test for Scenario 1 is omitted because in this case the duplicates have no impact on the estimates.
// the file 21-duplicates-V01.do runs the simulations for Scenario 2 Variant 1 with N = 500 observations. Duplicates are drawn according to the distribution of the Y variable.
do 21-duplicates-V01.do

// the file 22-duplicates-V01.do analyses the data produced in the previous step. It computes all the results relative to Scenario 2 Variant 1 (N = 500): Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 22-duplicates-V01.do

// the file 23-duplicates-V01.do runs the simulations for Scenario 2 Variant 1 with N = 5000 observations. Duplicates are drawn according to the distribution of the Y variable.
do 23-duplicates-V01.do

// the file 24-duplicates-V01.do analyses the data produced in the previous step. It computes all the results relative to Scenario 2 Variant 1 (N = 5000): Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 24-duplicates-V01.do

//Following the distribution of X variable
// the test for Scenario 1 is omitted because in this case the duplicates have no impact on the estimates.
// the file 29-duplicates-V01.do runs the simulations for Scenario 2. Duplicates are drawn according to the distribution of the X variable.
do 29-duplicates-V01.do

// the file 30-duplicates-V01.do analyses the data produced in the previous step. It computes all the results relative to Scenario 2 according to the distribution of the X variable: Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 30-duplicates-V01.do

// the file 31-duplicates-V01.do runs the simulations for Scenario 3. Duplicates are drawn according to the distribution of the X variable.
do 31-duplicates-V01.do

// the file 32-duplicates-V01.do analyses the data produced in the previous step. It computes all the results relative to Scenario 3 according to the distribution of the X variable: Percentage bias, Bias of the Standard Errors, Dfbeta, and RMSE. 
do 32-duplicates-V01.do
