#----------------------------------------------------------------------
# Name:         nsfg_networkanalysis_batch_step1.py
# Purpose:      Create a string (GME code) to copy and paste into GME in the next step.
#               GME will snap GPX file to the nearest road if the road exist within 5000 meters.
#               Only GPX points existed within selected blocks and adjacent of those selected blocks will be snapped.
#               The routes will be created by those snapped points.
#
# Created:      2013-03-26
# Notes:        GME can be downloaded from http://www.spatialecology.com/gme/snappoints.htm
#----------------------------------------------------------------------


import arcpy
import datetime
import csv
import xlrd
import os
import glob

### the list of selected_PSU and available GPX are sensitive data, so remove from this version ###
available_GPX = []

def read_available_gpx (dir):
    folder = []
    for f in os.listdir(dir):
        if f[0:3] in available_GPX :
            folder.append(f[0:len(f)-4])
    return folder
    
#############################################
#####   Set up Input files and folders  #####
#############################################
dir_addrfeat = r"<Path>\addrfeat\redo" # Folder for Network files based on Census Tiger addrfeat shapefiles
dir_block = r"<Path>\block" # Folder for Cesus Tiger block shapefiles
dir_temp = r"<Path>\temp" # temp folder to store temp files during process
dir_routes = r"<Path>\routes\q1" # output folder for snapped GPX files after GME runs.
dir_gpx = r"<Path>\gpx\q1\shp" # Folder for GPX shapefiles converted from excel
dir_callnote = r"<Path>\Calls\Q1" # Folder for call notes
dir_original_gpx = r"<Path>\gpx\q1\xls" # Folder for original GPX excel file. It will be used to read PSU.
dir_analysis = r"<Path>\live_analysis\q1sample2\analysis\_update" # Folder for respondent location. It will be used to read PSU.

#### create a list of folders to read in ####
folderList = read_available_gpx(dir_original_gpx)
print folderList


##### read csv and create list per line #####
infile =  open(spjoin,'rb')
d = {}
csvreader = csv.reader(infile, delimiter=',', quotechar='"')
p = 1
for row in csvreader:
    d[p] = {'combineID':row[0], 'Geo10':row[1]}
    p = p + 1
print len(d)

gmeCommands = "{"
for i in range(0,len(folderList)):
    IwFolder = folderList[i]
    IwerID = IwFolder[0:3]
    IwDate = IwFolder[4:13]
    tempTime = datetime.datetime.strptime(IwDate, '%Y%m%d')
    CallDate = str(tempTime.strftime("%d%b%Y")).upper()

    if not os.path.exists(dir_routes + "\\" + IwFolder):
        os.makedirs(dir_routes + "\\" + IwFolder)
    
    callnote = dir_callnote + "\\nsfgID_" + IwerID + "_" + CallDate + ".xls"
    #### select sample houses based on the sections visited in callnote ####################
    dCall = {}
    c = 0
    wb = xlrd.open_workbook(callnote)
    sh = wb.sheet_by_name(u'sheet1')
    for rownum in range(1,sh.nrows):
        dCall[c] = {'vProjectId': sh.row_values(rownum,0,1)[0].encode('utf8'),
                    'vSamplelineId':sh.row_values(rownum,1,2)[0].encode('utf8'),
                    'nCallInfoId':sh.row_values(rownum,2,3)[0],
                    'sCallMode':sh.row_values(rownum,3,4)[0].encode('utf8'),
                    'sResultCodeId':sh.row_values(rownum,4,5)[0].encode('utf8'),
                    'dResultDate':sh.row_values(rownum,5,6)[0],
                    'tResultTime':sh.row_values(rownum,6,7)[0],
                    'sInterviewerEmployeeId':sh.row_values(rownum,7,8)[0].encode('utf8'),
                    'nsfgID':sh.row_values(rownum,8,9)[0].encode('utf8'),
                    'vAddressLine1':sh.row_values(rownum,9,10)[0].encode('utf8'),
                    'vAddressLine2':sh.row_values(rownum,10,11)[0].encode('utf8'),
                    'vCity':sh.row_values(rownum,11,12)[0].encode('utf8'),
                    'sState':sh.row_values(rownum,12,13)[0].encode('utf8'),
                    'sPostalCode':sh.row_values(rownum,13,14)[0].encode('utf8'),
                    'Rdate':'',
                    'Rtime':'',
                    'IwerID':IwerID,
                    'IwDate':IwDate,
                    'Section':sh.row_values(rownum,1,2)[0].encode('utf8')[0:7]}
        c = c + 1
    print "dCall length:" + str(len(dCall))


    SectionList = []
    for key in dCall.keys():
        if dCall[key]['Section'] not in SectionList:
            SectionList.append(dCall[key]['Section'])


    # find state, county and blocks for each section
    d_Sec = {}
    for a in range(0,len(SectionList)):
        Section  = SectionList[a]
        for key in d.keys():
            if d[key]['combineID'][0:7] == Section and d[key]['Geo10'] != '':
                if Section not in d_Sec:
                    d_Sec[Section] = {'state':'', 'county':'', 'block':[]}
                d_Sec[Section]['state'] = d[key]['Geo10'][0:2]
                d_Sec[Section]['county'] = d[key]['Geo10'][2:5]
                if d[key]['Geo10'][11:15] not in d_Sec[Section]['block']:
                    d_Sec[Section]['block'].append(d[key]['Geo10'][11:15])
    print len(d_Sec)


    # select blocks and gpx in the selected blocks
    for s in range(0,len(SectionList)):
        block = dir_block + '\\block_selected_' + d_Sec[SectionList[s]]['state'] + ".shp"
        gpx = dir_gpx + "\\" + IwFolder + ".shp"

        gpxlyr = dir_temp + "\\gpx" + IwFolder + str(s)
        blocklyr = dir_temp + "\\block" + IwFolder + str(s)
        outshp = dir_routes + "\\" + IwFolder + "\\gpx_selected_" + IwFolder + "_s" + str(s) + ".shp"
        
        arcpy.MakeFeatureLayer_management (block, blocklyr)
        arcpy.MakeFeatureLayer_management(gpx, gpxlyr)
        blist = "("
        for b in range(0,len(d_Sec[SectionList[s]]['block'])):
            if b != len(d_Sec[SectionList[s]]['block'])-1:
                blist = blist + "'" + str(d_Sec[SectionList[s]]['block'][b]) + "',"
            else:
                blist = blist + "'" + str(d_Sec[SectionList[s]]['block'][b]) + "')"
        whereclause = "\"STATEFP10\" = '" + d_Sec[SectionList[s]]['state'] + "' AND \"COUNTYFP10\" = '" + d_Sec[SectionList[s]]['county'] + "' AND \"BLOCKCE10\" in " +  blist
        arcpy.SelectLayerByAttribute_management (blocklyr, "NEW_SELECTION", whereclause)
        arcpy.SelectLayerByLocation_management (blocklyr, "INTERSECT", blocklyr, "", "ADD_TO_SELECTION")
        arcpy.SelectLayerByLocation_management (gpxlyr, "INTERSECT", blocklyr, "", "NEW_SELECTION")
        arcpy.CopyFeatures_management(gpxlyr, outshp)
        # print out gme commands for snap pointes
        addrfeatID = str(d_Sec[SectionList[s]]['state']) + str(d_Sec[SectionList[s]]['county'])
        addrfeat = dir_addrfeat + "\\addrfeat_selected_" + addrfeatID + "_identify.shp"
        outsnap = dir_routes + "\\" + IwFolder + "\\gpx_selected_" + IwFolder + "_s" + str(s) + "_snap.shp"

        gmeCommands = gmeCommands + 'snappoints(in="' + outshp + '", snap="' + addrfeat + '", out="' + outsnap + '", tol=5000);'

gmeCommands = gmeCommands + "};"

print gmeCommands


print "All done"
