#----------------------------------------------------------------------
# Name:         nsfg_calculate_speed_csv_GMT.py
# Purpose:      Add more information to the previous merged file.
#               FileDate is added.
#               GPX time is based on local time. It matches with Call note time.
#               Speed is calculated based on GMT timezone.
#
# Created:      2014-07-16
#----------------------------------------------------------------------



import xlrd
import datetime
import csv
import time
import os
import shutil
from openpyxl import Workbook
from openpyxl import load_workbook
import arcpy
from dbfpy import dbf

#############################################
#####   Set up Input files and folders  #####
#############################################
infile = r"<Path>\paper\samplehouse_spjoin_routes_allq1s2_071614.dbf" # merged output file from previous step. GPX and call note time gap and distance.
gpx    = r"<Path>\gpx\q1\shp" # Folder for GPX shapefiles converted from excel
CSVOutfile = r"<Path>\paper\samplehouse_spjoin_routes_allq1s2_with_speed_071614_gmt.csv" # output file name.

# convert excel time to python datetime
def minimalist_xldate_as_datetime(xldate, datemode):
    # datemode: 0 for 1900-based, 1 for 1904-based
    return (
        datetime.datetime(1899, 12, 30)
        + datetime.timedelta(days=xldate + 1462 * datemode)
        )

# read excel to dictionary
def xls2dictionary (infile, d, rownum, colnum):
    wb = xlrd.open_workbook(infile, logfile=open(os.devnull, 'w'))
    sh = wb.sheet_by_index(0)
    num_rows = sh.nrows
    for r in range(num_rows):
        d[r] = {}
        for c in range(colnum):
            cell_value_id = sh.cell(0,c).value
            d[r][cell_value_id] = sh.cell(r,c).value
    return d

# read dbf to dictionary
def dbf2dict (infile,d):
    i=0
    dbffile = dbf.Dbf(infile)
    names=[]
    
    for field in dbffile.header.fields:
        names.append(field.name)
    rows = arcpy.SearchCursor(infile)
    for row in rows:
        d[i] = {}
        for fldnm in names:
            d[i][fldnm] = row.getValue(fldnm)
        i = i +1
    dbffile.close()
    return d

def add_field_in_excel (infile, ExcelOutfile, d, fields):
    shutil.copyfile(infile, ExcelOutfile)
    wb = load_workbook(filename = ExcelOutfile)
    #Get the current Active Sheet
    ws = wb.get_active_sheet()
    for key in d.keys():
        for fnum in range(1,len(fields)+1):
            newvalue = d[key][fields[fnum-1]]
            if key == 0:
                ws.cell(row=key+1,column=37+fnum).value = str(newvalue)
            else:
                ws.cell(row=key+1,column=37+fnum).value = newvalue
    wb.save(ExcelOutfile)


# create dictionary from dbf #
d = {}
templateD = dbf2dict(infile, d)
print len(d)

count = 0
for key in templateD.keys():
    calcSpd = None
    gpxID2 = None
    gpxSpd2 = None
    gpxTime2 = None
    timediff_sec = None
    gpxTime1 = None
    templateD[key]['calcSpd'] = calcSpd
    templateD[key]['gpxID2'] = gpxID2
    templateD[key]['gpxSpd2'] = gpxSpd2
    templateD[key]['gpxTime2'] = gpxTime2
    templateD[key]['timediff_sec'] = timediff_sec
    templateD[key]['gpxTime1'] = gpxTime1

    if templateD[key]['GPXID'] not in (' ', '', 0) and templateD[key]['GPXDATE'] not in ('', ' '):
        gpxDate = templateD[key]['GPXDATE']
        gpxID   = templateD[key]['GPXID']
        gpxSpd   = templateD[key]['GPXSPD']
        Total_Leng   = templateD[key]['TOTAL_LENG']
        gpxFile = gpx + "\\" + str(gpxDate) + ".dbf"
        d = {}
        gpxDict = dbf2dict(gpxFile,d)
        for g in gpxDict.keys():
            if g != 0:
                gpxID2 = int(float(gpxDict[g]['TRKPT_ORDI']))
                gpxSpd2 = gpxDict[g]['SPEED']
                gpxTime2 = gpxDict[g]['GMT']
                gpxTime1 = gpxDict[g-1]['GMT']
                if gpxID+1 == gpxID2:
                    Date = datetime.datetime.strptime(gpxDate[4:len(gpxDate)],'%Y%m%d')
                    Time = datetime.datetime.strptime(gpxTime1,'%I:%M:%S %p').time()
                    Time2 = datetime.datetime.strptime(gpxTime2,'%I:%M:%S %p').time()
                    if 'PM' in gpxTime1 and 'AM' in gpxTime2:
                        preciousDate = Date - datetime.timedelta(1)
                        starttime = datetime.datetime.combine(preciousDate,Time)
                        endtime = datetime.datetime.combine(Date,Time2)
                    else:
                        starttime = datetime.datetime.combine(Date,Time)
                        endtime = datetime.datetime.combine(Date,Time2)

                    timediff_sec   = datetime.timedelta.total_seconds(endtime-starttime)
                    calcSpd = float(Total_Leng)/float(timediff_sec)
                    count = count + 1
                    templateD[key]['calcSpd'] = calcSpd
                    templateD[key]['gpxID2'] = gpxID2
                    templateD[key]['gpxSpd2'] = gpxSpd2
                    templateD[key]['gpxTime2'] = gpxTime2
                    templateD[key]['timediff_sec'] = timediff_sec
                    templateD[key]['gpxTime1'] = gpxTime1
       
    print key


print str(count) + ' cases were calculated'       
    

########### Export as CSV from Dictionary ######################
fbuffer = open(CSVOutfile, 'wb')
cw = csv.writer(fbuffer, delimiter=',', quotechar='"')
##### Write headers
header = ["JOIN_COUNT","TARGET_FID","JOIN_FID","OBJECTID","IN_FID",
 "NEAR_FID","NEAR_DIST","NEAR_X","NEAR_Y","NEAR_ANGLE",
 "IN_STNAME","NEAR_STNAM","VSAMPLELIN","VLINE_NUM","LAT",
 "LONG","COMBINEID","SAMPLED","CALLNOTE","MATCHED",
 "ORIG_FID","OBJECTID_1","NAME","FIRSTSTOPI","LASTSTOPID",
 "STOPCOUNT","TOTAL_LENG","GPXID","GPXSPD","GPXTIME",
 "GPXDATE","CALLID","RESULTCODE","CALLRTIME","CALLDATE",
 "ADDR1","ADDR2","FILEDATE",
 "calcSpd", "gpxID2", "gpxSpd2", "gpxTime2", "timediff_sec" ]

cw.writerow(header)

for k in templateD.keys():
    r = []
    for h in header:
        try:
            r.append(templateD[k][h])
        except:
            print 'k:' + str(k) + ' h:' + str(h)
    cw.writerow(r)

print "all done"
