#----------------------------------------------------------------------
# Name:         nsfg_networkanalysis_batch_step3.py
# Purpose:      Pull information from the original GPX files and Callnotes.
#               The information is joined into the output.
#
# Created:      2014-07-16
#----------------------------------------------------------------------


import datetime
import csv
import xlrd
import os
import shutil
import arcpy

### the list of selected_PSU and available GPX are sensitive data, so remove from this version ###
available_GPX = []

def read_available_gpx (dir):
    folder = []
    for f in os.listdir(dir):
        if f[0:3] in available_GPX:
            folder.append(f[0:len(f)-4])
    return folder

def convert_excel_time(t):
    if t > 1:
        t = t%1
    seconds = round(t*86400)
    minutes, seconds = divmod(seconds, 60)
    hours, minutes = divmod(minutes, 60)
    if minutes < 10:
        m = "0" + str(int(minutes))
    else:
        m = str(int(minutes))
    if seconds < 10:
        s = "0" + str(int(seconds))
    else:
        s = str(int(seconds))
    time = str(int(hours)) + ":" + m + ":" + s
    timeformat = datetime.datetime.strptime(time, '%H:%M:%S')
    timeformat_converted = timeformat.strftime('%I:%M:%S %p')
    return timeformat_converted

def convert_excel_date (date):
    converttime = datetime.datetime.strptime(str(date), '%Y-%m-%d %H:%M:%S')
    year = str(converttime.timetuple()[0])
    if converttime.timetuple()[1] < 10:
        month = '0' + str(converttime.timetuple()[1])
    else:
        month = str(converttime.timetuple()[1])
    if converttime.timetuple()[2] < 10:
        date = '0' + str(converttime.timetuple()[2])
    else:
        date = str(converttime.timetuple()[2])
    finaldate = year + month + date
    return finaldate

#############################################
#####   Set up Input files and folders  #####
#############################################
dir_routes = r"<Path>\routes\q1" # Folder for snapped GPX files 
dir_callnote = r"<Path>\GPS Files\Calls\Q1" # Folder for call notes
dir_original_gpx = r"<Path>\gpx\q1\xls" # Folder for original GPX excel file. It will be used to read PSU.
outdbf = dir_routes + "\\samplehouse_spjoin_routes_allq1s2_071614.dbf" # output file.

folderList = read_available_gpx(dir_original_gpx)
print folderList

for i in range(0,len(folderList)): 
    IwFolder = folderList[i]
    print "current folder:" + IwFolder
    IwerID = IwFolder[0:3]
    IwDate = IwFolder[4:13]
    tempTime = datetime.datetime.strptime(IwDate, '%Y%m%d')
    CallDate = str(tempTime.strftime("%d%b%Y")).upper()
    
    callnote = dir_callnote + "\\nsfgID_" + IwerID + "_" + CallDate + ".xls"
    #### select sample houses based on the sections visited in callnote ####################
    dCall = {}
    c = 0
    wb = xlrd.open_workbook(callnote)
    sh = wb.sheet_by_name(u'sheet1')
    for rownum in range(1,sh.nrows):
        dCall[c] = {'vProjectId': sh.row_values(rownum,0,1)[0].encode('utf8'),
                    'vSamplelineId':sh.row_values(rownum,1,2)[0].encode('utf8'),
                    'nCallInfoId':sh.row_values(rownum,2,3)[0],
                    'sCallMode':sh.row_values(rownum,3,4)[0].encode('utf8'),
                    'sResultCodeId':sh.row_values(rownum,4,5)[0].encode('utf8'),
                    'dResultDate':sh.row_values(rownum,5,6)[0],
                    'tResultTime':sh.row_values(rownum,6,7)[0],
                    'sInterviewerEmployeeId':sh.row_values(rownum,7,8)[0].encode('utf8'),
                    'nsfgID':sh.row_values(rownum,8,9)[0].encode('utf8'),
                    'vAddressLine1':sh.row_values(rownum,9,10)[0].encode('utf8'),
                    'vAddressLine2':sh.row_values(rownum,10,11)[0].encode('utf8'),
                    'vCity':sh.row_values(rownum,11,12)[0].encode('utf8'),
                    'sState':sh.row_values(rownum,12,13)[0].encode('utf8'),
                    'sPostalCode':sh.row_values(rownum,13,14)[0].encode('utf8'),
                    'Rdate':'',
                    'Rtime':'',
                    'IwerID':IwerID,
                    'IwDate':IwDate,
                    'Section':sh.row_values(rownum,1,2)[0].encode('utf8')[0:7]}
        c = c + 1
    print "dCall length:" + str(len(dCall))

    SectionList = []
    for key in dCall.keys():
        if dCall[key]['Section'] not in SectionList:
            SectionList.append(dCall[key]['Section'])

    for s in range(0,len(SectionList)):
        Section  = SectionList[s]
        origdbf = dir_routes + "\\" + IwFolder + "\\samplehouse_spjoin_routes_" + IwFolder + "_s" + str(s+1) + ".dbf"
        indbf = dir_routes + "\\" + IwFolder + "\\samplehouse_spjoin_routes_" + IwFolder + "_s" + str(s+1) + "_redo.dbf"
        dropField = [ "gpxSpd","CallId", "gpxTime","gpxDate", "ResultCode","CallRTime","CallDate","Addr1","Addr2","FileDate"]
        if os.path.isfile(origdbf):
            arcpy.Copy_management(origdbf, indbf)
            ListField = arcpy.ListFields(indbf)
            joindbf = dir_routes + "\\" + IwFolder + "\\gpx_selected_" + IwFolder + "_s" + str(s) + "_snap.dbf"
            for tField in dropField:
                if tField in ListField:
                    arcpy.DeleteField_management(indbf, tField)
            arcpy.AddField_management(indbf, "gpxSpd", "DOUBLE")
            arcpy.AddField_management(indbf, "gpxTime", "TEXT")
            arcpy.AddField_management(indbf, "gpxDate", "TEXT")
            arcpy.AddField_management(indbf, "CallId", "DOUBLE")
            arcpy.AddField_management(indbf, "ResultCode", "TEXT")
            arcpy.AddField_management(indbf, "CallRTime", "TEXT")
            arcpy.AddField_management(indbf, "CallDate", "TEXT")
            arcpy.AddField_management(indbf, "Addr1", "TEXT")
            arcpy.AddField_management(indbf, "Addr2", "TEXT")
            arcpy.AddField_management(indbf, "FileDate", "TEXT") #### added on 07/16/2014 ####
            fieldList = arcpy.ListFields(joindbf)
            fieldList_check = []
            for field in fieldList:
                fieldList_check.append(field.name)
            joinD = {}
            rows = arcpy.SearchCursor(joindbf) 
            for row in rows:
                gpxSpd = row.speed
                gpxID = row.trkpt_ORDI
                gpxDate = IwFolder
                if 'MDT' in fieldList_check:
                    gpxTime = row.MDT
                elif 'EST' in fieldList_check:
                    gpxTime = row.EST
                elif 'CDT' in fieldList_check:
                    gpxTime = row.CDT
                elif 'EDT' in fieldList_check:
                    gpxTime = row.EDT
                elif 'PDT' in fieldList_check:
                    gpxTime = row.PDT
                elif 'AST' in fieldList_check:
                    gpxTime = row.AST
                elif 'CST' in fieldList_check:
                    gpxTime = row.CST
                elif 'AZT' in fieldList_check:
                    gpxTime = row.AZT
                elif 'EDT_CDT' in fieldList_check:
                    gpxTime = row.EDT_CDT
                elif 'EST_CST' in fieldList_check:
                    gpxTime = row.EST_CST
                #### added on 07/16/2014 ####
                elif 'MST' in fieldList_check:
                    gpxTime = row.MST
                elif 'PST' in fieldList_check:
                    gpxTime = row.PST
                ##############################
                else:
                    print 'please specify the time zone!!!'
                if gpxID not in joinD:
                    joinD[gpxID] = {"gpxSpd":0, "gpxTime":"", "gpxDate":""}
                joinD[gpxID]["gpxSpd"] = gpxSpd
                joinD[gpxID]["gpxTime"] = gpxTime
                joinD[gpxID]["gpxDate"] = gpxDate
            rows2 = arcpy.UpdateCursor(indbf)
            for r in rows2:
                for key in joinD.keys():
                    if r.gpxID == key:
                        r.gpxTime = joinD[key]["gpxTime"]
                        r.gpxDate = joinD[key]["gpxDate"]
                        try:
                            r.gpxSpd = joinD[key]["gpxSpd"]
                        except:
                            print "speed is null"
                for key2 in dCall.keys():
                    if r.combineID == dCall[key2]['vSamplelineId'][0:11] and IwFolder[0:3]+"_"+IwFolder[8:12] == r.callnote:
                        r.CallId = dCall[key2]["nCallInfoId"]
                        r.ResultCode = dCall[key2]["sResultCodeId"]
                        time = convert_excel_time(float(dCall[key2]["tResultTime"]))
                        r.CallRTime = time
                        dateconversion = datetime.datetime(1899, 12, 30) + datetime.timedelta(days = int(dCall[key2]["dResultDate"]) + 1462 * 0)
                        date = convert_excel_date(dateconversion)
                        r.CallDate = date
                        r.Addr1 = dCall[key2]["vAddressLine1"]
                        r.Addr2 = dCall[key2]["vAddressLine2"]
                r.FileDate = IwFolder #### added on 07/16/2014 ####
                rows2.updateRow(r) 

            print indbf + " is done"

mergeList = []
for i in range(0,len(folderList)):
       
    IwFolder = folderList_all[i]
    print "current folder:" + IwFolder
    IwerID = IwFolder[0:3]
    IwDate = IwFolder[4:13]
    tempTime = datetime.datetime.strptime(IwDate, '%Y%m%d')
    CallDate = str(tempTime.strftime("%d%b%Y")).upper()
    
    callnote = dir_callnote + "\\nsfgID_" + IwerID + "_" + CallDate + ".xls"
    #### select sample houses based on the sections visited in callnote ####################
    dCall = {}
    c = 0
    wb = xlrd.open_workbook(callnote)
    sh = wb.sheet_by_name(u'sheet1')
    for rownum in range(1,sh.nrows):
        dCall[c] = {'vProjectId': sh.row_values(rownum,0,1)[0].encode('utf8'),
                    'vSamplelineId':sh.row_values(rownum,1,2)[0].encode('utf8'),
                    'nCallInfoId':sh.row_values(rownum,2,3)[0],
                    'sCallMode':sh.row_values(rownum,3,4)[0].encode('utf8'),
                    'sResultCodeId':sh.row_values(rownum,4,5)[0].encode('utf8'),
                    'dResultDate':sh.row_values(rownum,5,6)[0],
                    'tResultTime':sh.row_values(rownum,6,7)[0],
                    'sInterviewerEmployeeId':sh.row_values(rownum,7,8)[0].encode('utf8'),
                    'nsfgID':sh.row_values(rownum,8,9)[0].encode('utf8'),
                    'vAddressLine1':sh.row_values(rownum,9,10)[0].encode('utf8'),
                    'vAddressLine2':sh.row_values(rownum,10,11)[0].encode('utf8'),
                    'vCity':sh.row_values(rownum,11,12)[0].encode('utf8'),
                    'sState':sh.row_values(rownum,12,13)[0].encode('utf8'),
                    'sPostalCode':sh.row_values(rownum,13,14)[0].encode('utf8'),
                    'Rdate':'',
                    'Rtime':'',
                    'IwerID':IwerID,
                    'IwDate':IwDate,
                    'Section':sh.row_values(rownum,1,2)[0].encode('utf8')[0:7]}
        c = c + 1
    print "dCall length:" + str(len(dCall))

    SectionList = []
    for key in dCall.keys():
        if dCall[key]['Section'] not in SectionList:
            SectionList.append(dCall[key]['Section'])

    for s in range(0,len(SectionList)):
        Section  = SectionList[s]
        indbf = dir_routes + "\\" + IwFolder + "\\samplehouse_spjoin_routes_" + IwFolder + "_s" + str(s+1) + "_redo.dbf"
        if os.path.isfile(indbf):
            mergeList.append(indbf)
            print indbf + " is added"
print "mergeList:" + str(len(mergeList))

arcpy.Merge_management(mergeList, outdbf)

print "all done"
