//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: runs the multinomial logit after CEM

//housekeeping
//The dofiles uses globals to manage lists of variables, charts options, etc.
//These globals are set in a separate do files called: globals.do. These files are invoked by the main do files. 

do globals.do


//program setup
clear all
set linesize 80
 

//it loads the data-set
use $dtapath/01-websurvey-V03.dta, clear

	 
cap drop ls_ls
gen ls_ls = ls 
lab var ls_ls "ls for cem "

******************	
*CEM Procedure*//
******************

*set parameters
local treat tool // set the treatments
local s_w weight_l // set the sample weights

* controls for CEM 
global cem_controls age  sex(#0) ///
	edc2(#0) edc3(#0) edc4(#0) edc5(#0)    ///
	emp2(#0) emp3(#0)  emp4(#0) emp5(#0)  emp6(#0) emp7(#0)   ///
	log_income  anno2(#0) anno3(#0) 

*cem starts

imb $controlsCEM , treatment(`treat') // compute L0 measure of imbalance
local L0 =r(L1)
	cem $cem_controls , treatment(`treat') //
	local L1= r(L1)
	display "`L0'`L1'"
cap drop cnt 
gen cnt = 0
replace cnt = 1 if `treat' == 0 & cem_matched == 1
replace cnt = cnt*`s_w'
la var cnt "Weighted controls"

cap drop mc
egen mc = sum(cnt)

cap drop trt 
gen trt = 0
replace trt = 1 if `treat' == 1 & cem_matched == 1
replace trt = trt*`s_w'
la var cnt "Weighted treated"

cap drop mt
egen mt = sum(trt)
cap drop mts
bys cem_strata : egen mts = sum(trt)
cap drop mcs 
bys cem_strata : egen mcs = sum(cnt)

*gen cem adjusted sample weights
cap drop cem_w_w
gen cem_w_w = trt if trt != 0
replace cem_w_w = (mc/mt)*(mts/mcs) if trt ==0 & cem_matched ==1
replace cem_w_w = 0 if cem_matched ==0

svyset [pweight= cem_w_w] // svy cem


//Table 5: Socio-demographic characteristics before and after CEM procedure.

cap drop esa0
reg ls tool $controlsCEM 
g esa0 = e(sample)
tab esa0 tool

estimates clear
loc vars_cont " "
loc vars_cont "sex age edc1 edc2 edc3 edc4 edc5 emp1 emp2 emp3 emp4 emp5 emp6 emp7 log_income anno1 anno2 anno3" //

**Please, change the path below to match your workind directory 
shell U:/DATA/2_Production/5-Others/Websurvey/ // it opens DOS 
cap copy NUL ../tabs/cem_desc.tex, replace // it creates an empty tex file before the loop

foreach var in `vars_cont' {
local vlab : var l  `var'
qui svyset [pw=`s_w'] // pre CEM
qui eststo `var'1 : svy: reg `var' if `treat' == 1 & esa0 == 1
qui eststo `var'2 : svy: reg `var' `treat' if esa0 == 1
qui svyset [pw=cem_w_w] // post CEM
qui eststo `var'3 : svy: reg `var' if `treat' == 1 & esa0 == 1
qui eststo `var'4 : svy: reg `var' `treat' if esa0 == 1
esttab `var'*  	using 	..\tabs\cem_desc.tex , b(a2) star($STAR) noobs nonote append   ///
mlabels(,none  )  noleg  varlabels(_cons `vlab' ) noline compress //  
}

 
*Computing the right number of osservations (weighted estimations)
svyset [pweight= weight_l] // svy sample weights
svy: tab tool  if esa0 ==1 , count
svyset [pweight= cem_w_w] // svy cem 
svy: tab tool if cem_matched == 1 & esa0 == 1, count // used for tables 5 and 6


** All results from CEM 

svy: mlogit ls tool $controlsCEM if esa0 ==1 ,    diff technique(dfp) 
estimates save cem_ol_est  , replace 

foreach v in 1 2 3 4 5 {
estimates use cem_ol_est 
estimates esample: if esa0 ==1 
estpost margins, dydx(tool $controlsCEM)  vce(unconditional) pr (outcome (#`v')) force 
eststo cem_mlogit`v'_all
}
*

*Table 6: Web survey mode as a predictor of life satisfaction scores. Marginal effects from multinomial logit with CEM.
*only web 
esttab     cem_mlogit*_all ///
using  ..\tabs\01-web_eff_cem-V02.tex , keep(tool) cells(b(star fmt(2)) se(par fmt(3))) noobs ///
 		 title("Effect of web interview on  life satisfaction (Conterfactual)" ) /// 
 addnotes("Notes: CEM for survey data computed according to Riillo (2017)" "Estimations for individuals with Internet access at home" "Robust standard errors in parenthesis * p<.10, ** p<.05, *** p<.01") replace label
 
*Table 14: Web survey mode as a predictor of life satisfaction scores. Marginal effects from multinomial logit with CEM.
*all coefficents 
esttab     cem_mlogit*_all  using  ..\tabs\01-all_eff_cem-V02.tex /**/ , ///
cells(b(star fmt(3)) se(par fmt(3))) noobs ///
 		 title("Predictors on  life satisfaction (CEM)" ) /// 
 addnotes("Notes: Estimations for individuals with Internet access at home; Some controls have missing values and decrease sample size; CEM Robust standard errors  in parentesies * p<.10, ** p<.05, *** p<.01") ///
 replace  label ///
refcat( edc2 "Elementary education" emp2 "Full-time employed" ///
		anno2 "year 2013" ) 


				
**************
* chow test 
*****************
ologit ls  sex##tool ddage_2##tool ddage_3##tool ddage_4##tool ddage_5##tool ///
			edc2##tool edc3##tool edc4##tool edc5##tool ///
			emp2##tool emp3##tool emp4##tool emp5##tool emp6##tool emp7##tool ///
			ddlog_income_2##tool  ddlog_income_3##tool ddlog_income_4##tool ddlog_income_5##tool  ///
			anno2##tool anno3##tool [pweight=weight] , vce(robust)	
cap drop _esa
g _esa = 1 if e(sample) //  I need to recall the right sample for repeted margins 
estimates save ol_est  , replace
	
estimates use ol_est  // use estimates of ologit
estimates esample: if _esa ==1 	
eststo  wtest: contrast tool#i.(sex ddage_2 ddage_3 ddage_4 ddage_5	 ///
						edc2	edc3 	edc4 	edc5	///
						emp2 	emp3 	emp4 	emp5 emp6 emp7 ///	
						ddlog_income_2 ddlog_income_3 ddlog_income_4 ddlog_income_5 ///
						anno2 anno3), overall post nosvyadjust 
				
estout wtest using $tabpath/Chow-test-$ver.tex, cell("df chi2(fmt(a2)) " ) ///
 title(Wald test of interactions of web mode)    m  replace    label 	///					
varlabels(c1 Woman c2 "age:30-39" c3 "age:40-47" c4 "age:48-55" c5 "age:56-64" ///
 c6 "Secondary education" c7 "Master craftsman" c8 "Bachelor" c9 "Master" ///
 c10 "part-time employed" c11 "Self-employed" c12 "Retired or disabled" c13 "Homemaker" c14 "Student" c15 "Not working, other" ///
 c16 "Second income quintile" c17 "Third income quintile" c18 "Forth income quintile" ///
c19 "Firth income quintile"  c20 "year 2014" c21 "year 2015" c22 "Overall" )  			

*testparm is the same than chow test
testparm tool#i.(sex ddage_2 ddage_3 ddage_4 ddage_5	 ///
						edc2	edc3 	edc4 	edc5	///
						emp2 	emp3 	emp4 	emp5 emp6 emp7 ///	
						ddlog_income_2 ddlog_income_3 ddlog_income_4 ddlog_income_5 ///
						anno2 anno3)	
						
						
///////////////////// Appendix	 
//Differences by survey mode
//// Ls and alternative measures of SWB	(only outcome 5 )
///////////////////////////
loc vars " "
loc vars  "ls wlexl wlidl wlimp wlchn" // recode alternative measures of SWB
foreach v of loc vars{
estimates clear
lab values `v' wlidl
cap drop ls_`v'
gen ls_`v' = `v'
replace ls_`v' = . if `v' < 0
lab values ls_`v' wlidl
}

foreach j of loc vars{
*no need to recompute the cem because treatment is the same for all dep varible

ologit ls_`j'  sex##tool ddage_2##tool ddage_3##tool ddage_4##tool ddage_5##tool ///
			edc2##tool edc3##tool edc4##tool edc5##tool ///
			emp2##tool emp3##tool emp4##tool emp5##tool emp6##tool emp7##tool ///
			ddlog_income_2##tool  ddlog_income_3##tool ddlog_income_4##tool ddlog_income_5##tool  ///
			anno2##tool anno3##tool [pweight=weight] , vce(robust)	
			
cap drop _esa_`j'
g _esa_`j' = 1 if e(sample) //  I need to recall the right sample for calling margins 
estimates save ol_est_`j'  , replace

local var tool $controlsSWB_ //  variables to compute marginal effect on swb

*margins of who used the tel
	estpost  margins, dydx(`var') subpop(if tool==0) vce(unconditional) pr (outcome (#5))  	
eststo ol_comp_tel_`j'

*margins of who used the web
estimates use ol_est_`j' 
estimates esample: if _esa_`j' ==1 
	 margins, dydx(`var') subpop(if tool==1) vce(unconditional) pr (outcome (#5))  post
eststo ol_comp_web_`j' 

*see if difference among tel and web are statistically significant
estimates use ol_est_`j'  
estimates esample: if _esa_`j' ==1 

margins , dydx(`var') over(r.tool) vce(unconditional) pr (outcome (#5)) post force
eststo ol_comp_tel_vs_web_`j'

//Table 9 - Table 10 - Table 11 - Table 12 - Table 13 
*compute tabs
 esttab ol_comp_tel_`j' ol_comp_web_`j'  ol_comp_tel_vs_web_`j' ///
 using  ..\tabs\A_ol_comparison_`j'.tex /**/ , ///cells(b(star fmt(3)) se(par fmt(3)))
   mtitle("Telephone " "Web" "Difference Tel-Web")   /// unstack
 		 title("Predictors of _`j' in web and telephone samples" ) star ($STAR) wide  /// 
		label replace keep( 1.*  1.*:r1vs0.tool)  legend varlabels(r1vs0.tool " " ) ///
		 refcat(1.ddage_2  "Age: 18-29" 1.edc2 "Elementary education" 1.emp2 "Full-time employed" ///
		 1.ddlog_income_2 "First income quintile" 1.anno2 "year 2013" )  width(\textwidth) ///
		 note("Weighted estimations and robust standard errors in parentesis. All variables are interacted with the survey mode") ///
		 addnote("Source: Global Entrepreneurship Monitor, Luxembourg, 2013-2015.")
}
*

///////////////////// ONLINE APPENDIX //////////////////////////////////////////////////////////	 
//CEM Robustness checks all measures of wellbeing, all level, all variables, with estimates   //	
////////////////////////////////////////////////////////////////////////////////////////////////
**Please, change the paths below to match your workind directory 

shell U:/DATA/2_Production/5-Others/Websurvey/ // open dos 
cap copy NUL ../tabs/cem_rob.tex, replace // crate an empty tex file before the loop

loc vars ls wlidl wlimp wlchn wlexl // 
foreach j of loc vars{ 
shell U:/DATA/2_Production/5-Others/Websurvey/ // open dos 
cap copy NUL ../tabs/A_cem_`j'_all.tex, replace // crate an empty tex file before the loop

shell U:/DATA/2_Production/5-Others/Websurvey/ // open dos 
cap copy NUL ../tabs/cem_`j'_only_tool.tex, replace // crate an empty tex file before the loop
}
foreach j of loc vars{ 

svyset [pw=cem_w_w]
eststo ol_est_`j' : svy: mlogit ls_`j' tool $controlsCEM ,    diff technique(dfp)
estimates save ol_est_`j' , replace
scal Obs_`j' = e(N_pop)
estadd sca  Obs_`j' = e(N_pop)


cap drop _esa_`j'
g _esa_`j' = 1 if e(sample) //  I need to recall the right sample for repeated margins 

// all estimates
*
esttab   ol_est_`j'  ///
 using  ..\tabs\cem_`j'_estimates.tex , cells(b(star fmt(3)) se(par fmt(3))) ///
 		 title("Etimates Effect of web interview on  `j' (Conterfactual)" ) /// 
		append label noline noleg  stats(Obs_`j' , labels("Observation" )) 

foreach v in 1  2 3 4 5 /**/ { // compute for all levels of dep var 
estimates use ol_est_`j' 
estimates esample: if _esa_`j' ==1 
estpost margins, dydx(tool $controlsCEM )  vce(unconditional) pr (outcome (#`v')) force
eststo cem_mlogit`j'`v'
estadd sca Obs_`j'
}
// Table 14, Table 15 Table 16 Table 17 Table 18
*Marginal effects from multinomial logit with CEM.Web survey mode as a predictor of XXXX 

esttab    	cem_mlogit`j'1 ///
			cem_mlogit`j'2 ///
			cem_mlogit`j'3 ///
			cem_mlogit`j'4 ///
			cem_mlogit`j'5 ///
 using  ..\tabs\A_cem_`j'_all.tex , cells(b(star fmt(3)) se(par fmt(3))) ///
 		 title("AME of all variables on  on  `j' (Conterfactual) " ) /// 
		append label noline noleg stats(Obs_`j' , labels("Observation" )) 

//Table 8: Web survey mode as a predictor of subjective well-being scores. Marginal effects from multinomial logit after CEM. 
*only tool (margins) 
esttab     cem_mlogit`j'1 ///
			cem_mlogit`j'2 ///
			cem_mlogit`j'3 ///
			cem_mlogit`j'4 ///
			cem_mlogit`j'5 ///
 using  ..\tabs\cem_`j'_only_tool.tex , cells(b(star fmt(3)) se(par fmt(3))) ///
 		 title("AME of web interview on  `j' (Conterfactual) " ) /// 
		 label noline noleg keep(tool) append stats(Obs_`j' , labels("Observation" )) 
		}


