//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: Studies what predicts the participation in the web rather than in the telephone survey

//housekeeping
//The dofiles uses globals to manage lists of variables, charts options, etc.
//These globals are set in a separate do file called: globals.do. This file is invoked by the main do files. 

do globals.do


//program setup
clear all
set linesize 80
 

//it loads the data-set
use $dtapath/01-websurvey-V03.dta, clear

//Table 3: Predictors of participation in the web rather than in the telephone survey. Marginal effects after ordered probit regression


estimates clear
eststo est3: xi: probit tool  $controls  , vce(robust)
estpost margins, dydx(*) 
eststo marg3
eststo est1: xi: probit tool  sex age age2 i.year if e(sample), vce(robust)
estpost margins, dydx(*) 
eststo marg1
eststo est2: xi: probit tool  sex age age2 edc2 edc3 edc4 edc5   emp2 emp3 emp4 emp5 emp6 emp7 i.year if e(sample), vce(robust)
estpost margins, dydx(*) 
eststo marg2

esttab marg1 marg2 marg3 using $tabpath/marg-plot-tool-$ver.tex, b(%9.2f)  f  width(\textwidth) m ///
	mtitle("model 1" "model 2" "model 3")  replace   nolines wide label  	
