//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: Housekeeping

//The dofiles saves its output to various subfolders: 
//datasets go in the subfolder "data"
//charts go in the subfolder "gph"
//tables go in the subfolder "tabs"

global dtapath " "
global dtapath "../data"
global docpath " "
global docpath "../docs"
global gphpath " "
global gphpath "../gph"
global tabpath " "
global tabpath "../tabs"

//the following globals associates the usual levels of significance to the number of stars usually shown in tables. This global is used to output tables in latex.
global STAR " "
global STAR " * 0.1 ** 0.05 *** 0.01"


//the following globals are used to change the look of the charts
global gphopt " "
global gphopt "plotregion(lstyle(none)) scheme(s1mono)"
global noriquad " "
global noriquad "region(lstyle(none))"


//the following globals are used to manage the list of variables across models
global controls " "
global controls "sex age age2 edc2 edc3 edc4 edc5   emp2 emp3 emp4 emp5 emp6 emp7 log_income i.year"

global controlsCEM " "
global controlsCEM "sex age age2 edc2 edc3 edc4 edc5  emp2 emp3 emp4 emp5 emp6  emp7 log_income anno2 anno3"

global controlsSWB " "
global controlsSWB "sex ddage_2 ddage_3 ddage_4 ddage_5  edc2 edc3 edc4 edc5   emp2 emp3 emp4 emp5 emp6 emp7 ddlog_income_2 ddlog_income_3 ddlog_income_4 ddlog_income_5    i.year"

global controlsSWB_ " "
global controlsSWB_ "sex ddage_2 ddage_3 ddage_4 ddage_5  edc2 edc3 edc4 edc5   emp2 emp3 emp4 emp5 emp6 emp7 ddlog_income_2 ddlog_income_3 ddlog_income_4 ddlog_income_5    anno2 anno3"


global controlsSWB_cont " "
global controlsSWB_cont  "i.sex c.age##c.age i.edc2 i.edc3 i.edc4 i.edc5 i.emp2 i.emp3 i.emp4 i.emp5 i.emp6  i.emp7 c.log_income i.year"
