//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: Blinder-Oaxaca decomposition

//housekeeping
//The dofiles uses globals to manage lists of variables, charts options, etc.
//These globals are set in a separate do files called: globals.do. These files are invoked by the main do files. 

do globals.do


//program setup
clear all
set linesize 80
 

//it loads the data-set
use $dtapath/01-websurvey-V03.dta, clear


//create a new dummy variable to replace tool in the decomposition
//the reason is that nldecompose makes the decomposition for 2 groups A and B
//where A is the high group and B the low group. The by() option requires
//a dummy that takes value 0 for the B group and 1 for the A group.
cap drop tool2
gen tool2 = .
replace tool2 = 0 if tool == 1
replace tool2 = 1 if tool == 0
lab define tool2 0 "web-survey", modify
lab define tool2 1 "telephone", modify
lab values tool2 tool2

xi: nldecompose, by(tool2) omega(neumark) regoutput   bootstrap bsoptions(reps(10) seed(553721)) : ///
	ologit ls $controls

save $dtapath/04-websurvey-01.dta, replace
 
use $dtapath/04-websurvey-01.dta, clear

//Table 4: Blinder-Oaxaca decomposition of the life satisfaction gap by survey mode.

tempname oaxacaLS1
postfile `oaxacaLS1'  str15 Var1 coefficient zstat pvalue using "$dtapath/oaxacaLS1.dta", replace 
xi: nldecompose, by(tool2) omega(neumark) regoutput  bootstrap bsoptions(reps(10) seed(553721)): ///
	oprobit ls $controls
mat A = r(bootstrap)	
mat list A	
loc sig = A[3,1]
loc pvalue = A[4,1]
post `oaxacaLS1' ("Difference:")  (r(raw)) (`sig') (`pvalue')
postclose `oaxacaLS1'

tempname oaxacaLS2
postfile `oaxacaLS2'  str15 Var1   coefficient   zstat pvalue using "$dtapath/oaxacaLS2.dta", replace 
loc emp = .
post `oaxacaLS2' ("Decomposition:")  (`emp')  	(`emp')  (`emp')
postclose `oaxacaLS2'

tempname oaxacaLS3
postfile `oaxacaLS3'  str15 Var1 coefficient zstat pvalue using $dtapath/oaxacaLS3.dta, replace 
xi: nldecompose, by(tool2) omega(neumark) regoutput  bootstrap bsoptions(reps(10) seed(553721)): ///
	oprobit ls $controls
mat A = r(bootstrap)	
mat list A		

loc zprod = A[3,6]
loc pprod = A[4,6]
loc zadv = A[3,7]
loc padv = A[4,7]
loc zdisadv = A[3,8]
loc pdisadv = A[4,8]
loc numb = r(obsA) + r(obsB)
loc emp = .
post `oaxacaLS3' ("Explained")  (r(prod))  (`zprod') (`pprod')
post `oaxacaLS3' ("Telephone")  (r(adv))   (`zadv') (`padv')
post `oaxacaLS3' ("Web-survey")  (r(disadv))   (`zdisadv') (`pdisadv')
post `oaxacaLS3' ("Observations")  (`numb')  (`emp')  (`emp')
postclose `oaxacaLS3'

//produce the table
use $dtapath/oaxacaLS1.dta, clear 
append using $dtapath/oaxacaLS2.dta"
append using $dtapath/oaxacaLS3.dta"
format coefficient zstat pvalue %9.3fc
save $dtapath/04-oaxacaLS-V01.dta, replace 

cd $tabpath 
dataout, save(04-oaxacaLS-V01) tex replace dec(3)  
cd ../tmp


// Table 7: Blinder-Oaxaca deomposition of subjetive well-being gap by survey mode. Alternative measures of well-being.

//oaxaca decomposition
loc vars " "
loc vars " wlexl wlidl"
foreach v of loc vars{

//here starts the code to produce the table with the results of the decomposition 
estimates clear
use $dtapath/01-websurvey-V03.dta, clear
tempname oaxacaLS1
postfile `oaxacaLS1'  str15 Var1 coefficient zstat pvalue using "$dtapath/oaxacaLS1.dta", replace 
xi: nldecompose, by(tool2) omega(neumark) regoutput  bootstrap bsoptions(reps(10) seed(553721)): ///
	oprobit ls_`v' $controls
mat A = r(bootstrap)	
mat list A	
loc sig = A[3,1]
loc pvalue = A[4,1]
post `oaxacaLS1' ("Difference:")  (r(raw)) (`sig') (`pvalue')
postclose `oaxacaLS1'

tempname oaxacaLS2
postfile `oaxacaLS2'  str15 Var1   coefficient   zstat pvalue using "$dtapath/oaxacaLS2.dta", replace 
loc emp = .
post `oaxacaLS2' ("Decomposition:")  (`emp')  	(`emp')  (`emp')
postclose `oaxacaLS2'

tempname oaxacaLS3
postfile `oaxacaLS3'  str15 Var1 coefficient zstat pvalue using $dtapath/oaxacaLS3.dta, replace 
xi: nldecompose, by(tool2) omega(neumark) regoutput  bootstrap bsoptions(reps(10) seed(553721)): ///
	oprobit ls_`v' $controls
mat A = r(bootstrap)	
mat list A		

loc zprod = A[3,6]
loc pprod = A[4,6]
loc zadv = A[3,7]
loc padv = A[4,7]
loc zdisadv = A[3,8]
loc pdisadv = A[4,8]
loc numb = r(obsA) + r(obsB)
loc emp = .
post `oaxacaLS3' ("Explained")  (r(prod))  (`zprod') (`pprod')
post `oaxacaLS3' ("Telephone")  (r(adv))   (`zadv') (`padv')
post `oaxacaLS3' ("Web-survey")  (r(disadv))   (`zdisadv') (`pdisadv')
post `oaxacaLS3' ("Observations")  (`numb')  (`emp')  (`emp')
postclose `oaxacaLS3'

//produce the table
use $dtapath/oaxacaLS1.dta, clear 
append using $dtapath/oaxacaLS2.dta
append using $dtapath/oaxacaLS3.dta
format coefficient zstat pvalue %9.3fc
save $dtapath/$num-oaxaca-ls_`v'-$ver.dta, replace 
cd $tabpath 
dataout, save(04-oaxaca-ls_`v'-V01) tex replace dec(3)  
cd ../tmp
}	


