//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: It converts the original sav data from 2013, 2014, and 2015 in dta format, and it generates long-format dta.

//housekeeping
//The dofiles uses globals to manage lists of variables, charts options, etc.
//These globals are set in a separate do file called: globals.do. This file is invoked by the main do files. 

do globals.do


//program setup
clear all
set linesize 80
 
//loads the dataset in memory: it converts sav in dta and sets all characters to minuscule

//Year: 2013
usespss "$dtapath/GEM 2013 APS Luxembourg Individual Level Data_9Dec.sav", clear // 
foreach var of varlist _all{
qui rename `var' `=lower("`var'")'
}
gen year = 2013
save $dtapath/00-GEM2013-V01.dta, replace

//Year: 2014
usespss "$dtapath/GEM 2014 APS Luxembourg Individual Level Data_7Nov.sav", clear // 
foreach var of varlist _all{
qui rename `var' `=lower("`var'")'
}
gen year = 2014
save $dtapath/00-GEM2014-V01.dta, replace

//Year: 2015
usespss "$dtapath/GEM 2015 APS Luxembourg Individual Level Data_24Dec.sav", clear // 
foreach var of varlist _all{
qui rename `var' `=lower("`var'")'
}
gen year = 2015
save $dtapath/00-GEM2015-V01.dta, replace

//it appends all the data-sets in a single file
use $dtapath/00-GEM2013-V01, clear
append using $dtapath/00-GEM2014-V01.dta $dtapath/00-GEM2015-V01.dta

//it saves the single file
save $dtapath/00-websurvey-V01, replace
