//project: Comparability of web and telephone survey modes for the measurement of subjective well-being
//task: prepares graphs and descriptive statistics

//housekeeping
//The dofiles uses globals to manage lists of variables, charts options, etc.
//These globals are set in a separate do file called: globals.do. This file is invoked by the main do files. 

do globals.do


//program setup
clear all
set linesize 80
 

//it loads the data-set
use $dtapath/01-websurvey-V03.dta, clear

//Test that the distribution of life satisfaction using web-survey is statistically different from the distribution issued by the telephone survey
//for life satisfaction
ttest ls, by(tool)
ksmirnov ls, by(tool)	

//Figure 1: Distribution of life satisfaction by survey mode
hist wlslf, by(tool) percent  legend(off) addl addlabopts(yvarformat(%9.2f)) $gphopt discrete xlabel(-2(1)5, labels  ///
	labsize(small) angle(forty_five) format(%12s) valuelabel alternate)
graph save Graph $gphpath/02-wlslfhist-V01.gph, replace
graph export $gphpath/02-wlslfhist-V01.eps, as(eps) preview(off) replace

//for the other proxies of subjective well-being
lab define wlidl -1 "Don't know", modify
lab define wlidl 5 "Strongly Agree", modify
lab values wlslf wlidl

loc vars " "
loc vars "wlimp wlchn wlexl wlidl"
foreach v of loc vars{
lab values `v' wlidl
cap drop ls_`v'
gen ls_`v' = `v'
replace ls_`v' = . if `v' < 0
lab values ls_`v' wlidl
ttest ls_`v', by(tool)	
ksmirnov ls_`v', by(tool)	
}


//Charts for Appendix A: Distribution of socio-demographic variables  in the telephone and web samples

//Figure 2: distribution of gender by survey mode
catplot sex tool , percent (tool) stack asyvars $gphopt ///
blabel(bar , pos(base) size(2) color(white) format(%9.2f) orientation(rvertical))
graph export $gphpath/02-cat-sex-V01.eps, as(eps) preview(off) replace

//Figure 3: distribution of education by survey mode
catplot education tool , percent (tool) stack asyvars $gphopt ///
blabel(bar , pos(base) size(2) color(white) format(%9.2f) orientation(rvertical))  
graph export $gphpath/02-cat-educ-V01.eps, as(eps) preview(off) replace

//Figure 4: Distribution of age by survey mode
lab var age "age (in years)"
hist age, by(tool) discrete  xlabel(15(10)65) $gphopt
graph save Graph $gphpath/02-dist-age-cont-V01.gph, replace
graph export   $gphpath/02-dist-age-cont-V01.eps, as(eps) preview(off)  replace

//Figure 5: Distribution of income by survey mode
hist log_income,  by(tool) $gphopt
graph save Graph $gphpath/02-dist-hhinc-cont-V01.gph, replace
graph export   $gphpath/02-dist-hhinc-cont-V01.eps, as(eps) preview(off) replace


//Figure 6: Distribution of employment status by survey mode
foreach v of numlist 1 2 3 4 5 6 7{
loc capt: var l  emp`v'
display "the var is: `capt'"
d emp`v'
histogram emp`v', discrete xlabel(0(1)1, labels ///
	labsize(vsmall)   format(%12s) valuelabel alternate) ///
	by(tool, note("")) $gphopt 
graph save Graph "$gphpath/02-occu`v'-V01.gph", replace
graph save Graph "$gphpath/02-occu`v'-V01.eps", replace
}

graph combine $gphpath/02-occu1-V01.gph $gphpath/02-occu2-V01.gph ///
			  $gphpath/02-occu3-V01.gph $gphpath/02-occu4-V01.gph ///
			  $gphpath/02-occu6-V01.gph ///
			  $gphpath/02-occu5-V01.gph $gphpath/02-occu7-V01.gph, $gphopt  cols(2)  iscale(*1.1) 
graph save Graph $gphpath/02-dist-emp-cont-V01.gph, replace
graph export $gphpath/02-dist-emp-cont-V01.eps,   as(eps) preview(off)  replace

//Charts for Appendix B: Distribution of alternative measures of well-being in the telephone and web samples	
//Figures 7 - 10
loc vars " "
loc vars "wlimp wlchn wlexl wlidl"
foreach v of loc vars{
catplot  ls_`v' tool , percent (tool) stack asyvars $gphopt  ///
blabel(bar , pos(base) size(2) color(white) format(%9.2f) orientation(rvertical)) ///
legend($noriquad col(2) ) 
graph export $gphpath/02-row`v'-V01.eps, as(eps) preview(off) replace
}


//Descriptive statistics for Section: 3. Data

//Table 1: correlation matrix of the measures of subjective well-being
pwcorr wl*, sig
	
//Table 2: Descriptive statistics
loc vars " "
loc vars " sex age age2 edc1 edc2 edc3 edc4 edc5 emp1 emp2 emp3 emp4 emp5 emp6 emp7 log_income year"
use $dtapath/01-websurvey-V03.dta, clear

tempname miss
postfile `miss'  str50 variable mean sd min max obs   using $dtapath/02-websurvey-desc-V01.dta, replace 
	foreach v of loc vars{
	loc varlab : variable label `v'
	cap drop mis`v' 
	gen mis`v' = (`v' == .)  
	sum mis`v'   
	sum `v'  
	post `miss' ("`varlab'") (r(mean)) (r(sd)) (r(min)) (r(max)) (r(N))  
	}
postclose `miss'

use  $dtapath/02-websurvey-desc-V01.dta, clear 
format mean sd min max   %9.2fc
format obs %9.0fc
save $dtapath/02-websurvey-desc-V01.dta, replace 
cd $tabpath 
dataout, save(02-websurvey-desc-V01) tex replace
cd ../tmp


