*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

*Spatial-lag models (zip codes; with random allocation) 


* prepare matrices based on random allocation (8 iterations)

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 333;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;


spmat idistance w_idist_plz_random1 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random1 using w_idist_plz_random1.spmat, replace;
spmat export w_idist_plz_random1 using w_idist_plz_random1.txt, replace;


clear;
clear mata;


#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 338;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;

spmat idistance w_idist_plz_random2 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random2 using w_idist_plz_random2.spmat, replace;
spmat export w_idist_plz_random2 using w_idist_plz_random2.txt, replace;


clear;
clear mata;



#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 478;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;

spmat idistance w_idist_plz_random3 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random3 using w_idist_plz_random3.spmat, replace;
spmat export w_idist_plz_random3 using w_idist_plz_random3.txt, replace;


clear;
clear mata;


#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 495;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;


spmat idistance w_idist_plz_random4 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random4 using w_idist_plz_random4.spmat, replace;
spmat export w_idist_plz_random4 using w_idist_plz_random4.txt, replace;


clear;
clear mata;



#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 846;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;

spmat idistance w_idist_plz_random5 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random5 using w_idist_plz_random5.spmat, replace;
spmat export w_idist_plz_random5 using w_idist_plz_random5.txt, replace;


clear;
clear mata;


#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 265;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;


spmat idistance w_idist_plz_random6 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random6 using w_idist_plz_random6.spmat, replace;
spmat export w_idist_plz_random6 using w_idist_plz_random6.txt, replace;


clear;
clear mata;


#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 138;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;


spmat idistance w_idist_plz_random7 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random7 using w_idist_plz_random7.spmat, replace;
spmat export w_idist_plz_random7 using w_idist_plz_random7.txt, replace;


clear;
clear mata;



#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


reshape long x_plz_split y_plz_split, i(persnr) j(cell_numb); 

set seed 836;

bys persnr: gen random=runiform();

bys persnr: egen t=max(random);

bys persnr: keep if random==t;

drop random t;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 

gen x_plz_split_ind=x_plz_split+verschiebung_plz;


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;


spmat idistance w_idist_plz_random8 x_plz_split_ind y_plz_split, id(id)  replace;
spmat save w_idist_plz_random8 using w_idist_plz_random8.spmat, replace;
spmat export w_idist_plz_random8 using w_idist_plz_random8.txt, replace;


clear;
clear mata;



*models;

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use temp1_plz;


* random1;
spmat use w_idist_plz_random1 using w_idist_plz_random1.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random1) elmat(w_idist_plz_random1) id(id) heteroskedastic;


* random2;
spmat use w_idist_plz_random2 using w_idist_plz_random2.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random2) elmat(w_idist_plz_random2) id(id) heteroskedastic;



* random3;
spmat use w_idist_plz_random3 using w_idist_plz_random3.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random3) elmat(w_idist_plz_random3) id(id) heteroskedastic;



* random4;
spmat use w_idist_plz_random4 using w_idist_plz_random4.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random4) elmat(w_idist_plz_random4) id(id) heteroskedastic;




* random5;
spmat use w_idist_plz_random5 using w_idist_plz_random5.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random5) elmat(w_idist_plz_random5) id(id) heteroskedastic;




* random6;
spmat use w_idist_plz_random6 using w_idist_plz_random6.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random6) elmat(w_idist_plz_random6) id(id) heteroskedastic;


* random7;
spmat use w_idist_plz_random7 using w_idist_plz_random7.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random7) elmat(w_idist_plz_random7) id(id) heteroskedastic;


* random8;
spmat use w_idist_plz_random8 using w_idist_plz_random8.spmat;

spreg gs2sls log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_random8) elmat(w_idist_plz_random8) id(id) heteroskedastic;









