*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

*Computing and plotting Moran's I values

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";
	
set logtype text; 


use srm_master;


bys plz_kz: gen plz_ver=_n;

gen x_plz_ind=x_plz+plz_ver;


bys gem_kz: gen gem_ver=_n;

gen x_gem_ind=x_gem+gem_ver;


bys kreis_kz: gen kreis_ver=_n;

gen x_kreis_ind=x_kreis+kreis_ver;


bys ror11: gen ror_ver=_n;

gen x_ror_ind=x_ror+ror_ver;

gen id=_n;

drop if x_gem_ind==.;


spmat idistance w_plz x_plz_ind y_plz, id(id) replace;
spmat save w_plz using w_plz.spmat, replace;
spmat idistance w_gem x_gem_ind y_gem, id(id) replace;
spmat save w_gem using w_gem.spmat, replace;
spmat idistance w_kreis x_kreis_ind y_kreis, id(id) replace;
spmat save w_kreis using w_kreis.spmat, replace;
spmat idistance w_ror x_ror_ind y_ror, id(id) replace;
spmat save w_ror using w_ror.spmat, replace;



egen zdepend=std(log_std_brutto);


spmat use w_ror using w_ror.spmat;

spmat lag brutto_ror_lag w_ror log_std_brutto;

egen zlag_ror=std(brutto_ror_lag);

graph twoway scatter zlag_ror zdepend || lfit zlag_ror zdepend, graphregion(color(white));
graph save moran_ror, replace;

reg zdepend zlag_ror;


spmat use w_gem using w_gem.spmat;

spmat lag brutto_gem_lag w_gem log_std_brutto;

egen zlag_gem=std(brutto_gem_lag);

graph twoway scatter zlag_gem zdepend || lfit zlag_gem zdepend, graphregion(color(white)) ;
graph save moran_gem, replace;

reg zdepend zlag_gem;


spmat use w_plz using w_plz.spmat;

spmat lag brutto_plz_lag w_plz log_std_brutto;

egen zlag_plz=std(brutto_plz_lag);

graph twoway scatter zlag_plz zdepend || lfit zlag_plz zdepend, graphregion(color(white)) ;
graph save moran_plz, replace;

reg zdepend zlag_plz;


spmat use w_kreis using w_kreis.spmat;

spmat lag brutto_kreis_lag w_kreis log_std_brutto;

egen zlag_kreis=std(brutto_kreis_lag);

graph twoway scatter zlag_kreis zdepend || lfit zlag_kreis zdepend, graphregion(color(white)) ;
graph save moran_kreis, replace;

reg zdepend zlag_kreis;


