*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

* Descriptives

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";

set logtype text;


use srm_master;


sum log_std_brutto biljahre age  betriebdauer alo;  


tab1 sex2 migrant2 famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 unter_gr4 sektor1 sektor2 sektor3;


bys plz_kz: gen anzahl_plz=_n;
bys gem_kz: gen anzahl_gem=_n;
bys kreis_kz: gen anzahl_kreis=_n;
bys ror11: gen anzahl_ror=_n;

tab anzahl_plz if anzahl_plz==1;
tab anzahl_gem if anzahl_gem==1;
tab anzahl_kreis if anzahl_kreis==1;
tab anzahl_ror if anzahl_ror==1;


bys plz_kz: egen eink_plz=mean(log_std_brutto);
bys gem_kz: egen eink_gem=mean(log_std_brutto);
bys kreis_kz: egen eink_kreis=mean(log_std_brutto);
bys ror11: egen eink_ror=mean(log_std_brutto);


sum eink_plz eink_gem eink_kreis eink_ror;

bys plz_kz: gen n_plz=_N;
bys gem_kz: gen n_gem=_N;
bys kreis_kz: gen n_kreis=_N;
bys ror11: gen n_ror=_N;

save temp1, replace;

bys plz_kz: keep if _n==1;
sum n_plz;

clear;

use temp1;

bys gem_kz: keep if _n==1;
sum n_gem;

clear;

use temp1;

bys kreis_kz: keep if _n==1;
sum n_kreis;

clear;

use temp1;

bys ror11: keep if _n==1;
sum n_ror;

