*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

*GWR model and graph (districts)



#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;	


*gwr;

gwr log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, east(x_kreis) north(y_kreis) saving(gwr_kreis) outfile(gwr_kreis) reps(50) sample(30) replace;


clear;


* aggregate results within districts

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use gwr_kreis;


bys east north: keep if _n==1;


rename east x_kreis;
rename north y_kreis;


rename biljahre biljahre_gwr;
rename sex2 sex2_gwr;
rename migrant2 migrant2_gwr; 
rename age age_gwr; 
rename famst2 famst2_gwr; 
rename vollz1 vollz1_gwr; 
rename unter_gr1 unter_gr1_gwr; 
rename unter_gr2 unter_gr2_gwr; 
rename unter_gr3 unter_gr3_gwr; 
rename betriebdauer betriebdauer_gwr; 
rename alo alo_gwr; 
rename sektor1 sektor1_gwr; 
rename sektor3 sektor3_gwr;
rename cons cons_gwr;


save temp_kreis_gwr, replace;


use srm_master;

keep kreis_kz x_kreis y_kreis;

merge m:1 x_kreis y_kreis using temp_kreis_gwr; 
drop if _merge==2;
drop _merge;


bys x_kreis y_kreis: keep if _n==1;


keep kreis_kz biljahre_gwr - cons_gwr;


save gwr_results, replace;

*********************************************************;

*Output to be inspected and edited by GSOEP Data Center;


*********************************************************;


*graph;

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";

use datab_kreis;

merge 1:1 id_kreis using datab_kreis2;
drop if kreis_kz==.;
drop _merge;

merge 1:1 kreis_kz using gwr_results_checked;


spmap migrant2_gwr using datacoord_kreis, id(id_kreis) graphregion(color(white)) fcolor("190 0 0" orange_red eltblue blue) clmethod(custom) clbreaks(-.15 -.1 0 .1 .15) name(migrant2_gwr, replace);
graph export migrant2_gwr.pdf,  replace;

spmap sex2_gwr using datacoord_kreis, id(id_kreis)  graphregion(color(white))  fcolor("139 0 0" "190 0 0" orange_red orange) clmethod(custom) clbreaks(-.25 -.20 -.15 -.1 -.045) name(sex2_gwr, replace);
graph export sex2_gwr.pdf, replace;


spmap biljahre_gwr using datacoord_kreis, id(id_kreis)  graphregion(color(white))  fcolor(ltblue eltblue midblue blue) clmethod(custom) clbreaks(.05 0.075 0.1 0.125 0.15) name(biljahre_gwr, replace);
graph export biljahre_gwr.pdf, replace;


graph combine biljahre_gwr sex2_gwr migrant2_gwr, rows(1) iscale(.45);


















