*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

*Spatial-lag models (ZIP codes; with geo-centered allocation)

#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use srm_master;


* calculate and transform matrices;

bys plz_kz: gen verschiebung_plz=_n;

gen x_plz_ind= x_plz+verschiebung_plz; 


gen double bplz = sqrt( (x_plz_ind-x_plz_ind[1])^2 + (y_plz-y_plz[1])^2 );

sort bplz;

gen id=_n;

save temp1_plz, replace;

spmat idistance w_idist_plz x_plz_ind y_plz, id(id) replace;
spmat save w_idist_plz using w_idist_plz.spmat, replace;
spmat export w_idist_plz using w_idist_plz.txt, replace;


#delimit;																	
set more off;								

capture log close; 													
		
cd "PFAD";

clear mata;
set maxvar 10000;

insheet using w_idist_plz.txt, delimiter(" ") clear;


foreach c of numlist 2/1000{;
replace v`c'=1/v`c'; 
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
;
}
;

foreach c of numlist 1001/2000{;
replace v`c'=1/v`c'; 
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 2001/3000{;
replace v`c'=1/v`c'; ; 
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 3001/4000{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 4001/5000{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 5001/5826{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/2); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

rename v1 id;

save w_idist_plz_g1, replace;

spmat dta w_idist_plz_g1 v*, id(id) replace;
spmat save w_idist_plz_g1 using w_idist_plz_g1.spmat, replace;

clear;
clear mata;



#delimit;																	
set more off;								

capture log close; 													
		
cd "PFAD";

clear mata;
set maxvar 10000;

insheet using w_idist_plz.txt, delimiter(" ") clear;


foreach c of numlist 2/1000{;
replace v`c'=1/v`c'; 
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
;
}
;

foreach c of numlist 1001/2000{;
replace v`c'=1/v`c'; 
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 2001/3000{;
replace v`c'=1/v`c'; ; 
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 3001/4000{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 4001/5000{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

foreach c of numlist 5001/5826{;
replace v`c'=1/v`c';  
replace v`c'=exp(-v`c'/20000); 
replace v`c'=0 if v`c'==. & _n!=1;
}
;

rename v1 id;

save w_idist_plz_g100, replace;

spmat dta w_idist_plz_g100 v*, id(id) replace;
spmat save w_idist_plz_g100 using w_idist_plz_g100.spmat, replace;

clear;
clear mata;



* models;


#delimit;									
clear;										
set more off;								

capture log close; 													
		
cd "PFAD";


use temp1_plz;


* inverse;
spmat use w_idist_plz using w_idist_plz.spmat;

spreg gs2sls  log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz) elmat(w_idist_plz) id(id);


* gaussian 1;
spmat use w_idist_plz_g1 using w_idist_plz_g1.spmat;

spreg gs2sls  log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_g1) elmat(w_idist_plz_g1) id(id);


* gaussian 100;
spmat use w_idist_plz_g100 using w_idist_plz_g100.spmat;

spreg gs2sls  log_std_brutto biljahre sex2 migrant2 age famst2 vollz1 unter_gr1 unter_gr2 unter_gr3 betriebdauer alo sektor1 sektor3, dlmat(w_idist_plz_g100) elmat(w_idist_plz_g100) id(id);






