*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

* Merging GSOEP datasets (see also SOEPinfo)

clear

#delimit;

 /*MERGE: srm-Paper, Returns to Education*/
 /*************************************************************************************************
 **************************************************************************************************/                                                                              
                                                                                        

/* -----   Here you can customize the paths and options:   ----- */;

global MY_IN_PATH   "/daten/soep30/";
global MY_OUT_PATH  "/daten/";
global MY_TEMP_PATH "/daten/";

global MY_OUT_FILE  ${MY_OUT_PATH}temp1.dta;

set logtype text;
log using /daten/ahartung/temp_log, replace;
capture log close;
set more off;

/* ----------------[ automatically pull PPFAD ]----------------- */;

use    hhnr    persnr  sex     gebjahr psample migback
       ahhnr   bhhnr   bahhnr  bbhhnr  bchhnr  bdhhnr  chhnr   dhhnr   ehhnr  
       fhhnr   ghhnr   hhhnr   ihhnr   jhhnr   khhnr   lhhnr   mhhnr   nhhnr  
       ohhnr   phhnr   qhhnr   rhhnr   shhnr   thhnr   uhhnr   vhhnr   whhnr  
       xhhnr   yhhnr   zhhnr   
       anetto  bnetto  banetto bbnetto bcnetto bdnetto cnetto  dnetto  enetto 
       fnetto  gnetto  hnetto  inetto  jnetto  knetto  lnetto  mnetto  nnetto 
       onetto  pnetto  qnetto  rnetto  snetto  tnetto  unetto  vnetto  wnetto 
       xnetto  ynetto  znetto  
       apop    bpop    bapop   bbpop   bcpop   bdpop   cpop    dpop    epop   
       fpop    gpop    hpop    ipop    jpop    kpop    lpop    mpop    npop   
       opop    ppop    qpop    rpop    spop    tpop    upop    vpop    wpop   
       xpop    ypop    zpop
	  
using  "${MY_IN_PATH}ppfad.dta";

/*
/* --------------[ balanced / unbalanced design ]--------------- */;

keep if ( ( anetto >= 10 & anetto < 20 ) & ( bnetto >= 10 & bnetto < 20 ) & 
          ( banetto >= 10 & banetto < 20 ) & ( bbnetto >= 10 & bbnetto < 20 ) & 
          ( bcnetto >= 10 & bcnetto < 20 ) & ( bdnetto >= 10 & bdnetto < 20 ) & 
          ( cnetto >= 10 & cnetto < 20 ) & ( dnetto >= 10 & dnetto < 20 ) & 
          ( enetto >= 10 & enetto < 20 ) & ( fnetto >= 10 & fnetto < 20 ) & 
          ( gnetto >= 10 & gnetto < 20 ) & ( hnetto >= 10 & hnetto < 20 ) & 
          ( inetto >= 10 & inetto < 20 ) & ( jnetto >= 10 & jnetto < 20 ) & 
          ( knetto >= 10 & knetto < 20 ) & ( lnetto >= 10 & lnetto < 20 ) & 
          ( mnetto >= 10 & mnetto < 20 ) & ( nnetto >= 10 & nnetto < 20 ) & 
          ( onetto >= 10 & onetto < 20 ) & ( pnetto >= 10 & pnetto < 20 ) & 
          ( qnetto >= 10 & qnetto < 20 ) & ( rnetto >= 10 & rnetto < 20 ) & 
          ( snetto >= 10 & snetto < 20 ) & ( tnetto >= 10 & tnetto < 20 ) & 
          ( unetto >= 10 & unetto < 20 ) & ( vnetto >= 10 & vnetto < 20 ) & 
          ( wnetto >= 10 & wnetto < 20 ) & ( xnetto >= 10 & xnetto < 20 ) & 
          ( ynetto >= 10 & ynetto < 20 ) & ( znetto >= 10 & znetto < 20 ) );


*/

/* -----------------[ private housholds only.]------------------ */;

keep if ( ( apop == 1 | apop == 2 ) | ( bpop == 1 | bpop == 2 ) |
          ( bapop == 1 | bapop == 2 ) | ( bbpop == 1 | bbpop == 2 ) |
          ( bcpop == 1 | bcpop == 2 ) | ( bdpop == 1 | bdpop == 2 ) |
          ( cpop == 1 | cpop == 2 ) | ( dpop == 1 | dpop == 2 ) |
          ( epop == 1 | epop == 2 ) | ( fpop == 1 | fpop == 2 ) |
          ( gpop == 1 | gpop == 2 ) | ( hpop == 1 | hpop == 2 ) |
          ( ipop == 1 | ipop == 2 ) | ( jpop == 1 | jpop == 2 ) |
          ( kpop == 1 | kpop == 2 ) | ( lpop == 1 | lpop == 2 ) |
          ( mpop == 1 | mpop == 2 ) | ( npop == 1 | npop == 2 ) |
          ( opop == 1 | opop == 2 ) | ( ppop == 1 | ppop == 2 ) |
          ( qpop == 1 | qpop == 2 ) | ( rpop == 1 | rpop == 2 ) |
          ( spop == 1 | spop == 2 ) | ( tpop == 1 | tpop == 2 ) |
          ( upop == 1 | upop == 2 ) | ( vpop == 1 | vpop == 2 ) |
          ( wpop == 1 | wpop == 2 ) | ( xpop == 1 | xpop == 2 ) |
          ( ypop == 1 | ypop == 2 ) | ( zpop == 1 | zpop == 2 ) );

/* -----------------------[ sort ppfad ]------------------------ */;

sort persnr;
save "${MY_TEMP_PATH}ppfad.dta", replace;
clear;

/* -----------------[ automatically pull PHRF ]----------------- */;

use    hhnr    persnr  prgroup 
       aphrf   bphrf   baphrf  bbphrf  bcphrf  bdphrf  cphrf   dphrf   ephrf  
       fphrf   gphrf   hphrf   iphrf   jphrf   kphrf   lphrf   mphrf   nphrf  
       ophrf   pphrf   qphrf   rphrf   sphrf   tphrf   uphrf   vphrf   wphrf  
       xphrf   yphrf   zphrf   
       bpbleib cpbleib dpbleib epbleib fpbleib gpbleib hpbleib ipbleib jpbleib
       kpbleib lpbleib mpbleib npbleib opbleib ppbleib qpbleib rpbleib spbleib
       tpbleib upbleib vpbleib wpbleib xpbleib ypbleib zpbleib
using  "${MY_IN_PATH}phrf.dta";

sort  persnr;
save  "${MY_TEMP_PATH}phrf.dta", replace;
clear;

/* --------------[ automatically create pmaster ]--------------- */;

use    "${MY_TEMP_PATH}ppfad.dta";
merge  persnr
using  "${MY_TEMP_PATH}phrf.dta";

drop   if _merge == 2;
drop   _merge;
erase  "${MY_TEMP_PATH}ppfad.dta";
erase  "${MY_TEMP_PATH}phrf.dta";
sort   persnr;
save   "${MY_TEMP_PATH}pmaster.dta", replace;

/* -----------------------( pull apgen )------------------------ */;

use    hhnr    ahhnr   persnr  
       betr84  afamstd abilzeit aerwzeit atatzeit avebzeit nace84  labgro84
       emplst84 expft84 exppt84 expue84 bilztch84
using "${MY_IN_PATH}apgen.dta";

sort persnr;
save "${MY_TEMP_PATH}apgen.dta", replace;
clear;

/* -----------------------( pull bpgen )------------------------ */;

use    hhnr    bhhnr   persnr  
       betr85  bfamstd bbilzeit berwzeit btatzeit bvebzeit nace85  labgro85
       emplst85 expft85 exppt85 expue85 bilztch85
using "${MY_IN_PATH}bpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}bpgen.dta", replace;
clear;

/* -----------------------( pull cpgen )------------------------ */;

use    hhnr    chhnr   persnr  
       betr86  cfamstd cbilzeit cerwzeit ctatzeit cvebzeit nace86  labgro86
       emplst86 expft86 exppt86 expue86 bilztch86
using "${MY_IN_PATH}cpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}cpgen.dta", replace;
clear;

/* -----------------------( pull dpgen )------------------------ */;

use    hhnr    dhhnr   persnr  
       betr87  dfamstd dbilzeit derwzeit dtatzeit dvebzeit nace87  labgro87
       emplst87 expft87 exppt87 expue87 bilztch87
using "${MY_IN_PATH}dpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}dpgen.dta", replace;
clear;

/* -----------------------( pull epgen )------------------------ */;

use    hhnr    ehhnr   persnr  
       betr88  efamstd ebilzeit eerwzeit etatzeit evebzeit nace88  labgro88
       emplst88 expft88 exppt88 expue88 bilztch88
using "${MY_IN_PATH}epgen.dta";

sort persnr;
save "${MY_TEMP_PATH}epgen.dta", replace;
clear;

/* -----------------------( pull fpgen )------------------------ */;

use    hhnr    fhhnr   persnr  
       betr89  ffamstd fbilzeit ferwzeit ftatzeit fvebzeit nace89  labgro89
       emplst89 expft89 exppt89 expue89 bilztch89
using "${MY_IN_PATH}fpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}fpgen.dta", replace;
clear;

/* -----------------------( pull gpgen )------------------------ */;

use    hhnr    ghhnr   persnr  
       betr90  gfamstd gbilzeit gerwzeit gtatzeit gvebzeit nace90  labgro90
       emplst90 expft90 exppt90 expue90 bilztch90
using "${MY_IN_PATH}gpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}gpgen.dta", replace;
clear;

/* -----------------------( pull hpgen )------------------------ */;

use    hhnr    hhhnr   persnr  
       betr91  hfamstd hbilzeit herwzeit htatzeit hvebzeit nace91  labgro91
       emplst91 expft91 exppt91 expue91 bilztch91
using "${MY_IN_PATH}hpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}hpgen.dta", replace;
clear;

/* -----------------------( pull ipgen )------------------------ */;

use    hhnr    ihhnr   persnr  
       betr92  ifamstd ibilzeit ierwzeit itatzeit ivebzeit nace92  labgro92
       emplst92 expft92 exppt92 expue92 bilztch92
using "${MY_IN_PATH}ipgen.dta";

sort persnr;
save "${MY_TEMP_PATH}ipgen.dta", replace;
clear;

/* -----------------------( pull jpgen )------------------------ */;

use    hhnr    jhhnr   persnr  
       betr93  jfamstd jbilzeit jerwzeit jtatzeit jvebzeit nace93  labgro93
       emplst93 expft93 exppt93 expue93 bilztch93
using "${MY_IN_PATH}jpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}jpgen.dta", replace;
clear;

/* -----------------------( pull kpgen )------------------------ */;

use    hhnr    khhnr   persnr  
       betr94  kfamstd kbilzeit kerwzeit ktatzeit kvebzeit nace94  labgro94
       emplst94 expft94 exppt94 expue94 bilztch94
using "${MY_IN_PATH}kpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}kpgen.dta", replace;
clear;

/* -----------------------( pull lpgen )------------------------ */;

use    hhnr    lhhnr   persnr  
       betr95  lfamstd lbilzeit lerwzeit ltatzeit lvebzeit nace95  labgro95
       emplst95 expft95 exppt95 expue95 bilztch95
using "${MY_IN_PATH}lpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}lpgen.dta", replace;
clear;

/* -----------------------( pull mpgen )------------------------ */;

use    hhnr    mhhnr   persnr  
       betr96  mfamstd mbilzeit merwzeit mtatzeit mvebzeit nace96  labgro96
       emplst96 expft96 exppt96 expue96 bilztch96
using "${MY_IN_PATH}mpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}mpgen.dta", replace;
clear;

/* -----------------------( pull npgen )------------------------ */;

use    hhnr    nhhnr   persnr  
       betr97  nfamstd nbilzeit nerwzeit ntatzeit nvebzeit nace97  labgro97
       emplst97 expft97 exppt97 expue97 bilztch97
using "${MY_IN_PATH}npgen.dta";

sort persnr;
save "${MY_TEMP_PATH}npgen.dta", replace;
clear;

/* -----------------------( pull opgen )------------------------ */;

use    hhnr    ohhnr   persnr  
       betr98  ofamstd obilzeit oerwzeit otatzeit ovebzeit nace98  labgro98
       emplst98 expft98 exppt98 expue98 bilztch98
using "${MY_IN_PATH}opgen.dta";

sort persnr;
save "${MY_TEMP_PATH}opgen.dta", replace;
clear;

/* -----------------------( pull ppgen )------------------------ */;

use    hhnr    phhnr   persnr  
       betr99  pfamstd pbilzeit perwzeit ptatzeit pvebzeit nace99  labgro99
       emplst99 expft99 exppt99 expue99 bilztch99
using "${MY_IN_PATH}ppgen.dta";

sort persnr;
save "${MY_TEMP_PATH}ppgen.dta", replace;
clear;

/* -----------------------( pull qpgen )------------------------ */;

use    hhnr    qhhnr   persnr  
       betr00  qfamstd qbilzeit qerwzeit qtatzeit qvebzeit nace00  labgro00
       emplst00 expft00 exppt00 expue00 bilztch00
using "${MY_IN_PATH}qpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}qpgen.dta", replace;
clear;

/* -----------------------( pull rpgen )------------------------ */;

use    hhnr    rhhnr   persnr  
       betr01  rfamstd rbilzeit rerwzeit rtatzeit rvebzeit nace01  labgro01
       emplst01 expft01 exppt01 expue01 bilztch01
using "${MY_IN_PATH}rpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}rpgen.dta", replace;
clear;

/* -----------------------( pull spgen )------------------------ */;

use    hhnr    shhnr   persnr  
       betr02  sfamstd sbilzeit serwzeit statzeit svebzeit nace02  labgro02
       emplst02 expft02 exppt02 expue02 bilztch02
using "${MY_IN_PATH}spgen.dta";

sort persnr;
save "${MY_TEMP_PATH}spgen.dta", replace;
clear;

/* -----------------------( pull tpgen )------------------------ */;

use    hhnr    thhnr   persnr  
       betr03  tfamstd tbilzeit terwzeit ttatzeit tvebzeit nace03  labgro03
       emplst03 expft03 exppt03 expue03 bilztch03
using "${MY_IN_PATH}tpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}tpgen.dta", replace;
clear;

/* -----------------------( pull upgen )------------------------ */;

use    hhnr    uhhnr   persnr  
       betr04  ufamstd ubilzeit uerwzeit utatzeit uvebzeit nace04  labgro04
       emplst04 expft04 exppt04 expue04 bilztch04
using "${MY_IN_PATH}upgen.dta";

sort persnr;
save "${MY_TEMP_PATH}upgen.dta", replace;
clear;

/* -----------------------( pull vpgen )------------------------ */;

use    hhnr    vhhnr   persnr  
       betr05  vfamstd vbilzeit verwzeit vtatzeit vvebzeit nace05  labgro05
       emplst05 expft05 exppt05 expue05 bilztch05
using "${MY_IN_PATH}vpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}vpgen.dta", replace;
clear;

/* -----------------------( pull wpgen )------------------------ */;

use    hhnr    whhnr   persnr  
       betr06  wfamstd wbilzeit werwzeit wtatzeit wvebzeit nace06  labgro06
       emplst06 expft06 exppt06 expue06 bilztch06
using "${MY_IN_PATH}wpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}wpgen.dta", replace;
clear;

/* -----------------------( pull xpgen )------------------------ */;

use    hhnr    xhhnr   persnr  
       betr07  xfamstd xbilzeit xerwzeit xtatzeit xvebzeit nace07  labgro07
       emplst07 expft07 exppt07 expue07 bilztch07
using "${MY_IN_PATH}xpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}xpgen.dta", replace;
clear;

/* -----------------------( pull ypgen )------------------------ */;

use    hhnr    yhhnr   persnr  
       betr08  yfamstd ybilzeit yerwzeit ytatzeit yvebzeit nace08  labgro08
       emplst08 expft08 exppt08 expue08 bilztch08
using "${MY_IN_PATH}ypgen.dta";

sort persnr;
save "${MY_TEMP_PATH}ypgen.dta", replace;
clear;

/* -----------------------( pull zpgen )------------------------ */;

use    hhnr    zhhnr   persnr  
       betr09  zfamstd zbilzeit zerwzeit ztatzeit zvebzeit nace09  labgro09
       emplst09 expft09 exppt09 expue09 bilztch09
using "${MY_IN_PATH}zpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}zpgen.dta", replace;
clear;

/* -----------------------( pull bapgen )----------------------- */;

use    hhnr    bahhnr  persnr  
       betr10  bafamstd babilzeit baerwzeit batatzeit bavebzeit nace10 
       labgro10 emplst10 expft10 exppt10 expue10 bilztch10
using "${MY_IN_PATH}bapgen.dta";

sort persnr;
save "${MY_TEMP_PATH}bapgen.dta", replace;
clear;

/* -----------------------( pull bbpgen )----------------------- */;

use    hhnr    bbhhnr  persnr  
       betr11  bbfamstd bbbilzeit bberwzeit bbtatzeit bbvebzeit nace11 
       labgro11 emplst11 expft11 exppt11 expue11 bilztch11
using "${MY_IN_PATH}bbpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}bbpgen.dta", replace;
clear;

/* -----------------------( pull bcpgen )----------------------- */;

use    hhnr    bchhnr  persnr  
       betr12  bcfamstd bcbilzeit bcerwzeit bctatzeit bcvebzeit nace12 
       labgro12 emplst12 expft12 exppt12 expue12 bilztch12
using "${MY_IN_PATH}bcpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}bcpgen.dta", replace;
clear;

/* -----------------------( pull bdpgen )----------------------- */;

use    hhnr    bdhhnr  persnr  
       betr13  bdfamstd bdbilzeit bderwzeit bdtatzeit bdvebzeit nace13 
       labgro13 emplst13 expft13 exppt13 expue13 bilztch13
using "${MY_IN_PATH}bdpgen.dta";

sort persnr;
save "${MY_TEMP_PATH}bdpgen.dta", replace;
clear;

/* -----------------( Now merge all together )------------------ */;

use   "${MY_TEMP_PATH}pmaster.dta";
erase "${MY_TEMP_PATH}pmaster.dta";

/* -----------( merge together by person: ALL Waves )----------- */;

/* -----------------------( merge APGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}apgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}apgen.dta";

/* -----------------------( merge BPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bpgen.dta";

/* -----------------------( merge CPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}cpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}cpgen.dta";

/* -----------------------( merge DPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}dpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}dpgen.dta";

/* -----------------------( merge EPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}epgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}epgen.dta";

/* -----------------------( merge FPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}fpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}fpgen.dta";

/* -----------------------( merge GPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}gpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}gpgen.dta";

/* -----------------------( merge HPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}hpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}hpgen.dta";

/* -----------------------( merge IPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ipgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ipgen.dta";

/* -----------------------( merge JPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}jpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}jpgen.dta";

/* -----------------------( merge KPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}kpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}kpgen.dta";

/* -----------------------( merge LPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}lpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}lpgen.dta";

/* -----------------------( merge MPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}mpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}mpgen.dta";

/* -----------------------( merge NPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}npgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}npgen.dta";

/* -----------------------( merge OPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}opgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}opgen.dta";

/* -----------------------( merge PPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ppgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ppgen.dta";

/* -----------------------( merge QPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}qpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}qpgen.dta";

/* -----------------------( merge RPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}rpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}rpgen.dta";

/* -----------------------( merge SPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}spgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}spgen.dta";

/* -----------------------( merge TPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}tpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}tpgen.dta";

/* -----------------------( merge UPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}upgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}upgen.dta";

/* -----------------------( merge VPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}vpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}vpgen.dta";

/* -----------------------( merge WPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}wpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}wpgen.dta";

/* -----------------------( merge XPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}xpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}xpgen.dta";

/* -----------------------( merge YPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}ypgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}ypgen.dta";

/* -----------------------( merge ZPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}zpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}zpgen.dta";

/* ----------------------( merge BAPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bapgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bapgen.dta";

/* ----------------------( merge BBPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bbpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bbpgen.dta";

/* ----------------------( merge BCPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bcpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bcpgen.dta";

/* ----------------------( merge BDPGEN )----------------------- */;

          
sort  persnr;
merge persnr
using "${MY_TEMP_PATH}bdpgen.dta";
drop   if _merge == 2;
drop   _merge;
erase "${MY_TEMP_PATH}bdpgen.dta";

/* --------------------------( done! )-------------------------- */;



 #delimit cr
/*********************************************************************/
/*********************************************************************/
/****************************RESHAPE**********************************/
/*********************************************************************/
/*********************************************************************/

/*rename variables f?eshape*/
soepren ?famstd, newstub(famst) waves (1984/2009)
soepren ??famstd, newstub(famst) waves (2010/2013)

soepren ?hhnr, newstub(hhnrakt) waves (1984/2009)
soepren ??hhnr, newstub(hhnrakt) waves (2010/2013)

soepren ?bilzeit, newstub(biljahre) waves (1984/2009)
soepren ??bilzeit, newstub(biljahre) waves (2010/2013)

soepren ?erwzeit, newstub(betriebdauer) waves (1984/2009)
soepren ??erwzeit, newstub(betriebdauer) waves (2010/2013)

soepren ?tatzeit, newstub(arbzeit_tat) waves (1984/2009)
soepren ??tatzeit, newstub(arbzeit_tat) waves (2010/2013)

soepren ?vebzeit, newstub(arbzeit_vereinbart) waves (1984/2009)
soepren ??vebzeit, newstub(arbzeit_vereinbart) waves (2010/2013)
 
soepren labgro??, new (brutto) waves (1984/2013)
soepren betr??, new (unternehmengroese) waves (1984/2013)
soepren nace??, newstub(branche) waves (1984/2013) 
soepren emplst??, newstub(emplstatus) waves (1984/2013) 
soepren exppt??, newstub(vollzeit) waves (1984/2013)
soepren expft??, newstub(teilzeit) waves (1984/2013)
soepren expue??, newstub(alo) waves (1984/2013)


/*RESHAPE*/
reshape long hhnrakt famst biljahre betriebdauer arbzeit_tat brutto arbzeit_vereinbart/*
*/ unternehmengroese branche emplstatus vollzeit teilzeit alo,  i(persnr) j(wave)
 
keep persnr wave hhnr hhnrakt sex gebjahr migback hhnrakt brutto famst biljahre betriebdauer /*
*/arbzeit_tat arbzeit_vereinbart unternehmengroese branche emplstatus vollzeit /*
*/teilzeit alo 


mvdecode _all, mv(-1=.)
mvdecode _all, mv(-2=.)
mvdecode _all, mv(-3=.)



* prepare variables;


gen age =wave-gebjahr
recode sex 2=0, gen(mann)


gen vpi=.;
replace vpi=100 if wave==2000;
replace vpi=101 if wave==2001;
replace vpi=103 if wave==2002;
replace vpi=104 if wave==2003;
replace vpi=106 if wave==2004;
replace vpi=107 if wave==2005;
replace vpi=109 if wave==2006;
replace vpi=112 if wave==2007;
replace vpi=115 if wave==2008;
replace vpi=115 if wave==2009;
replace vpi=116 if wave==2010;
replace vpi=119 if wave==2011;
replace vpi=121 if wave==2012;
replace vpi=123 if wave==2013;


gen arbzeit_monat = (arbzeit_vereinbart*13)/3

gen brutto_infl=brutto/vpi * 100;

gen std_brutto=brutto_infl/ arbzeit_monat;
gen log_std_brutto = log(std_brutto);


drop if log_std_brutto==.;


drop if sex==.;
tab sex, gen(sex);

drop if migback==.;
tab migback, gen(migrant);

drop if emplstatus==.;
keep if emplstatus<3;

tab emplstatus, gen(vollz);

drop if unternehmengroese==.;
gen unter_gr=unternehmengroese;
recode unter_gr (1/3=1) (6/7=2) (9=3) (10=4);


drop if unternehmengroese==11; 

tab unter_gr, gen(unter_gr);

drop if famst==.;
recode famst (2=1) (6=1) (7=1);

tab famst, gen(famst);

drop if branche==.;
gen sektor=branche;
recode sektor (1/16=1) (17/45=2) (46/95=3) (96/97=2) (98/99=3) (100=2); 

tab sektor, gen(sektor);


drop if age==.;
drop if log_std_brutto==.;
drop if biljahre==.;
drop if alo==.;
drop if betriebdauer==.;

keep if age>34;
keep if age<56;




* prepare sample;

drop if wave <2000;

bysort persnr (wave): gen persnr1 = persnr[_n-1];
 gen persnr2=1 if persnr1==.;
 drop if persnr2==.;
 drop persnr1 persnr2;
 
 
bys hhnr: gen index=_N;
recode index (2/11=2);

tab index;

set seed 1234;

sample 1, count by(hhnr); 

set seed 4321;
sample 43 if index==1;


save srm_individual, replace; 

keep persnr wave hhnr hhnrakt;


* merge with GSOEP design weights ;

merge m:1 hhnr using /daten/soep31/design;
drop if _merge==2;
drop _merge;


* merge cases with coordinates using linkfile generated by GSOEP Data Center ;

gen erhebj=wave;

merge 1:1 hhnrakt erhebj using /daten/linkfile, keepusing(plz_kz kreis_kz ror11);
drop if _merge==2;
drop if _merge==1;
drop _merge;


merge m:1 plz_kz using /daten/plz_coord_soep;
drop if _merge==2;
drop if _merge==1;
drop _merge;

destring ror11, replace;

merge m:1 ror11 using /daten/ror_coord_soep;
drop if _merge==2;
drop if _merge==1;
drop _merge;


merge m:1 kreis_kz using /daten/kreis_coord_soep;
drop if _merge==2;
drop if _merge==1;
drop _merge;


merge m:1 gem_kz using /daten/ahartung/gem_coord_soep;
drop if _merge==2;
drop if _merge==1;
drop _merge;


save srm_master, replace;






