*Supplement to: Hillmert, Steffen, Hartung, Andreas and Weßling, Katarina (2017): Dealing with space and place in standard survey data. Survey Research Methods 11 (3). doi:10.18148/srm/2017.v11i3.6729

*Preparing of coordinates data

#delimit;									
clear;										
set more off;								

capture log close; 													

cd "PFAD";	


* load shapefile data and transform to .dta;

shp2dta using shapes_esra\gemeinde_gk31467, database(datab\datab_gem) coordinates(datab\datacoord_gem) genid(id_gem) gencentroids(gem) replace;
shp2dta using shapes_esra\kreis_gk31467, database(datab\datab_kreis) coordinates(datab\datacoord_kreis) genid(id_kreis) gencentroids(kreis) replace;
shp2dta using shapes_esra\ror_gk31467, database(datab\datab_ror) coordinates(datab\datacoord_ror) genid(id_ror) gencentroids(ror) replace;
shp2dta using shapes_esra\plz_gk31467, database(datab\datab_plz) coordinates(datab\datacoord_plz) genid(id_plz) gencentroids(plz) replace;


use datab\datab_plz;
destring plz, gen(plz_kz);
drop plz note;
save datab\datab_plz2, replace;

use datab\datab_kreis;
drop if EWZ==0;
keep id_kreis x_kreis y_kreis AGS;
destring AGS, gen(kreis_kz);
drop AGS;
save datab\kreis_coord_soep, replace;

use datab\datab_gem;
drop if EWZ==0;
keep id_gem x_gem y_gem AGS;
destring AGS, gen(gem_kz);
drop AGS;
save datab\gem_coord_soep, replace;

use datab\datab_ror;
keep id_ror x_ror y_ror ror11;
save datab\datab_ror2, replace;




* prepare randomly distributed coordinates; 

shp2dta using shapes_esra\ror_random, database(datab\datab_ror_random) coordinates(datab\datacoord_ror_random) replace;

use datab\datab_ror_random;

merge 1:1 _ID using datab\datacoord_ror_random;

rename _X x_ror_split;

rename _Y y_ror_split;

drop cartodb_id objectid name shape_area shape_leng _ID _merge ID;

bys ror11: gen ror_index=_n;

reshape wide x_ror_split y_ror_split, i(ror11) j(ror_index);

merge m:1 ror11 using datab\datab_ror2;
drop _merge;

order ror11 x_ror y_ror;

save ror_coord_soep, replace;


shp2dta using shapes_esra\plz_random, database(datab\datab_plz_random) coordinates(datab\datacoord_plz_random) replace;

use datab\datab_plz_random;

merge 1:1 _ID using datab\datacoord_plz_random;

rename _X x_plz_split;

rename _Y y_plz_split;

destring plz, gen (plz_kz);

keep plz_kz x_plz_split y_plz_split;

bys plz_kz: gen plz_index=_n;

drop if plz_index>5;

reshape wide x_plz_split y_plz_split, i(plz_kz) j(plz_index);

merge 1:m plz_kz using datab\datab_plz2;

drop _merge;

order plz_kz x_plz y_plz;

save plz_coord_soep, replace;




