﻿* Encoding: UTF-8.
*Encoding: UTF-8.
***Syntax for data preparation of the EVS data of 2008
***Date of syntax 20.09.2016 by Verena Ortmanns
***Refers to the article "Can we assess representativeness of cross-national surveys using the education variable? 
by Verena Ortmanns and Silke L. Schneider published in Survey Research Methods


*For the EVS 2008*
*Restriction of the age groupe to those aged 25 to 64.
select if (age ge 25 and age le 64).

*Show distribution of the education variable.
freq v336.

*Recode the education variable.
miss val v336 ().
compute ISCED97_5 eq v362.
recode ISCED97_5 (0 eq 1).
recode ISCED97_5 (1 eq 1).
recode ISCED97_5 (2 eq 2).
recode ISCED97_5 (3 eq 3).
recode ISCED97_5 (4 eq 4).
recode ISCED97_5 (5 eq 5).
recode ISCED97_5 (6 eq 5).
recode ISCED97_5 (-5 eq 9).
recode ISCED97_5 (-2 eq 9).
recode ISCED97_5 (-1 eq 9).

variable labels ISCED97_5 "5-level version of ISCED 1997".
value labels ISCED97_5
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3"
4 "ISCED 4"
5 "ISCED 5-6"
9 "Missing".

Format ISCED97_5 (F1.0).
Missing values ISCED97_5 (9).

freq ISCED97_5.
crosstab v336 by ISCED97_5.

*Create weights for Belgium, Germany, and the UK.
compute weight_be eq 0.
if (v371b_N1 eq 5601) weight_be eq 1.13385.
if (v371b_N1 eq 5602) weight_be eq 1.1049.
if (v371b_N1 eq 5603) weight_be eq 0.82741.

compute weight_de eq 0.
if (country1 eq 900) weight_de eq 1.579.
if (country1 eq 901) weight_de eq 0.381.

compute weight_gb eq 0.
if (country1 eq 826) weight_gb eq 1.281664.
if (country1 eq 909) weight_gb eq 0.120644.

*Use the weights only for Belgium, Germany, and the UK.

weight by weight_be.
weight off.

weight by weight_de.
weight off.

weight by weight_gb.
weight off.

*Split file by country variable and calculate the distribution of the ISCED97_5 variable.
split file separate by country.
freq ISCED97_5.
*These distributions can be find in the provided excel-table*
