﻿* Encoding: UTF-8.
*Encoding: UTF-8.
***Syntax for data preparation of the EU-LFS data of 2008 to 2012 [data of the 2nd quarter] 
***Syntax is identical for each year of the analyzed time period
***Date of syntax 20.09.2016 by Verena Ortmanns
***Refers to the article "Can we assess representativeness of cross-national surveys using the education variable? 
by Verena Ortmanns and Silke L. Schneider published in Survey Research Methods


*Restriction of the age groupe to those aged 25 to 64.
select if (age  ge 27 and age le 62).

*Show distribution of the education variable.
freq hatlevel.


*Recode the education variable: 
*The new variable ISCED97_5 is used to compare the data EU-LFS with the data of EU-SILC, PIAAC, Eurobarometer, ESS, and ISSP.
miss val hatlevel ().
compute ISCED97_5 eq hatlevel.
recode ISCED97_5 (0 eq 1).
recode ISCED97_5 (11 eq 1).
recode ISCED97_5 (21 eq 2).
recode ISCED97_5 (22 eq 2). 
recode ISCED97_5 (30 eq 3).
recode ISCED97_5 (31 eq 3).
recode ISCED97_5 (32 eq 3).
recode ISCED97_5 (41 eq 4).
recode ISCED97_5 (42 eq 4).
recode ISCED97_5 (43 eq 4).
recode ISCED97_5 (51 eq 5).
recode ISCED97_5 (52 eq 5).
recode ISCED97_5 (60 eq 5).
recode ISCED97_5 (-1 eq 9).

variable labels ISCED97_5 "5-level version of ISCED 1997".
value labels ISCED97_5
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3"
4 "ISCED 4"
5 "ISCED 5-6"
9 "Missing".

Format ISCED97_5 (F1.0).
Missing values ISCED97_5 (9).

freq ISCED97_5.
crosstab hatlevel by ISCED97_5.

*Use the design weight.
weight by coeff.

*Split file by country variable and calculate the distribution of the ISCED97_5 variable.
split file separate by country.
freq ISCED97_5.
*These distributions can be find in the provided excel-table*


*Recode the education variable:
*The variable ISCED97_4 is used to compare the EU-LFS with the ISSP data

miss val hatlevel ().
compute ISCED97_4 eq hatlevel.
recode ISCED97_4 (0 eq 1).
recode ISCED97_4 (11 eq 1).
recode ISCED97_4 (21 eq 2).
recode ISCED97_4 (22 eq 2).
recode ISCED97_4 (30 eq 3).
recode ISCED97_4 (31 eq 3).
recode ISCED97_4 (32 eq 3).
recode ISCED97_4 (41 eq 3).
recode ISCED97_4 (42 eq 3).
recode ISCED97_4 (43 eq 3).
recode ISCED97_4 (51 eq 4).
recode ISCED97_4 (52 eq 4).
recode ISCED97_4 (60 eq 4).
recode ISCED97_4 (-1 eq 9).
recode ISCED97_4 (-2 eq 9).

variable labels ISCED97_4 "4-level version of ISCED 1997".
value labels ISCED97_4
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3-4"
4 "ISCED 5-6"
9 "Missing".

Format ISCED97_4 (F1.0).
Missing values ISCED97_4 (9).

freq ISCED97_4.
crosstab hatlevel by ISCED97_4.

*Use the design weight.
weight by coeff.

*Split file by country variable and calculate the distribution of the ISCED97_4 variable.
split file separate by country.
freq ISCED97_4.
*These distributions can be find in the provided excel-table*


*Regional adjustments

*Adjustment in regions for comparisons with PIAAC data*
*Belgium: Flanders only.
compute region1_BE eq 0.
if (region eq 210) region1_BE eq 2.
if (region eq 221) region1_BE eq 1.
if (region eq 222) region1_BE eq 1.
if (region eq 223) region1_BE eq 1.
if (region eq 224) region1_BE eq 1.
if (region eq 225) region1_BE eq 1.
if (region eq 231) region1_BE eq 2.
if (region eq 232) region1_BE eq 2.
if (region eq 233) region1_BE eq 2.
if (region eq 234) region1_BE eq 2.
if (region eq 235) region1_BE eq 2.

variable labels region1_BE "Region Belgium_Flanders".
value labels region1_BE
1 "Flanders"
2 "Brussels and Wallonia".

Format region1_BE (F1.0).

split file separate by region1_BE.
freq ISCED97_5.
*The distribution can be find in the provided excel-table*

*UK: England and Northern Ireland. 
compute region1_GB eq 0.
if (region eq 3103) region1_GB eq 1.
if (region eq 3104) region1_GB eq 1.
if (region eq 3105) region1_GB eq 1.
if (region eq 3106) region1_GB eq 1.
if (region eq 3107) region1_GB eq 1.
if (region eq 3108) region1_GB eq 1.
if (region eq 3109) region1_GB eq 1.
if (region eq 3110) region1_GB eq 1.
if (region eq 3111) region1_GB eq 1.
if (region eq 3112) region1_GB eq 2.
if (region eq 3113) region1_GB eq 2.
if (region eq 3114) region1_GB eq 1.

variable labels region1_GB "Region UK_England and Northern Ireland".

VALUE LABELS region1_GB
1 "England and Northern Ireland"
2 "Scotland and Wales".

Formats region1_GB (F1.0).

split file separate by region1_GB.
freq ISCED97_5.
*The distribution can be find in the provided excel-table*

*Adjustment in regions for comparisons with ISSP data*
*Belgium: Brussels and Flanders only.
compute region2_BE eq 0.
if (region eq 210) region2_BE eq 1.
if (region eq 221) region2_BE eq 1.
if (region eq 222) region2_BE eq 1.
if (region eq 223) region2_BE eq 1.
if (region eq 224) region2_BE eq 1.
if (region eq 225) region2_BE eq 1.
if (region eq 231) region2_BE eq 2.
if (region eq 232) region2_BE eq 2.
if (region eq 233) region2_BE eq 2.
if (region eq 234) region2_BE eq 2.
if (region eq 235) region2_BE eq 2.

variable labels region2_BE "Region Belgium_Brussels and Flanders".

value labels region2_BE
1 "Brussels and Flanders"
2 "Wallonia".

Format region2_BE (F1.0).

split file separate by region2_BE.
freq ISCED97_4.
*The distribution can be find in the provided excel-table*

*UK: withouth Northern Ireland.
compute region2_GB eq 0.
if (region eq 3103) region2_GB eq 1.
if (region eq 3104) region2_GB eq 1.
if (region eq 3105) region2_GB eq 1.
if (region eq 3106) region2_GB eq 1.
if (region eq 3107) region2_GB eq 1.
if (region eq 3108) region2_GB eq 1.
if (region eq 3109) region2_GB eq 1.
if (region eq 3110) region2_GB eq 1.
if (region eq 3111) region2_GB eq 1.
if (region eq 3112) region2_GB eq 1.
if (region eq 3113) region2_GB eq 1.
if (region eq 3114) region2_GB eq 2.

variable labels region2_GB "Region UK_without Northern Ireland".
VALUE LABELS region2_GB
1 "England, Scotland, Wales"
2 "Northern Ireland".

Format region2_GB (F1.0).

split file separate by region2_GB.
freq ISCED97_4.
*The distribution can be find in the provided excel-table*