﻿* Encoding: UTF-8.
*Encoding: UTF-8.
***Syntax for data preparation of the PIAAC data of 2011 
***Date of syntax 20.09.2016 by Verena Ortmanns
***Refers to the article "Can we assess representativeness of cross-national surveys using the education variable? 
by Verena Ortmanns and Silke L. Schneider published in Survey Research Methods


*Restriction of the age groupe to those aged 25 to 64.
select if (age_r ge 25 and age_r le 64).
*for Germany and Austria use the grouped age variable.
freq ageg5lfs.
select if (ageg5lfs ge 3 and ageg5lfs le 10).

*Show distribution of the education variable.
freq edcat7.

*Recode the education variable. 
miss val edcat7 ().
compute ISCED97_5 eq edcat7.
recode ISCED97_5 (1 eq 1).
recode ISCED97_5 (2 eq 2).
recode ISCED97_5 (3 eq 3).
recode ISCED97_5 (4 eq 4).
recode ISCED97_5 (5 eq 5).
recode ISCED97_5 (6 eq 5).
recode ISCED97_5 (7 eq 5).
recode ISCED97_5 (8 eq 5).
recode ISCED97_5 (99 eq 99).

variable labels ISCED97_5 "5-level version of ISCED 1997".
value labels ISCED97_5
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3"
4 "ISCED 4"
5 "ISCED 5-6"
9 "Missing".

Format ISCED97_5 (F1.0).
Missing values ISCED97_5 (9).

freq ISCED97_5.
crosstab edcat7 by ISCED97_5.

*For weighting use the International Database (IDB) Analyzer on: http://www.iea.nl/data.html

*The following commands were then implemented in the IDB Analyzer:
*freq ISCED97_5.
*Split file by country variable not required since IDB Analyzer only performs by-country analyses.
*These distributions can be find in the provided excel-table*


