﻿*Encoding: UTF-8.
***Syntax for data preparation of the ISSP data of 2011 and 2012
***Syntax is nearly identical for each year of the analyzed time period
***Date of syntax 20.09.2016 by Verena Ortmanns
***Refers to the article "Can we assess representativeness of cross-national surveys using the education variable? 
by Verena Ortmanns and Silke L. Schneider published in Survey Research Methods


*For the ISSP 2011 and 2012*
*Restriction of the age groupe to those aged 25 to 64.
select if (age  ge 25 and age le 64).

*Show distribution of the education variable.
freq degree.

*Recode the education variable.
miss val degree ().
compute ISCED97_4 eq degree.
recode ISCED97_4 (0 eq 1).
recode ISCED97_4 (1 eq 1).
recode ISCED97_4 (2 eq 2).
recode ISCED97_4 (3 eq 3).
recode ISCED97_4 (4 eq 3).
recode ISCED97_4 (5 eq 4).
recode ISCED97_4 (6 eq 4).
recode ISCED97_4 (9 eq 9).

variable labels ISCED97_4 "4-level version of ISCED 1997".
Value labels ISCED97_4
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3-4"
4 "ISCED 5-6"
9 "Missing".

Format ISCED97_4 (F1.0).
Missing values ISCED97_4 (9).

freq ISCED97_4.
crosstab degree by ISCED97_4.

*Create weights for Germany 2011.
compute weight_de eq 0.
if (v3 eq 27601) weight_de eq 1.23472181.
if (v3 eq 27602) weight_de eq 0.53513429.

*Create weights for Germany 2012.
compute weight_de eq 0.
if (v3 eq 27601) weight_de eq 1.19943949.
if (v3 eq 27602) weight_de eq 0.56823852.


*Use the weights only for Germany.
weight by weight_de.
weight off.

*Split file by country variable and calculate the distribution of the ISCED97_5 variable.
split file separate by v3.
freq ISCED97_4.
*These distributions can be find in the provided excel-table*

*Information on region for Belgium: Flanders and Brussels included only.
freq be_reg.
compute regionBE eq be_reg.
if (be_reg eq 10) regionBE eq 1.
if (be_reg eq 21) regionBE eq 1.
if (be_reg eq 22) regionBE eq 1.
if (be_reg eq 23) regionBE eq 1.
if (be_reg eq 24) regionBE eq 1.
if (be_reg eq 25) regionBE eq 1.
if (be_reg eq 31) regionBE eq 2.
if (be_reg eq 32) regionBE eq 2.
if (be_reg eq 33) regionBE eq 2.
if (be_reg eq 34) regionBE eq 2.
if (be_reg eq 35) regionBE eq 2.

variable labels regionBE "Regions of Belgium".
value labels regionBE
1 "Brussels and Flanders"
2 "Wallonia".

Format regionBE (F1.0).

split file separate by regionBE.
freq ISCED97_4.
*The distribution can be find in the provided excel-table*