﻿* Encoding: UTF-8.
*Encoding: UTF-8.
***Syntax for data preparation of the Eurobarometer data of 2010 and 2011
***Syntax is nearly identical for each year of the analyzed time period
***Date of syntax 20.09.2016 by Verena Ortmanns
***Refers to the article "Can we assess representativeness of cross-national surveys using the education variable? 
by Verena Ortmanns and Silke L. Schneider published in Survey Research Methods


*For Eurobarometers 2010 (EB73.2 and EB73.3)*
*Restriction of the age groupe to those aged 25 to 64.
select if (v79 ge 25 and v79 le 64).

*Show distribution of the education variable.
freq v362.

*Recode the education variable.
miss val v362 ().
compute ISCED97_5 eq v362.
recode ISCED97_5 (0 eq 1).
recode ISCED97_5 (1 eq 1).
recode ISCED97_5 (2 eq 2).
recode ISCED97_5 (3 eq 3).
recode ISCED97_5 (4 eq 4).
recode ISCED97_5 (5 eq 5).
recode ISCED97_5 (6 eq 5).
recode ISCED97_5 (7 eq 9).

variable labels ISCED97_5 "5-level version of ISCED 1997".
value labels ISCED97_5
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3"
4 "ISCED 4"
5 "ISCED 5-6"
9 "Missing".

Format ISCED97_5 (F1.0).
Missing values ISCED97_5 (9).

freq ISCED97_5.
crosstab v362 by ISCED97_5.

*Create weights for Germany and the UK.
compute weight_de eq 0.
if (v6 eq 4) weight_de eq 1.191041.
if (v6 eq 14) weight_de eq 0.634547.

compute weight_gb eq 0.
if (v6 eq 9) weight_gb eq 1.262143.
if (v6 eq 10) weight_gb eq 0.122167.

*Use the weights only for Germany and UK.
weight by weight_de.
weight off.

weight by weight_gb.
weight off.

*Split file by country variable and calculate the distribution of the ISCED97_5 variable..
split file separate by v6.
freq ISCED97_5.
*These distributions can be find in the provided excel-table*


*For Eurobarometer 2011 (EB75.4)*
*Restriction of the age groupe to those aged 25 to 64.
select if (v595 ge 25 and v595 le 64).

*Show distribution of the education variable.
freq v105.

*Recode the education variable: 
miss val v362 ().
compute ISCED97_5 eq v105.
recode ISCED97_5 (0 eq 1).
recode ISCED97_5 (1 eq 1).
recode ISCED97_5 (2 eq 2).
recode ISCED97_5 (3 eq 3).
recode ISCED97_5 (4 eq 4).
recode ISCED97_5 (5 eq 5).
recode ISCED97_5 (6 eq 5).
recode ISCED97_5 (7 eq 9).

variable labels ISCED97_5 "5-level version of ISCED 1997".
value labels ISCED97_5
1 "ISCED 0-1"
2 "ISCED 2"
3 "ISCED 3"
4 "ISCED 4"
5 "ISCED 5-6"
9 "Missing".

Format ISCED97_5 (F1.0).
Missing values ISCED97_5 (9).

freq ISCED97_5.
crosstab v105 by ISCED97_5.

*Create weights for Germany and the UK.
compute weight_de eq 0.
if (v6 eq 4) weight_de eq 1.231881.
if (v6 eq 14) weight_de eq 0.992378.

compute weight_gb eq 0.
if (v6 eq 9) weight_gb eq 1.266245.
if (v6 eq 10) weight_gb eq 0.121055.

*Use the weights only for Germany and UK.
weight by weight_de.
weight off.

weight by weight_gb.
weight off.

*Split file by country variable and calculate the distribution of the ISCED97_5 variable.
split file separate by v6.
freq ISCED97_5.
*These distributions can be find in the provided excel-table*
