#delimit;
clear;
set more off;
version 9;
set seed 0815;


* STEP 1: Generate simulation data sets from SOEP v29 *
* the first batch of files, generating NR data sets, draws from the (imputed) SOEP wealth files data distribution v29

do cr_imp_data_MAR.do; /* Generates 1000 MAR data sets to be imputed */;
do cr_imp_data_DNR1.do; /* Generates 1000 DNR1 data sets to be imputed */;
do cr_imp_data_DNR2.do; /* Generates 1000 DNR2 data sets to be imputed */;



* STEP 2: Imputation: available upon request / cwestermeier@diw.de
* Imputation with MICE via stata mi impute chained // stata command heckman
* Imputation with L+S:
do ls-imp.do;


* STEP 3: Compute evaluation criteria 

do an_results.do; /* done! */;
/* Generates 6 files containing all results in "data1000_$imputation_method$_results_all.dta":
  the missingness mechanism must be specified by the user in the header; 
  the results_files contain 27 data points per asset and year, which makes for 
  6 files per missingness mechanism in 3 separate folders, each containing 243 vars (results) and 1000 obs (replications);
  note that there are 27 "slots" for results but only 12 are actually used in the evaluation below */;
  

  
* STEP 4: Compute results, tables and figures 

ssc install mahapick;
* Ado mahapick incl mahascore needed for further calculations of results
  
do results_a.do; 
/* Contains: 
		- calculation of standard error bias
		- computation of results and detailed results (appendix)
		- boxplots figure 1, A1, A2 
	note that the input folder defines the missingness mechanism */;

do results_a.do; 
/* Contains:  separate analysis for mobility replication, all years simultaneously,
	note that the input folder defines the missingness mechanism */;
	
	