#delimit;
clear;
set more off;
version 9;
set seed 0815;

global folder3	"xxx\wealth_sim_16\wealth\2002_new\"; 	/* CS WEALTH DATA 2002*/;
global folder8  "xxx\wealth_sim_16\wealth\2012\";		/* CS WEALTH DATA 2012*/;
global folder4  "xxx\wealth_sim_16\wealth\2007\";		/* CS WEALTH DATA 2007*/;
global folderx  "xxx\wealth_sim_16\meta2012_MAR\temp\";	/* FOLDER FOR SIMULATION DATA*/;

*****************************************************************************************;
*                                                                             			*;
*        Merging of the different data sets to get a final data set for imputation  	*;
*                                                                             			*;
*****************************************************************************************;

/* Input data: cross-sectional SOEP wealth data 2002, 2007 and 2012 */;

use     $folder3/pwealth_2002.dta, clear;
foreach var in a02_wr a03_wr b08_wr b11_wr c02_wr d02_wr e03_wr f02_wr g02_wr {;
rename `var' `var'_02;
};
drop 	sp85*;
sort	persnr;
save 	$folderx/pwealth_2002.dta, replace;

use     $folder4/pwealth_2007.dta, clear;
foreach var in a02_wr a06_wr b09_wr b15_wr c02_wr d02_wr e02_wr f03_wr g02_wr h02_wr {;
rename `var' `var'_07;
};
drop 	xp126*;
sort	persnr;
save 	$folderx/pwealth_2007.dta, replace;

use     $folder8/pwealth_2012.dta, clear;
foreach var in a02_wr a06_wr b09_wr b15_wr c02_wr d02_wr e02_wr f03_wr g02_wr h02_wr {;
rename `var' `var'_12;
};
drop 	bcp90*;
sort	persnr;
save 	$folderx/pwealth_2012.dta, replace;

merge persnr using $folderx/pwealth_2002.dta;
drop _merge;
sort persnr;
merge persnr using $folderx/pwealth_2007.dta;
drop _merge;
sort persnr;
merge persnr using $folderx/pwealth_2012.dta;
drop _merge;
sort persnr;


erase 	$folderx/pwealth_2002.dta;
erase 	$folderx/pwealth_2007.dta;
erase 	$folderx/pwealth_2012.dta;

save 	$folderx/pwealth_all_imp.dta, replace;


local xyz = 1;

forvalues number = 1/1000 {;

global IMP_DATA $folderx/imp_data`number'.dta;

quietly {;

use 	$folderx/pwealth_all_imp.dta, clear;


keep 
/* wealth imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100*
e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars*/ 
e00200* e02000* e0010* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*;

/* Other wealth components ... filters and values ... insert */;
sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* e00200* e0010* e1000* c1000* c0100*  l02000* h02000* b02000* t02000* c02000* i02000*;

sort persnr;
save $IMP_DATA, replace;


*************************************************************************************************;
*        simulation data set:							  							  			*;
*							1. Take complete cases (set PUNR not eligible)						*;
*							2. logistic regression modells: sequentially blank out information	*;
*							2a. wave nonresponse: indicator for prior waves						*;				
*							2b. age, sex, labour force status, relationship in hh, place of residence, rent/mortgage repayments, health condition *;				
*							2c. sequential modelling of wealth components, indicators include all wealth components of prior waves x02000    	*;				
*							2d. other respondent characteristics								*;				
*							2e. estimation with full dataset --> check R^2						*;				
*							2f. set missing to 10%, predict for simulation dataset and component*;
*							2g. adjustment: assume fixed values for all other components! 		*;
*							3. check model quality, table R^2 for 3 waves and 2 components 		*;
*							4. save data set, start imputation routines							*;		
*************************************************************************************************;


use 	 $folder3/reg_a_02.dta, clear; 
keep  persnr snetto spop psample frau agenew sfamstd hhgr_* kinder_* sparen_* nopartner erwerbst_1 nodebt 
kredit* sozialhilfe01_* agenew2 lnw02_* bilzeit_* owner altvorsor lotto* lnsh32* aktien_*
p11302_2 p11302_ka support_* divi_k* capic02_* capia02_* beamte lowzuf highzuf p0104 
famstd deutsch_* sparbuch_* mode02 selbst* west;
sort persnr;

save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;




* 	2002 ********************************************************************;
** 	Financial assets ***********************************************************;

gen miss_flag = f02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p e b t c i {;
gen xmiss_flag_102_`comp' = `comp'02000_02;
recode xmiss_flag_102_`comp' (. 1 0 = 0) (2 = 1);
};

gen f_person_flag_02 = 0;
replace f_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_102_p == 0) & (xmiss_flag_102_c == 0); 

xi: logit miss_flag xmiss_flag_102_* frau agenew agenew2 hhgr_* kinder_* sparen_* i.erwerbst_1 nodebt 
kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka support_* divi_k* beamte
 lowzuf highzuf deutsch_* sparbuch_* i.mode02 selbst_1 west if snetto < 20;


predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if f10000_02 == 1 & f_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_02 == 1 & f_person_flag_02 == 1;
gen 	miss_flag_1_02 = imp_ins+resid[random] if  f10000_02 == 1 & f_person_flag_02 == 1;


sum miss_flag_1_02, de;
replace miss_flag_1_02 = 1 if (miss_flag_1_02 > r(p90) & miss_flag_1_02 != .);
replace miss_flag_1_02 = 0 if (miss_flag_1_02 < 1);
tab miss_flag_1_02 f_person_flag_02, mis;
drop miss_flag _merge random count resid imp_ins;


* 	2002 ********************************************************************;
** 	Home market value ***********************************************************;

gen miss_flag = p02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c i {;
gen xmiss_flag_202_`comp' = `comp'02000_02;
recode xmiss_flag_202_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	p_person_flag_02 = 0;
replace p_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_202_f == 0) & (xmiss_flag_202_c == 0); 

xi: logit miss_flag xmiss_flag_202_* frau agenew agenew2 hhgr_* kinder_* sparen_* i.erwerbst_1 nodebt 
kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka support_* divi_k* beamte lowzuf
highzuf deutsch_* sparbuch_* i.mode02 selbst_1 west if snetto < 20;

replace xmiss_flag_202_f = 1 if miss_flag_1_02 == 1;

predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if p10000_02 == 1 & p_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_02 == 1 & p_person_flag_02 == 1;
gen 	miss_flag_2_02 = imp_ins+resid[random] if  p10000_02 == 1 & p_person_flag_02 == 1;


sum miss_flag_2_02, de;
replace miss_flag_2_02 = 1 if (miss_flag_2_02 > r(p90) & miss_flag_2_02 != .);
replace miss_flag_2_02 = 0 if (miss_flag_2_02 < 1);
tab miss_flag_2_02 p_person_flag_02, mis;

drop miss_flag random count resid imp_ins;



* 	2002 ********************************************************************;
** 	consumer credits                 *******************************************;

gen miss_flag = c02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t i {;
gen xmiss_flag_402_`comp' = `comp'02000_02;
recode xmiss_flag_402_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	c_person_flag_02 = 0;
replace c_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_402_f == 0) & (xmiss_flag_402_p == 0);  

xi: logit miss_flag xmiss_flag_402_p xmiss_flag_402_f xmiss_flag_402_e xmiss_flag_402_b*  
frau agenew agenew2 hhgr_* kinder_* sparen_* i.erwerbst_1 nodebt 
kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka support_* 
divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* west if snetto < 20;

replace xmiss_flag_402_f = 1 if miss_flag_1_02 == 1;
replace xmiss_flag_402_p = 1 if miss_flag_2_02 == 1;

predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if c10000_02 == 1 & c_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_02 == 1 & c_person_flag_02 == 1;
gen 	miss_flag_4_02 = imp_ins+resid[random] 		if c10000_02 == 1 & c_person_flag_02 == 1;


sum miss_flag_4_02, de;
replace miss_flag_4_02 = 1 if (miss_flag_4_02 > r(p90) & miss_flag_4_02 != .);
replace miss_flag_4_02 = 0 if (miss_flag_4_02 < 1);
tab miss_flag_4_02 c_person_flag_02, mis;

drop miss_flag random count resid imp_ins;



keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* indicators of response other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*


/* NR simulation vars*/ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;



* 	2007 ********************************************************************;
**	Financial assets ***********************************************************;


use 	 $folder4/reg_a_07.dta, clear; 
keep  persnr xnetto frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt kredit* sozialhilfe06_* lnw06_* bilzeit_* owner /*i.*/altvorsor 
support_* divi_k* selbst* beamte lowzuf highzuf 
deutsch_* sparbuch_* west mode07;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;

/* flag response 2002 und NR 2002 */;

gen l_miss_flag = f02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = f02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p e b t c l h {;
gen xmiss_flag_107_`comp' = `comp'02000_07;
recode xmiss_flag_107_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	f_person_flag_07 = 0;
replace f_person_flag_07 = 1 if (xnetto < 20) & (miss_flag == 0) & (xmiss_flag_107_p == 0) & (xmiss_flag_107_c == 0);  

xi: logit miss_flag l_miss_flag xmiss_flag_102_* xmiss_flag_107_* frau agenew agenew2 hhgr_* kinder_* sparen_* 
i.erwerbst_1 nodebt kredit* sozialhilfe06_* lnw06_* bilzeit_* owner i.altvorsor support_* divi_k* 
beamte lowzuf highzuf deutsch_* sparbuch_* i.mode07 west selbst_1 if xnetto < 20;

replace l_miss_flag = 1 if miss_flag_1_02 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if f10000_07 == 1 & f_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_07 == 1 & f_person_flag_07 == 1;
gen 	miss_flag_1_07 = imp_ins+resid[random] if  f10000_07 == 1 & f_person_flag_07 == 1;


sum miss_flag_1_07, de;
replace miss_flag_1_07 = 1 if (miss_flag_1_07 > r(p90) & miss_flag_1_07 != .);
replace miss_flag_1_07 = 0 if (miss_flag_1_07 < 1);
tab miss_flag_1_07 f_person_flag_02, mis;
drop miss_flag _merge l_miss_flag random count resid imp_ins;



* 	2007 ********************************************************************;
** 	Home market value ***********************************************************;

/* Flag-Response 2002 und NR 2002 */;

gen l_miss_flag = p02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = p02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c l h {;
gen xmiss_flag_207_`comp' = `comp'02000_07;
recode xmiss_flag_207_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	p_person_flag_07 = 0;
replace p_person_flag_07 = 1 if (xnetto < 20) &  (miss_flag == 0) & (xmiss_flag_207_f == 0) & (xmiss_flag_207_c == 0);  

xi: logit miss_flag l_miss_flag xmiss_flag_202_* xmiss_flag_207_* frau agenew agenew2 hhgr_* kinder_* sparen_*
i.erwerbst_1 nodebt kredit* sozialhilfe06_1 lnw06_* bilzeit_* owner i.altvorsor support_* divi_k* 
beamte lowzuf highzuf deutsch_* sparbuch_* west i.mode07 selbst_1 if xnetto < 20;

			
replace l_miss_flag = 1 if miss_flag_2_02 == 1;
replace xmiss_flag_207_f = 1 if miss_flag_1_07 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if p10000_07 == 1 & p_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_07 == 1 & p_person_flag_07 == 1;
gen 	miss_flag_2_07 = imp_ins+resid[random] if  p10000_07 == 1 & p_person_flag_07 == 1;


sum miss_flag_2_07, de;
replace miss_flag_2_07 = 1 if (miss_flag_2_07 > r(p90) & miss_flag_2_07 != .);
replace miss_flag_2_07 = 0 if (miss_flag_2_07 < 1);
tab miss_flag_2_07 p_person_flag_07, mis;

drop miss_flag l_miss_flag random count resid imp_ins;


* 	2007 ********************************************************************;
** 	consumer credits             *******************************************;

gen l_miss_flag = c02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = c02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t {;
gen xmiss_flag_407_`comp' = `comp'02000_07;
recode xmiss_flag_407_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	c_person_flag_07 = 0;
replace c_person_flag_07 = 1 if (xnetto < 20) &  (miss_flag == 0)  & (xmiss_flag_407_f == 0) & (xmiss_flag_407_p == 0); 

xi: logit miss_flag l_miss_flag xmiss_flag_402_* xmiss_flag_407_* frau agenew agenew2 hhgr_* kinder_* 
sparen_* i.erwerbst_1 nodebt kredit* sozialhilfe06_1 lnw06_* bilzeit_* owner i.altvorsor support_*
divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* west i.mode07 selbst_1 if xnetto < 20;

replace l_miss_flag = 1 if miss_flag_4_02 == 1;
replace xmiss_flag_407_f = 1 if miss_flag_1_07 == 1;
replace xmiss_flag_407_p = 1 if miss_flag_2_07 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if c10000_07 == 1 & c_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_07 == 1 & c_person_flag_07 == 1;
gen 	miss_flag_4_07 = imp_ins+resid[random] 		if c10000_07 == 1 & c_person_flag_07 == 1;


sum miss_flag_4_07, de;
replace miss_flag_4_07 = 1 if (miss_flag_4_07 > r(p90) & miss_flag_4_07 != .);
replace miss_flag_4_07 = 0 if (miss_flag_4_07 < 1);
tab miss_flag_4_07 c_person_flag_07, mis;

drop miss_flag l_miss_flag random count resid imp_ins;



keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* resonse indicator vars other wealth components */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation vars */ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;



* 2002 - 2nd round ********************************************************************;
** Financial assets ***********************************************************;



use 	 $folder3/reg_a_02.dta, clear; 
keep  persnr snetto spop psample frau agenew sfamstd hhgr_* kinder_* sparen_* nopartner erwerbst_1 nodebt 
kredit* sozialhilfe01_* agenew2 lnw02_* bilzeit_* owner altvorsor lotto* lnsh32* aktien_*
p11302_2 p11302_ka support_* divi_k* capic02_* capia02_* beamte lowzuf highzuf p0104 
famstd deutsch_* sparbuch_* mode02 selbst* west;

sort persnr;

save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;

* 	2002 ********************************************************************;
** 	Financial assets ***********************************************************;
drop miss_flag_1_02;

gen p_miss_flag = f02000_07;
recode p_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = f02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag xmiss_flag_102_* p_miss_flag frau agenew agenew2 hhgr_* kinder_* sparen_* 
i.erwerbst_1 nodebt kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka 
support_* divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* i.mode02 selbst_1 west if snetto < 20;

/* Updated with 2007 NR structure for lag */
/* Updated 2002 NR structure other vars */
replace p_miss_flag = 1 if miss_flag_1_07 == 1;
replace xmiss_flag_102_p = 1 if miss_flag_2_02 == 1;
replace xmiss_flag_102_c = 1 if miss_flag_4_02 == 1;

predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if f10000_02 == 1 & f_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_02 == 1 & f_person_flag_02 == 1;
gen 	miss_flag_1_02 = imp_ins+resid[random] if  f10000_02 == 1 & f_person_flag_02 == 1;


sum miss_flag_1_02, de;
replace miss_flag_1_02 = 1 if (miss_flag_1_02 > r(p90) & miss_flag_1_02 != .);
replace miss_flag_1_02 = 0 if (miss_flag_1_02 < 1);
tab miss_flag_1_02 f_person_flag_02, mis;
drop miss_flag _merge p_miss_flag random count resid imp_ins;



* 	2002 ********************************************************************;
** 	Home market value ***********************************************************;

drop miss_flag_2_02;

gen p_miss_flag = p02000_07;
recode p_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = p02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag xmiss_flag_202_* p_miss_flag frau agenew agenew2 hhgr_* kinder_* sparen_*
i.erwerbst_1 nodebt kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka
support_* divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* i.mode02 selbst_1 west if snetto < 20;


/* Updated with 2007 NR structure for lag */
/* Updated 2002 NR structure other vars */
replace p_miss_flag = 1 if miss_flag_2_07 == 1;
replace xmiss_flag_202_f = 1 if miss_flag_1_02 == 1;
replace xmiss_flag_202_c = 1 if miss_flag_4_02 == 1;

predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if p10000_02 == 1 & p_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_02 == 1 & p_person_flag_02 == 1;
gen 	miss_flag_2_02 = imp_ins+resid[random] if  p10000_02 == 1 & p_person_flag_02 == 1;


sum miss_flag_2_02, de;
replace miss_flag_2_02 = 1 if (miss_flag_2_02 > r(p90) & miss_flag_2_02 != .);
replace miss_flag_2_02 = 0 if (miss_flag_2_02 < 1);
tab miss_flag_2_02 p_person_flag_02, mis;

drop miss_flag p_miss_flag random count resid imp_ins;




* 	2002 ********************************************************************;
** 	consumer credits              *******************************************;

drop miss_flag_4_02;

gen p_miss_flag = c02000_07;
recode p_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = c02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag xmiss_flag_402_p xmiss_flag_402_f xmiss_flag_402_e xmiss_flag_402_b* 
p_miss_flag frau agenew agenew2 hhgr_* kinder_* sparen_* i.erwerbst_1 nodebt 
kredit* sozialhilfe01_*  lnw02_* bilzeit_* owner i.altvorsor p11302_ka support_* divi_k*
beamte lowzuf highzuf deutsch_* sparbuch_* i.mode02 selbst_1 west  if snetto < 20;

replace p_miss_flag = 1 if miss_flag_4_07 == 1;
replace xmiss_flag_402_f = 1 if miss_flag_1_02 == 1;
replace xmiss_flag_402_p = 1 if miss_flag_2_02 == 1;


predict imp_ins 					if snetto < 20;
sum 	imp_ins 					if c10000_02 == 1 & c_person_flag_02 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if snetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_02 == 1 & c_person_flag_02 == 1;
gen 	miss_flag_4_02 = imp_ins+resid[random] 		if c10000_02 == 1 & c_person_flag_02 == 1;


sum miss_flag_4_02, de;
replace miss_flag_4_02 = 1 if (miss_flag_4_02 > r(p90) & miss_flag_4_02 != .);
replace miss_flag_4_02 = 0 if (miss_flag_4_02 < 1);
tab miss_flag_4_02 c_person_flag_02, mis;

drop miss_flag p_miss_flag random count resid imp_ins;


keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation */ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr;
save $IMP_DATA, replace;




* 	2007 *** 2nd round ********************************************************************;
** 	Financial assets ***********************************************************;


use 	 $folder4/reg_a_07.dta, clear; 
keep  persnr xnetto frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt kredit* sozialhilfe06_* lnw06_* bilzeit_* owner /*i.*/altvorsor 
support_* divi_k* selbst* beamte lowzuf highzuf 
deutsch_* sparbuch_* west mode07;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;

drop miss_flag_1_07;

gen l_miss_flag = f02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = f02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag l_miss_flag xmiss_flag_102_* xmiss_flag_107_* frau agenew agenew2 hhgr_* 
kinder_* sparen_* i.erwerbst_1 nodebt kredit* sozialhilfe06_* lnw06_* bilzeit_* owner i.altvorsor support_* 
divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* i.mode07 west selbst_1 if xnetto < 20;


/* Updated with 2002 NR structure for lag */
/* Updated 2007 NR structure other vars */
replace l_miss_flag = 1 if miss_flag_1_02 == 1;
replace xmiss_flag_107_c = 1 if miss_flag_4_07 == 1;
replace xmiss_flag_107_p = 1 if miss_flag_2_07 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if f10000_07 == 1 & f_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_07 == 1 & f_person_flag_07 == 1;
gen 	miss_flag_1_07 = imp_ins+resid[random] if  f10000_07 == 1 & f_person_flag_07 == 1;


sum miss_flag_1_07, de;
replace miss_flag_1_07 = 1 if (miss_flag_1_07 > r(p90) & miss_flag_1_07 != .);
replace miss_flag_1_07 = 0 if (miss_flag_1_07 < 1);
tab miss_flag_1_07 f_person_flag_02, mis;
drop miss_flag _merge l_miss_flag random count resid imp_ins;



* 	2007 ********************************************************************;
** 	Home market value ***********************************************************;

drop miss_flag_2_07;

gen l_miss_flag = p02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = p02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;


xi: logit miss_flag l_miss_flag xmiss_flag_202_* xmiss_flag_207_* frau agenew agenew2 hhgr_* kinder_* 
sparen_* i.erwerbst_1 nodebt kredit* sozialhilfe06_1 lnw06_* bilzeit_* owner i.altvorsor support_* 
divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* west i.mode07 selbst_1 if xnetto < 20;

			

/* Updated with 2007 NR structure for lag */
/* Updated 2002 NR structure other vars */
replace l_miss_flag = 1 if miss_flag_2_02 == 1;
replace xmiss_flag_207_f = 1 if miss_flag_1_07 == 1;
replace xmiss_flag_207_c = 1 if miss_flag_4_07 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if p10000_07 == 1 & p_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_07 == 1 & p_person_flag_07 == 1;
gen 	miss_flag_2_07 = imp_ins+resid[random] if  p10000_07 == 1 & p_person_flag_07 == 1;


sum miss_flag_2_07, de;
replace miss_flag_2_07 = 1 if (miss_flag_2_07 > r(p90) & miss_flag_2_07 != .);
replace miss_flag_2_07 = 0 if (miss_flag_2_07 < 1);
tab miss_flag_2_07 p_person_flag_07, mis;

drop miss_flag l_miss_flag random count resid imp_ins;





* 	2007 ********************************************************************;
** 	Consumer credits                 *******************************************;

drop miss_flag_4_07;

gen l_miss_flag = c02000_02;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = c02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag l_miss_flag xmiss_flag_402_* xmiss_flag_407_* frau agenew agenew2 hhgr_* kinder_* 
sparen_* i.erwerbst_1 nodebt kredit* sozialhilfe06_1 lnw06_* bilzeit_* owner i.altvorsor support_* 
divi_k* beamte lowzuf highzuf deutsch_* sparbuch_* west i.mode07 selbst_1 if xnetto < 20;

replace l_miss_flag = 1 if miss_flag_4_02 == 1;
replace xmiss_flag_407_f = 1 if miss_flag_1_07 == 1;
replace xmiss_flag_407_p = 1 if miss_flag_2_07 == 1;

predict imp_ins 					if xnetto < 20;
sum 	imp_ins 					if c10000_07 == 1 & c_person_flag_07 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if xnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_07 == 1 & c_person_flag_07 == 1;
gen 	miss_flag_4_07 = imp_ins+resid[random] 		if c10000_07 == 1 & c_person_flag_07 == 1;


sum miss_flag_4_07, de;
replace miss_flag_4_07 = 1 if (miss_flag_4_07 > r(p90) & miss_flag_4_07 != .);
replace miss_flag_4_07 = 0 if (miss_flag_4_07 < 1);
tab miss_flag_4_07 c_person_flag_07, mis;

drop miss_flag l_miss_flag random count resid imp_ins;


keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation */ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;






* 	2012 ********************************************************************;
** 	Financial assets ***********************************************************;


use 	 $folder8/reg_a_12.dta, clear; 
keep  persnr bcnetto frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt 
kredit* sozialhilfe11_* lnw11_* bilzeit_* owner altvorsor support_* divi_k* selbst* 
beamte lowzuf highzuf deutsch_* sparbuch_* west mode12;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;

gen l_miss_flag = f02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = f02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p e b t c l h {;
gen xmiss_flag_112_`comp' = `comp'02000_12;
recode xmiss_flag_112_`comp' (. 1 0 = 0) (2 = 1);
};

gen f_person_flag_12 = 0;
replace f_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_112_p == 0) & (xmiss_flag_112_c == 0);  

xi: logit miss_flag l_miss_flag xmiss_flag_112_* xmiss_flag_107_* frau agenew agenew2 hhgr_* kinder_* sparen_* 
erwerbst_1 nodebt kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor support_* divi_k* beamte 
lowzuf highzuf deutsch_* sparbuch_* west i.mode12 selbst_1 if bcnetto < 20;

replace l_miss_flag = 1 if miss_flag_1_07 == 1;


predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if f10000_12 == 1 & f_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_12 == 1 & f_person_flag_12 == 1;
gen 	miss_flag_1_12 = imp_ins+resid[random] 		if f10000_12 == 1 & f_person_flag_12 == 1;


sum miss_flag_1_12, de;
replace miss_flag_1_12 = 1 if (miss_flag_1_12 > r(p90) & miss_flag_1_12 != .);
replace miss_flag_1_12 = 0 if (miss_flag_1_12 < 1);
tab miss_flag_1_12 f_person_flag_12, mis;

tab miss_flag_1_12 f_person_flag_12, mis;

drop miss_flag _merge l_miss_flag random count resid imp_ins;



* 	2012 ********************************************************************;
** 	Home market value ***********************************************************;

/* Flag-Response 2002 und NR 2002 */;

gen l_miss_flag = p02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = p02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c l h {;
gen xmiss_flag_212_`comp' = `comp'02000_12;
recode xmiss_flag_212_`comp' (. 1 0 = 0) (2 = 1);
};

gen p_person_flag_12 = 0;
replace p_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_212_f == 0)  & (xmiss_flag_212_c == 0);   

xi: logit miss_flag l_miss_flag xmiss_flag_212_* xmiss_flag_207_* frau agenew agenew2 hhgr_* kinder_* sparen_* 
erwerbst_1 nodebt kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor support_* divi_k* beamte lowzuf 
highzuf deutsch_* sparbuch_* west i.mode12 selbst_1 if bcnetto < 20;

replace l_miss_flag = 1 if miss_flag_2_07 == 1;
replace xmiss_flag_212_f = 1 if miss_flag_1_12 == 1;

predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if p10000_12 == 1 & p_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_12 == 1 & p_person_flag_12 == 1;
gen 	miss_flag_2_12 = imp_ins+resid[random] 		if p10000_12 == 1 & p_person_flag_12 == 1;


sum miss_flag_2_12, de;
replace miss_flag_2_12 = 1 if (miss_flag_2_12 > r(p90) & miss_flag_2_12 != .);
replace miss_flag_2_12 = 0 if (miss_flag_2_12 < 1);
tab miss_flag_2_12 p_person_flag_12, mis;

tab miss_flag_2_12 p_person_flag_12, mis;

drop miss_flag l_miss_flag random count resid imp_ins;



* 	2012 ********************************************************************;
** 	Consumer credits              *******************************************;

gen l_miss_flag = c02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = c02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t {;
gen xmiss_flag_412_`comp' = `comp'02000_12;
recode xmiss_flag_412_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	c_person_flag_12 = 0;
replace c_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_412_f == 0)  & (xmiss_flag_412_p == 0);   

xi: logit miss_flag l_miss_flag xmiss_flag_412_* frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt
kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor  support_* divi_k* beamte lowzuf highzuf deutsch_*
sparbuch_* west if bcnetto < 20;

replace l_miss_flag = 1 if miss_flag_4_07 == 1;
replace xmiss_flag_412_f = 1 if miss_flag_1_12 == 1;
replace xmiss_flag_412_p = 1 if miss_flag_2_12 == 1;


predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if c10000_12 == 1 & c_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_12 == 1 & c_person_flag_12 == 1;
gen 	miss_flag_4_12 = imp_ins+resid[random] 		if c10000_12 == 1 & c_person_flag_12 == 1;


sum 	miss_flag_4_12, de;
replace miss_flag_4_12 = 1 if (miss_flag_4_12 > r(p90) & miss_flag_4_12 != .);
replace miss_flag_4_12 = 0 if (miss_flag_4_12 < 1);
tab 	miss_flag_4_12 c_person_flag_12, mis;

tab 	miss_flag_4_12 c_person_flag_12, mis;

drop    miss_flag l_miss_flag random count resid imp_ins;


keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation */ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;



* 	2012 ** 2nd round ******************************************************************;
** 	Financial assets		 ***********************************************************;


use 	 $folder8/reg_a_12.dta, clear; 
keep  persnr bcnetto frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt 
kredit* sozialhilfe11_* lnw11_* bilzeit_* owner altvorsor support_* divi_k* selbst* beamte lowzuf highzuf deutsch_* sparbuch_* west mode12;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;

merge persnr using $IMP_DATA;
sort persnr;

/* Flag-Response 2007 und NR 2007 */;
drop miss_flag_1_12;

gen l_miss_flag = f02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = f02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag l_miss_flag xmiss_flag_112_* xmiss_flag_107_* frau agenew agenew2 hhgr_* kinder_* sparen_*
erwerbst_1 nodebt kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor support_* divi_k* beamte lowzuf 
highzuf deutsch_* sparbuch_* west i.mode12 selbst_1 if bcnetto < 20;

/* Updated with 2007 NR structure for lag */
/* Updated 2012 NR structure other vars */
replace l_miss_flag = 1 if miss_flag_1_07 == 1;
replace xmiss_flag_112_p = 1 if miss_flag_2_12 == 1;
replace xmiss_flag_112_c = 1 if miss_flag_4_12 == 1;

predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if f10000_12 == 1 & f_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if f10000_12 == 1 & f_person_flag_12 == 1;
gen 	miss_flag_1_12 = imp_ins+resid[random] 		if f10000_12 == 1 & f_person_flag_12 == 1;


sum miss_flag_1_12, de;
replace miss_flag_1_12 = 1 if (miss_flag_1_12 > r(p90) & miss_flag_1_12 != .);
replace miss_flag_1_12 = 0 if (miss_flag_1_12 < 1);
tab miss_flag_1_12 f_person_flag_12, mis;

tab miss_flag_1_12 f_person_flag_12, mis;

drop miss_flag _merge l_miss_flag random count resid imp_ins;



* 	2012 ********************************************************************;
** 	Home market value ***********************************************************;

/* Flag-Response 2002 und NR 2002 */;
drop miss_flag_2_12;

gen l_miss_flag = p02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = p02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag l_miss_flag xmiss_flag_212_* xmiss_flag_207_* frau agenew agenew2 hhgr_* kinder_* sparen_* 
erwerbst_1 nodebt kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor support_* divi_k* beamte lowzuf 
highzuf deutsch_* sparbuch_* west i.mode12 selbst_1 if bcnetto < 20;


/* Updated with 2007 NR structure for lag */
/* Updated 2012 NR structure other vars */
replace l_miss_flag = 1 if miss_flag_2_07 == 1;
replace xmiss_flag_212_f = 1 if miss_flag_1_12 == 1;
replace xmiss_flag_212_c = 1 if miss_flag_4_12 == 1;

predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if p10000_12 == 1 & p_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if p10000_12 == 1 & p_person_flag_12 == 1;
gen 	miss_flag_2_12 = imp_ins+resid[random] 		if p10000_12 == 1 & p_person_flag_12 == 1;


sum miss_flag_2_12, de;
replace miss_flag_2_12 = 1 if (miss_flag_2_12 > r(p90) & miss_flag_2_12 != .);
replace miss_flag_2_12 = 0 if (miss_flag_2_12 < 1);
tab miss_flag_2_12 p_person_flag_12, mis;

tab miss_flag_2_12 p_person_flag_12, mis;

drop miss_flag l_miss_flag random count resid imp_ins;



* 	2012 ********************************************************************;
** 	Consumer credits              *******************************************;

drop miss_flag_4_12;

gen l_miss_flag = c02000_07;
recode l_miss_flag (. 1 0 = 0) (2 = 1);

gen miss_flag = c02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

xi: logit miss_flag l_miss_flag xmiss_flag_412_* frau agenew agenew2 hhgr_* kinder_* sparen_* erwerbst_1 nodebt
kredit* sozialhilfe11_* lnw11_* bilzeit_* owner i.altvorsor  support_* divi_k* beamte lowzuf highzuf deutsch_*
sparbuch_* west if bcnetto < 20;

/* Updated with 2007 NR structure for lag */
/* Updated 2012 NR structure other vars */
replace l_miss_flag = 1 if miss_flag_4_07 == 1;
replace xmiss_flag_412_f = 1 if miss_flag_1_12 == 1;
replace xmiss_flag_412_p = 1 if miss_flag_2_12 == 1;


predict imp_ins 					if bcnetto < 20;
sum 	imp_ins 					if c10000_12 == 1 & c_person_flag_12 == 1;
corr 	imp_ins miss_flag;
gen 	resid=miss_flag-imp_ins  	if bcnetto < 20;
_pctile resid, p(0.5 99.5); 		return list;
replace resid=. 					if resid<=r(r1) & resid>=r(r2);
gsort   - resid persnr;
gen     count=_n if resid != .;
count   if resid != .; return list;
gen     random=round((r(N)-1)*uniform())+1 			if c10000_12 == 1 & c_person_flag_12 == 1;
gen 	miss_flag_4_12 = imp_ins+resid[random] 		if c10000_12 == 1 & c_person_flag_12 == 1;


sum 	miss_flag_4_12, de;
replace miss_flag_4_12 = 1 if (miss_flag_4_12 > r(p90) & miss_flag_4_12 != .);
replace miss_flag_4_12 = 0 if (miss_flag_4_12 < 1);
tab 	miss_flag_4_12 c_person_flag_12, mis;



drop xmiss_flag* miss_flag l_miss_flag random count resid imp_ins;



keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*
 
/* NR simulation */ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;

};

di `xyz';
local xyz = `xyz' + 1;

};

