/* This part: calculates results for mobility analysis for all years simultaneously */;
/* First: set folder defining results AND missingness mechanism */;

set more off

use "xxx\$METHOD\data1000_heck_imp_results.dta", clear
append using "xxx\$METHOD\data1000_ls_imp_results.dta"
append using "xxx\$METHOD\data1000_ls_age_imp_results.dta"
append using "xxx\$METHOD\data1000_ice_imp_results.dta"
append using "xxx\$METHOD\data1000_icels_imp_results.dta"
append using "xxx\$METHOD\data1000_icels_age_imp_results.dta"


keep results_1_0214-results_1_0219 results_2_0214-results_2_0219 results_4_0214-results_4_0219
keep if results_1_0214 != .

/* if there is an error because "something, something mi and format" 
the following comes in handy, as it quickly mi unsets any data set: */;
/* gen _mi_m = 0
gen _mi_id = _n
gen _mi_miss = 0
replace _mi_miss = 1
mi unset
keep if mi_m == 0
drop mi_*  */;

rename results_1_0214 out1_2
rename results_1_0215 out1_3
rename results_1_0216 out1_4

rename results_2_0214 out2_2
rename results_2_0215 out2_3
rename results_2_0216 out2_4

rename results_4_0214 out4_2
rename results_4_0215 out4_3
rename results_4_0216 out4_4

rename results_1_0217 out11_2
rename results_1_0218 out11_3
rename results_1_0219 out11_4

rename results_2_0217 out12_2
rename results_2_0218 out12_3
rename results_2_0219 out12_4

rename results_4_0217 out14_2
rename results_4_0218 out14_3
rename results_4_0219 out14_4

gen fyi = _n

reshape long out1_ out2_ out4_ out11_ out12_ out14_ , i(fyi) j(year)

set obs 18001

foreach var in  out1_ out2_ out4_ out11_ out12_ out14_ {
replace `var' = 0 if _n==18001
}

gen method = 1
replace method = 2 if fyi >= 1001 & fyi <= 2000
replace method = 3 if fyi >= 2001 & fyi <= 3000
replace method = 4 if fyi >= 3001 & fyi <= 4000
replace method = 5 if fyi >= 4001 & fyi <= 5000
replace method = 6 if fyi >= 5001 & fyi <= 6000

mahascore out1_ out11_ , gen(out_res_1) refobs(18001) unsquared compute_invcovarmat
mahascore out2_ out12_ , gen(out_res_2) refobs(18001) unsquared compute_invcovarmat
mahascore out4_ out14_ , gen(out_res_4) refobs(18001) unsquared compute_invcovarmat

/* tabulate overall mahascore weighted results */;
mean out_res_1, over(method)
mean out_res_2, over(method)
mean out_res_4, over(method)

/* tabulate specific results */;
mean out1_ out11_, over(method)
mean out2_ out12_, over(method)
mean out4_ out14_, over(method)


exit









