#delimit;
clear;
set more off;
version 9;

global folder2	"xxx\DATA\soep29_de\stata\"; 			/* RAW DATA SOEP v29 */;
global folder3	"xxx\wealth_sim_16\wealth\2002_new\"; 	/* EXTRACTED WEALTH DATA 2002*/;
global folder8  "xxx\wealth_sim_16\wealth\2012\";		/* EXTRACTED WEALTH DATA 2012*/;
global folder4  "xxx\wealth_sim_16\wealth\2007\";		/* EXTRACTED WEALTH DATA 2007*/;
global folder7  "xxx\wealth_sim_16\wealth\wealth_all\";	/* JOINT FOLDER WEALTH DATA */;

/* Note: all variable naming schemes directly derived from SOEP use-files, see documentation online */;


/* set input data sets = imputed data sets by mechanism of missingness */;
local METH = 1;

/* set folders with results (imputed data sets) */;

if `METH' == 1 {;
global folder    "xxx\wealth_sim_16\meta2012_MAR\temp\";
};
if `METH' == 2 {;
global folder    "xxx\wealth_sim_16\meta2012_NMAR1\temp\";
};
if `METH' == 3 {;
global folder    "xxx\wealth_sim_16\meta2012_NMAR2\temp\";
};


foreach file in 1 2 3 4 5 6 {;    	/* 6 Methods of imputation (see lines 68-73) */
foreach round in 1 2 4 {;			/* 3 assets/liabilities */

foreach year in "02" "07" "12" {;

/* results are stored in a matrix and then saved (see end of do_file) */;

matrix results_`round'_`year' = J(1000,27,.);

/********* imputation variables :  ********************************************/;
local i2 = "p0100"; /* Home market value */
local i1 = "f0100"; /* Financial assets */
local i4 = "c0100"; /* Consumer credits */

/********* filter variables :       ********************************************/;
local j2 = "p10000_"; /* Home market value */
local j1 = "f10000_"; /* Financial assets */
local j4 = "c10000_"; /* Consumer credits */

/********* flag variables :  **************************************************/;
local k2 = "p02000_"; /* Home market value */
local k1 = "f02000_"; /* Financial assets */
local k4 = "c02000_"; /* Consumer credits */

/********* asset prefix ******************************************************/;
local m2 = "p_"; 	/*  Home market value */
local m1 = "f_"; 	/*  Financial assets */
local m4 = "c_";	/*  Consumer credits */


forvalues i = 1/1000 {;
global 	IN_DATA_0 	$folder/imp_data`i'.dta;

if `file' == 1 {; local datafile = "data`i'_heck_imp"; };
if `file' == 2 {; local datafile = "data`i'_ls_imp"; };
if `file' == 3 {; local datafile = "data`i'_ls_age_imp"; };
if `file' == 4 {; local datafile = "data`i'_ice_imp"; };
if `file' == 5 {; local datafile = "data`i'_icels_imp"; };
if `file' == 6 {; local datafile = "data`i'_icels_age_imp"; };



local var_i `i`round'';   	/* imputation variables */;
local var_j `j`round'';		/* filter variables */;
local var_k `k`round'';		/* flag variables */;
local var_m `m`round'';		/* asset prefix */;


/* Draw data from original input data set */;
use persnr 	`var_i'a_02 
			`var_i'b_02 
			`var_i'c_02 
			`var_i'd_02 
			`var_i'e_02 
			`var_i'a_07 
			`var_i'b_07 
			`var_i'c_07 
			`var_i'd_07 
			`var_i'e_07 
			`var_i'a_12 
			`var_i'b_12 
			`var_i'c_12 
			`var_i'd_12 
			`var_i'e_12 using $IN_DATA_0, clear;

foreach jahr in "02" "07" "12" {;			
rename `var_i'a_`jahr' obs_`var_i'a_`jahr';
rename `var_i'b_`jahr' obs_`var_i'b_`jahr';
rename `var_i'c_`jahr' obs_`var_i'c_`jahr';
rename `var_i'd_`jahr' obs_`var_i'd_`jahr';
rename `var_i'e_`jahr' obs_`var_i'e_`jahr';
};

sort persnr;

/* Draw respective imputed data set */;
merge persnr using $folder\`datafile'; /* Hier Simulationsdatensatz einfgen (siehe oben!) */;
drop _merge;

gen `var_i'y_`year' = (`var_i'a_`year' + `var_i'b_`year' + `var_i'c_`year' + `var_i'd_`year' + `var_i'e_`year') / 5;

sum obs_`var_i'a_`year' if miss_flag_`round'_`year' != .;
local mean_x = r(mean);
local sd_x = r(sd) / sqrt(r(N));

foreach sign in a b c d e {;
sum `var_i'`sign'_`year' if miss_flag_`round'_`year' != .;
local var_`sign' = r(Var);
local mean_`sign' = r(mean);
count if miss_flag_`round'_`year' != .;
local obscount = r(N);
local var_`sign' = sqrt(`var_`sign'') / sqrt(`obscount');
};

local o_mean = (`mean_a' + `mean_b' + `mean_c' + `mean_d' + `mean_e') / 5;
local within = ((`var_a')^2 + (`var_b')^2 + (`var_c')^2 + (`var_d')^2 + (`var_e')^2 )  / 5; /* within-variance */;
local between = (1 / 4)* ( (`mean_a' - `o_mean')^2 + (`mean_b' - `o_mean')^2 + (`mean_c' - `o_mean')^2 + (`mean_d' - `o_mean')^2 + (`mean_e' - `o_mean')^2 ); 
local total_v = `within' + 1.2*`between';
local total_sd = sqrt(`total_v');
local meanscomp = (`mean_x' - `o_mean') / `mean_x';

matrix results_`round'_`year'[`i',1] = (`mean_x');
matrix results_`round'_`year'[`i',2] = (`sd_x');
matrix results_`round'_`year'[`i',3] = (`o_mean');
matrix results_`round'_`year'[`i',4]= (`total_sd');
matrix results_`round'_`year'[`i',8] = (`meanscomp');



sum obs_`var_i'a_`year' if miss_flag_`round'_`year' == 1;
local meanmiss_x = r(mean);
local sdmiss_x = r(sd) / sqrt(r(N));

foreach sign in a b c d e {;
sum `var_i'`sign'_`year' if miss_flag_`round'_`year' == 1;
local varmiss_`sign' = r(Var);
local meanmiss_`sign' = r(mean);
count if miss_flag_`round'_`year' == 1;
local obscountmiss = r(N);
local varmiss_`sign' = sqrt(`varmiss_`sign'') / sqrt(`obscountmiss');
};

local omiss_mean = (`meanmiss_a' + `meanmiss_b' + `meanmiss_c' + `meanmiss_d' + `meanmiss_e') / 5;
local withinmiss = ((`var_a')^2 + (`var_b')^2 + (`var_c')^2 + (`var_d')^2 + (`var_e')^2)  / 5; /* within-variance */;
local betweenmiss = (1 / 4)* ( (`meanmiss_a' - `omiss_mean')^2 + (`meanmiss_b' - `omiss_mean')^2 + (`meanmiss_c' - `omiss_mean')^2 + (`meanmiss_d' - `omiss_mean')^2 + (`meanmiss_e' - `omiss_mean')^2 ); 
local totalmiss_v = `withinmiss' + 1.2*`betweenmiss';
local totalmiss_sd = sqrt(`totalmiss_v');
local meanscompmiss = (`meanmiss_x' - `omiss_mean') / `meanmiss_x';



matrix results_`round'_`year'[`i',20] = (`meanmiss_x');
matrix results_`round'_`year'[`i',21] = (`sdmiss_x');
matrix results_`round'_`year'[`i',22] = (`omiss_mean');
matrix results_`round'_`year'[`i',23]= (`totalmiss_sd');
matrix results_`round'_`year'[`i',27] = (`meanscompmiss');


/* Inequality indices */;

_pctile obs_`var_i'a_`year' if miss_flag_`round'_`year' == 1, p(50, 99);
local pipi = r(r2) / r(r1);

_pctile `var_i'a_`year' if miss_flag_`round'_`year' == 1, p(50, 99);
local p99p50 = r(r2) / r(r1);

foreach sign in b c d e {;
_pctile `var_i'`sign'_`year' if miss_flag_`round'_`year' == 1, p(50, 99);
local p99p50 = `p99p50' + ( r(r2) / r(r1) );
};
local p99p50 = `p99p50' / 5;
local p99p50 = `pipi' - `p99p50';

matrix results_`round'_`year'[`i',9] = (`p99p50');



/* Original data */;
inequal7 obs_`var_i'a_`year' if miss_flag_`round'_`year' == 1, returnscalars;
local covx = r(cov);  /*"coefficient of variation"*/;
local ginix = r(gini);  /*"Gini coefficient"'*/;
local mldx = r(mld); /*"Mean Log Deviation (or generalised entropy measure with sensitivity parameter 0)"*/;

/* Imputations */;
inequal7 `var_i'a_`year' if miss_flag_`round'_`year' == 1, returnscalars;
local cov = r(cov);  /*"coefficient of variation"*/;
local gini = r(gini);  /*"Gini coefficient"'*/;
local mld = r(mld); /*"Mean Log Deviation (or generalised entropy measure with sensitivity parameter 0)"*/;

foreach sign in b c d e {;
inequal7 `var_i'`sign'_`year' if miss_flag_`round'_`year' == 1, returnscalars;
local cov = `cov' + r(cov);  /*"coefficient of variation"*/;
local gini = `gini' + r(gini);  /*"Gini coefficient"'*/;
local mld = `mld' + r(mld); /*"Mean Log Deviation (or generalised entropy measure with sensitivity parameter 0)"*/;
};

local cov = `cov' / 5; local cov = `covx' - `cov'; /*"coefficient of variation"*/;
local gini = `gini' / 5; local gini = `ginix' - `gini';  /*"Gini coefficient"'*/;
local mld = `mld' / 5; local mld = `mldx' - `mld'; /*"Mean Log Deviation (or generalised entropy measure with sensitivity parameter 0)"*/;

matrix results_`round'_`year'[`i',10] = (`cov');
matrix results_`round'_`year'[`i',11] = (`gini');
matrix results_`round'_`year'[`i',12] = (`mld');



/* unset mi data for wide format */;
gen _mi_m = 0;
gen _mi_id = _n;
gen _mi_miss = 0;
replace _mi_miss = 1;
keep if  miss_flag_`round'_`year' != .; 
mi unset;
keep if mi_m == 0;
drop mi_* ;

local ksmir = 0;
foreach implicate in a b c d e {;
preserve;
#delimit;
keep if miss_flag_`round'_`year' == 1; 
sort obs_`var_i'a_`year';
keep persnr obs_`var_i'a_`year' `var_i'`implicate'_`year';
rename obs_`var_i'a_`year' observed0;
rename `var_i'`implicate'_`year' observed1;
reshape long observed, i(persnr) j(imputed);
sort observed;
ksmirnov observed, by(imputed); 
local ksmir = `ksmir' + r(D);
restore;
};

local ksmir = `ksmir' / 5;
di `ksmir';
matrix results_`round'_`year'[`i',13] = (`ksmir'); 


/* results for mobility analyis only calulated once, draw data as above */;

if `year' == 02 {;

use persnr 	`var_i'a_02 
			`var_i'b_02 
			`var_i'c_02 
			`var_i'd_02 
			`var_i'e_02 
			`var_i'a_07 
			`var_i'b_07 
			`var_i'c_07 
			`var_i'd_07 
			`var_i'e_07 
			`var_i'a_12 
			`var_i'b_12 
			`var_i'c_12 
			`var_i'd_12 
			`var_i'e_12 using $IN_DATA_0, clear;

foreach jahr in "02" "07" "12" {;			
rename `var_i'a_`jahr' obs_`var_i'a_`jahr';
rename `var_i'b_`jahr' obs_`var_i'b_`jahr';
rename `var_i'c_`jahr' obs_`var_i'c_`jahr';
rename `var_i'd_`jahr' obs_`var_i'd_`jahr';
rename `var_i'e_`jahr' obs_`var_i'e_`jahr';
};

sort persnr;

merge persnr using $folder\`datafile'; /* simulation data set (as above) */;
drop _merge;


gen `var_i'u_02 = (`var_i'a_02 + `var_i'b_02 + `var_i'c_02 + `var_i'd_02 + `var_i'e_02) / 5;
gen `var_i'u_07 = (`var_i'a_07 + `var_i'b_07 + `var_i'c_07 + `var_i'd_07 + `var_i'e_07) / 5;
gen `var_i'u_12 = (`var_i'a_12 + `var_i'b_12 + `var_i'c_12 + `var_i'd_12 + `var_i'e_12) / 5;

corr obs_`var_i'a_02 obs_`var_i'a_07 if miss_flag_`round'_02 == 1 | miss_flag_`round'_07 == 1; matrix sepp = r(C); local corr1o = sepp[2,1];
corr obs_`var_i'a_02 obs_`var_i'a_12 if miss_flag_`round'_02 == 1 | miss_flag_`round'_12 == 1; matrix sepp = r(C); local corr2o = sepp[2,1];
corr obs_`var_i'a_07 obs_`var_i'a_12 if miss_flag_`round'_07 == 1 | miss_flag_`round'_12 == 1; matrix sepp = r(C); local corr3o = sepp[2,1];

mat list sepp;

corr `var_i'u_02 `var_i'u_07 if miss_flag_`round'_02 == 1 | miss_flag_`round'_07 == 1; matrix sepp = r(C); local corr1 = sepp[2,1];
corr `var_i'u_02 `var_i'u_12 if miss_flag_`round'_02 == 1 | miss_flag_`round'_12 == 1; matrix sepp = r(C); local corr2 = sepp[2,1];
corr `var_i'u_07 `var_i'u_12 if miss_flag_`round'_07 == 1 | miss_flag_`round'_12 == 1; matrix sepp = r(C); local corr3 = sepp[2,1];

mat list sepp;

local corr1 = `corr1o' - `corr1'; 
local corr2 = `corr2o' - `corr2'; 
local corr3 = `corr3o' - `corr3'; 

di `corr3';

matrix results_`round'_`year'[`i',14] = (`corr1');
matrix results_`round'_`year'[`i',15] = (`corr2');
matrix results_`round'_`year'[`i',16] = (`corr3');

foreach jahr in "02" "07" "12" {;
gen mobility_`jahr' = .;
replace mobility_`jahr' = 1 if miss_flag_`round'_`jahr' != .;
_pctile `var_i'u_`jahr' if miss_flag_`round'_`jahr' != ., p(10, 20, 30, 40, 50, 60, 70, 80, 90);
replace mobility_`jahr' = 2 if  `var_i'u_`jahr' > r(r1) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 3 if  `var_i'u_`jahr' > r(r2) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 4 if  `var_i'u_`jahr' > r(r3) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 5 if  `var_i'u_`jahr' > r(r4) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 6 if  `var_i'u_`jahr' > r(r5) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 7 if  `var_i'u_`jahr' > r(r6) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 8 if  `var_i'u_`jahr' > r(r7) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 9 if  `var_i'u_`jahr' > r(r8) & miss_flag_`round'_`jahr' != .;
replace mobility_`jahr' = 10 if `var_i'u_`jahr' > r(r9) & miss_flag_`round'_`jahr' != .;
bysort  mobility_`jahr':    sum `var_i'u_`jahr' if miss_flag_`round'_`jahr' != .;
};

foreach jahr in "02" "07" "12" {;
gen obs_mobility_`jahr' = .;
replace obs_mobility_`jahr' = 1 if miss_flag_`round'_`jahr' != .;
_pctile obs_`var_i'a_`jahr' if miss_flag_`round'_`jahr' != ., p(10, 20, 30, 40, 50, 60, 70, 80, 90);
replace obs_mobility_`jahr' = 2 if  obs_`var_i'a_`jahr' > r(r1) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 3 if  obs_`var_i'a_`jahr' > r(r2) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 4 if  obs_`var_i'a_`jahr' > r(r3) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 5 if  obs_`var_i'a_`jahr' > r(r4) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 6 if  obs_`var_i'a_`jahr' > r(r5) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 7 if  obs_`var_i'a_`jahr' > r(r6) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 8 if  obs_`var_i'a_`jahr' > r(r7) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 9 if  obs_`var_i'a_`jahr' > r(r8) & miss_flag_`round'_`jahr' != .;
replace obs_mobility_`jahr' = 10 if obs_`var_i'a_`jahr' > r(r9) & miss_flag_`round'_`jahr' != .;
bysort  obs_mobility_`jahr':    sum obs_`var_i'a_`jahr' if miss_flag_`round'_`jahr' != .;
};

tab obs_mobility_02 obs_mobility_07, matcell(om0207);
tab obs_mobility_02 obs_mobility_12, matcell(om0212);
tab obs_mobility_07 obs_mobility_12, matcell(om0712);
tab mobility_02 mobility_07, matcell(m0207);
tab mobility_02 mobility_12, matcell(m0212);
tab mobility_07 mobility_12, matcell(m0712);

svmat 	m0207;
svmat 	om0207;
forvalues column = 1/10 {;
gen t0207`column' = (m0207`column' - om0207`column')^2;
replace t0207`column' = t0207`column' / om0207`column' if om0207`column' != 0;
};

svmat 	m0212;
svmat 	om0212;
forvalues column = 1/10 {;
gen t0212`column' = (m0212`column' - om0212`column')^2;
replace t0212`column' = t0212`column' / om0212`column' if om0212`column' != 0;
};

svmat 	m0712;
svmat 	om0712;
forvalues column = 1/10 {;
gen t0712`column' = (m0712`column' - om0712`column')^2;
replace t0712`column' = t0712`column' / om0712`column' if om0712`column' != 0;
};

local local0207 = 0;
forvalues column = 1/10 {;
total t0207`column';
mat b = e(b);
local local0207  = `local0207 ' + b[1,1];
di `local0207';
};

local local0212 = 0;
forvalues column = 1/10 {;
total t0212`column';
mat b = e(b);
local local0212  = `local0212 ' + b[1,1];
di `local0212';
};

local local0712 = 0;
forvalues column = 1/10 {;
total t0712`column';
mat b = e(b);
local local0712  = `local0712 ' + b[1,1];
di `local0712';
};

matrix results_`round'_`year'[`i',17] = (`local0207');
matrix results_`round'_`year'[`i',18] = (`local0212');
matrix results_`round'_`year'[`i',19] = (`local0712');

};

};
};
};


foreach round in 1 2 4 {;
foreach year in "02" "07" "12" {;
svmat results_`round'_`year';
};};

keep res*;
save $folder/`datafile'_results_all.dta, replace;

};
