
/* First: set folder defining results AND missingness mechanism */;

set more off

use "xxx\$METHOD\data1000_heck_imp_results.dta", clear
append using "xxx\$METHOD\data1000_ls_imp_results.dta"
append using "xxx\$METHOD\data1000_ls_age_imp_results.dta"
append using "xxx\$METHOD\data1000_ice_imp_results.dta"
append using "xxx\$METHOD\data1000_icels_imp_results.dta"
append using "xxx\$METHOD\data1000_icels_age_imp_results.dta"

keep if results_1_029 != .
set obs 6001

gen method = 1
replace method = 2 if _n >= 1001 & _n <= 2000
replace method = 3 if _n >= 2001 & _n <= 3000
replace method = 4 if _n >= 3001 & _n <= 4000
replace method = 5 if _n >= 4001 & _n <= 5000
replace method = 6 if _n >= 5001 & _n <= 6000


/* This part: calculates standard error bias (simultaneously for all methods)*/;


foreach num in 1 2 4 {
foreach year in "02" "07" "12" {

gen bias1_sd_`num'_`year' = (results_`num'_`year'4 - results_`num'_`year'2)/results_`num'_`year'2

mean bias1_sd_`num'_`year' , over(method)

}
}



/* This part: calculates main results weighted by mahascore (simultaneously for all methods, separately for years and assets)*/;

foreach num in 1 2 4 {
foreach year in "02" "07" "12" {

keep results_`num'_`year'9 results_`num'_`year'10 results_`num'_`year'11 results_`num'_`year'12 results_`num'_`year'13 results_`num'_`year'27

foreach var in results_`num'_`year'9 results_`num'_`year'10 results_`num'_`year'11 results_`num'_`year'12 results_`num'_`year'13 results_`num'_`year'27 {
replace `var' = 0 if _n==6001
}

mahascore results_`num'_`year'9 results_`num'_`year'10 results_`num'_`year'11 results_`num'_`year'12 results_`num'_`year'13 results_`num'_`year'27, gen(out_`num'_`year') refobs(6001) unsquared compute_invcovarmat

/* overall results */;
mean out_`num'_`year', over(method)

/* specific results for eval. criteria */;
mean results_`num'_`year'27 results_`num'_`year'10 results_`num'_`year'13 results_`num'_`year'11 results_`num'_`year'12 results_`num'_`year'9, over(method)

}
}


/* This part: Generate figures 1, A1 and A2; boxplots of distribution of results */;

rename out_1_02 out102
rename out_1_07 out107
rename out_1_12 out112
rename out_2_02 out202
rename out_2_07 out207
rename out_2_12 out212
rename out_4_02 out402
rename out_4_07 out407
rename out_4_12 out412
 

keep out*
gen fyi = _n
reshape long out , i(fyi) j(year)

gen method = 1
replace method = 2 if fyi >= 1001 & fyi <= 2000
replace method = 3 if fyi >= 2001 & fyi <= 3000
replace method = 4 if fyi >= 3001 & fyi <= 4000
replace method = 5 if fyi >= 4001 & fyi <= 5000
replace method = 6 if fyi >= 5001 & fyi <= 6000

graph box out if fyi!=60001 & out < 13 , over(method) scheme(s1mono)

mean out, over(method)

exit









