#delimit;
clear;
set more off;
version 9;
set seed 0815;

/* Folder with preliminary results from MICE / REG imputation OR any data that is to be imputed :*/;
global folderx  "xxx\wealth_sim_16\meta2012_NMAR1\temp\";

global 	TEMP_FILE1	$folderx/dataxx_ls.dta;
global 	TEMP_FILE_02	$folderx/dataxx_ls_a.dta;
global 	TEMP_FILE_07	$folderx/dataxx_ls_b.dta;
global 	TEMP_FILE_12	$folderx/dataxx_ls_c.dta;

local xyz = 1;
forvalues num = 1/1000 {;

global 	IN_DATA_1 	$folderx/data`num'_heck_imp.dta;	/* In-data: Not imputed, MICE or REG imputed */;
global 	OUT_DATA	$folderx/data`num'_ls_imp.dta; 		/* Outdata: LS imputed */;

quietly {;
use 	$IN_DATA_1, clear;


*****************************************************************************************;
*        Little and Su - Imputation													  	*;
*****************************************************************************************;


/********* imputation variables :  ********************************************/;
local i2 = "p0100a_"; /* Home market value */
local i1 = "f0100a_"; /* Financial assets */
local i4 = "c0100a_"; /* Consumer credits */

/********* filter variables:       ********************************************/;
local j2 = "p10000_"; /* Home market value */
local j1 = "f10000_"; /* Financial assets */
local j4 = "c10000_"; /* Consumer credits */

/********* flag variables :  **************************************************/;
local k2 = "p02000_"; /* Home market value */
local k1 = "f02000_"; /* Financial assets */
local k4 = "c02000_"; /* Consumer credits */



/* Fr spter: generiere zuerst Variablen, welche ber den Imputationsstatus Auskunft geben, hnlich
   miss_flag_var_year im Simulationsdatensatz. Dann werden die restlichen Filter und Flags berflssig. */;


/* Nur Wohneigentum und Geldanlagen */;

foreach round in 1 2 4 {;  /* Variablenschleife ffnet */;

local var_i `i`round'';   	/* Imputationsvariable */;
local var_j `j`round'';		/* Inzidenzfilter */;
local var_k `k`round'';		/* Imputationsvariable */;


foreach year in 02 07 12{;

gen `var_i'`year'_imp_ls_1 = .a; /* no imputation */;
replace `var_i'`year'_imp_ls_1 = .b if miss_flag_`round'_`year' == 1; /* b. to be replaced */; 
replace `var_i'`year'_imp_ls_1 = .c if miss_flag_`round'_`year' == .; /* c. not in simulation data */;
};


*** column effects ************************************************************;
local cj_total = 0;
foreach year in 02 07 12 {;
gen cj`year'=.;
sum `var_i'`year' if miss_flag_`round'_`year'==0;  
replace cj`year'= (3 * r(mean)) /* if svyyear_`year' == 1 */;
local cj_total = `cj_total' + r(mean);
};
foreach year in 02 07 12 {;
replace cj`year' = cj`year' / `cj_total';
};


*** row effects ***************************************************************;
*ricount: number of recorded periods
*j Jahr  J = 1,2,...,k
*row-effect= ri = ricount^(-1) * summe_(j=1)^(k)`var'/cj*;

foreach year in 02 07 12 {;
gen ri`year'=`var_i'`year'/cj`year' if miss_flag_`round'_`year' == 0;
};

gen ricount = 0; 
foreach year in 02 07 12 {;
replace ricount = ricount + 1 if ri`year'>0 & ri`year'<.;
};
replace ricount = 1/ricount;

gen riall = 0;
foreach year in 02 07 12 {;
replace riall = riall + ri`year' if ri`year'<. & ri`year'>0;
};

gen ri = ricount * riall; 


*** residual effect **************************************************************;


foreach year in 02 07 12 {;
gen resid_l`year' = 0;
replace resid_l`year' = `var_i'`year' / (ri * cj`year');
};

foreach year in 02 07 12 {;
replace resid_l`year' = . if resid_l`year' == 0 | miss_flag_`round'_`year' == 1;
sum resid_l`year';
};

*** Imputation*******************************************************************;


save $TEMP_FILE1, replace;

foreach year in 02 07 12 {;

use $TEMP_FILE1, clear;


keep persnr ri `var_i'`year'_imp_ls_1 cj`year' resid_l`year';
sort ri;
drop if (resid_l`year' == . | resid_l`year' == 1) & `var_i'`year'_imp_ls_1 != .b;

forvalues impl = 2/5 {;
gen `var_i'`year'_imp_ls_`impl' = `var_i'`year'_imp_ls_1;
}; 

tab `var_i'`year'_imp_ls_1, mis;
drop if resid_l`year' == resid_l`year'[_n-1] & resid_l`year' < .;
drop if ri == .;
tab `var_i'`year'_imp_ls_1, mis;
gen flag = 1 if `var_i'`year'_imp_ls_1 == .b;


forvalues n=1/200 {;
replace `var_i'`year'_imp_ls_5=ri*cj`year'*resid_l`year'[_n+`n'] if resid_l`year'[_n+`n']<. & resid_l`year'[_n+`n']>0
& `var_i'`year'_imp_ls_5==.b & `var_i'`year'_imp_ls_4!=.b;
replace `var_i'`year'_imp_ls_5=ri*cj`year'*resid_l`year'[_n-`n'] if resid_l`year'[_n-`n']<. & resid_l`year'[_n-`n']>0
& `var_i'`year'_imp_ls_5==.b & `var_i'`year'_imp_ls_4!=.b;
replace `var_i'`year'_imp_ls_4=ri*cj`year'*resid_l`year'[_n+`n'] if resid_l`year'[_n+`n']<. & resid_l`year'[_n+`n']>0
& `var_i'`year'_imp_ls_4==.b & `var_i'`year'_imp_ls_3!=.b;
replace `var_i'`year'_imp_ls_4=ri*cj`year'*resid_l`year'[_n-`n'] if resid_l`year'[_n-`n']<. & resid_l`year'[_n-`n']>0
& `var_i'`year'_imp_ls_4==.b & `var_i'`year'_imp_ls_3!=.b;
replace `var_i'`year'_imp_ls_3=ri*cj`year'*resid_l`year'[_n+`n'] if resid_l`year'[_n+`n']<. & resid_l`year'[_n+`n']>0
& `var_i'`year'_imp_ls_3==.b & `var_i'`year'_imp_ls_2!=.b;
replace `var_i'`year'_imp_ls_3=ri*cj`year'*resid_l`year'[_n-`n'] if resid_l`year'[_n-`n']<. & resid_l`year'[_n-`n']>0
& `var_i'`year'_imp_ls_3==.b & `var_i'`year'_imp_ls_2!=.b;
replace `var_i'`year'_imp_ls_2=ri*cj`year'*resid_l`year'[_n+`n'] if resid_l`year'[_n+`n']<. & resid_l`year'[_n+`n']>0
& `var_i'`year'_imp_ls_2==.b & `var_i'`year'_imp_ls_1!=.b;
replace `var_i'`year'_imp_ls_2=ri*cj`year'*resid_l`year'[_n-`n'] if resid_l`year'[_n-`n']<. & resid_l`year'[_n-`n']>0
& `var_i'`year'_imp_ls_2==.b & `var_i'`year'_imp_ls_1!=.b;
replace `var_i'`year'_imp_ls_1=ri*cj`year'*resid_l`year'[_n+`n'] if resid_l`year'[_n+`n']<. & resid_l`year'[_n+`n']>0
& `var_i'`year'_imp_ls_1==.b;
replace `var_i'`year'_imp_ls_1=ri*cj`year'*resid_l`year'[_n-`n'] if resid_l`year'[_n-`n']<. & resid_l`year'[_n-`n']>0
& `var_i'`year'_imp_ls_1==.b;
}; 
keep if flag == 1;
keep persnr `var_i'`year'_imp_ls_*;
corr `var_i'`year'_imp_ls_*;


/* Random assignment */;
forvalues num = 1/5 {;
gen order_`num' = uniform();
};

gen stop = 0;
forvalues num = 1/5 {;
replace stop = 0;
replace order_1 = `num' if (order_1 < order_2) & (order_1 < order_3) & (order_1 < order_4) & (order_1 < order_5) & (stop != 1);
replace stop = 1 if (order_1 == `num');

replace order_2 = `num' if (order_2 < order_1) & (order_2 < order_3) & (order_2 < order_4) & (order_2 < order_5) & (stop != 1);
replace stop = 1 if (order_2 == `num');

replace order_3 = `num' if (order_3 < order_1) & (order_3 < order_2) & (order_3 < order_4) & (order_3 < order_5) & (stop != 1);
replace stop = 1  if (order_3 == `num');

replace order_4 = `num' if (order_4 < order_1) & (order_4 < order_2) & (order_4 < order_3) & (order_4 < order_5) & (stop != 1);
replace stop = 1 if (order_4  == `num');

replace order_5 = `num' if (order_5 < order_1) & (order_5 < order_2) & (order_5 < order_3) & (order_5 < order_4) & (stop != 1);
};
drop stop;

forvalues num = 1/5 {;
gen `var_i'`year'_imp_ls_x`num' = .;
};

forvalues num = 1/5 {;
forvalues round = 1/5{;
replace `var_i'`year'_imp_ls_x`num' = `var_i'`year'_imp_ls_`round' if order_`round' == `num';
};
};

corr `var_i'`year'_imp_ls_x*;


keep persnr `var_i'`year'_imp_ls_x*;
sort persnr;

local saveplace "TEMP_FILE_`year'";
save $`saveplace', replace;
};

use $TEMP_FILE1, clear;

foreach year in 02 07 12 {;
save $TEMP_FILE1, replace;
sort persnr;
local saveplace "TEMP_FILE_`year'";
merge persnr using $`saveplace';
drop _merge;
sort persnr;
};

drop cj* ri* resid_l*;
};


/********* imputation variables :  ********************************************/;
local i2 = "p0100"; /* Home market value */
local i1 = "f0100"; /* Financial assets */
local i4 = "c0100"; /* Consumer credits */;

/*********************************************************/;
/* Fallback imputation 									 */;
/*********************************************************/;


foreach round in 1 2 4 {;

local var_i `i`round'';   	/* imputation variable */;



foreach year in 02 07 12 {;
local impl = 1;
foreach let in a b c d e {;
replace `var_i'`let'_`year' = `var_i'a_`year'_imp_ls_x`impl' if `var_i'a_`year'_imp_ls_x`impl' != .;
local impl = `impl' + 1;
};
};
};

drop *ls_*;



 save  $OUT_DATA, replace; 
 erase $TEMP_FILE1;
 erase $TEMP_FILE_02;
 erase $TEMP_FILE_07;
 erase $TEMP_FILE_12;

 };
 
 di `xyz';
 local xyz = `xyz' + 1;
 
 };
 

