#delimit;
clear;
set more off;
version 9;
set seed 0815;

global folder3	"xxx\wealth_sim_16\wealth\2002_new\"; 	/* CS WEALTH DATA 2002*/;
global folder8  "xxx\wealth_sim_16\wealth\2012\";		/* CS WEALTH DATA 2012*/;
global folder4  "xxx\wealth_sim_16\wealth\2007\";		/* CS WEALTH DATA 2007*/;
global folderx  "xxx\wealth_sim_16\meta2012_DNR1\temp\";	/* FOLDER FOR SIMULATION DATA*/;



*****************************************************************************************;
*                                                                             			*;
*        Merging of the different data sets to get a final data set for imputation  	*;
*                                                                             			*;
*****************************************************************************************;

/* Input data: cross-sectional SOEP wealth data 2002, 2007 and 2012 */;

use     $folder3/pwealth_2002.dta, clear;
foreach var in a02_wr a03_wr b08_wr b11_wr c02_wr d02_wr e03_wr f02_wr g02_wr {;
rename `var' `var'_02;
};
drop 	sp85*;
sort	persnr;
save 	$folderx/pwealth_2002.dta, replace;

use     $folder4/pwealth_2007.dta, clear;
foreach var in a02_wr a06_wr b09_wr b15_wr c02_wr d02_wr e02_wr f03_wr g02_wr h02_wr {;
rename `var' `var'_07;
};
drop 	xp126*;
sort	persnr;
save 	$folderx/pwealth_2007.dta, replace;

use     $folder8/pwealth_2012.dta, clear;
foreach var in a02_wr a06_wr b09_wr b15_wr c02_wr d02_wr e02_wr f03_wr g02_wr h02_wr {;
rename `var' `var'_12;
};
drop 	bcp90*;
sort	persnr;
save 	$folderx/pwealth_2012.dta, replace;

merge persnr using $folderx/pwealth_2002.dta;
drop _merge;
sort persnr;
merge persnr using $folderx/pwealth_2007.dta;
drop _merge;
sort persnr;
merge persnr using $folderx/pwealth_2012.dta;
drop _merge;
sort persnr;

erase 	$folderx/pwealth_2002.dta;
erase 	$folderx/pwealth_2007.dta;
erase 	$folderx/pwealth_2012.dta;

save 	$folderx/pwealth_all_imp.dta, replace;



local xyz = 1;

forvalues number = 1/1000 {;

global IMP_DATA $folderx/imp_data`number'.dta;

quietly {;

use 	$folderx/pwealth_all_imp.dta, clear;

keep 
/* wealth imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100*
e10000* i10000* b10000* t10000* h10000* l10000*

/* response indicators other wealth vars*/ 
e00200* e02000* e0010* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*;


/* Other wealth components ... filters and values ... insert */;
sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* e00200* e0010* e1000* c1000* c0100*  l02000* h02000* b02000* t02000* c02000* i02000*;

sort persnr;
save $IMP_DATA, replace;


*************************************************************************************************;
*        simulation data sets DNR1:							  							  		*;
*							1. Take all complete cases (set PUNR not eligible)					*;
*							2. differential NR at the bottom (+ error term)!					*;
*************************************************************************************************;


use 	 $folder3/reg_a_02.dta, clear; 
keep  persnr snetto spop psample;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;
merge persnr using $IMP_DATA;
sort persnr;



* 	2002 ********************************************************************;
** 	Financial assets ***********************************************************;

gen miss_flag = f02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p e b t c i l h {;
gen xmiss_flag_102_`comp' = `comp'02000_02;
recode xmiss_flag_102_`comp' (. 1 0 = 0) (2 = 1);
};

gen f_person_flag_02 = 0;
replace f_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_102_p == 0) & (xmiss_flag_102_c == 0); 

gen f0100f_02 = f0100a_02 if f0100a_02 > 0;
sum f0100f_02 if f_person_flag_02 == 1, de;
replace f0100f_02 = r(p95) if f0100f_02 > r(p95) & f0100f_02 < .;
replace f0100f_02 = r(p1) if  f0100f_02 < r(p1) & f0100f_02 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(f0100f_02+6000)) if f_person_flag_02 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_1_02 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_1_02 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag _merge miss_ind miss_ind2;



* 	2002 ********************************************************************;
** 	home market value ***********************************************************;
gen miss_flag = p02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c i l h {;
gen xmiss_flag_202_`comp' = `comp'02000_02;
recode xmiss_flag_202_`comp' (. 1 0 = 0) (2 = 1);
};
gen 	p_person_flag_02 = 0;
replace p_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_202_f == 0) & (xmiss_flag_202_c == 0); 

gen p0100f_02 = p0100a_02 if p0100a_02 > 0;
sum p0100f_02 if p_person_flag_02 == 1, de;
replace p0100f_02 = r(p95) if p0100f_02 > r(p95) & p0100f_02 < .;
replace p0100f_02 = r(p1) if  p0100f_02 < r(p1) & p0100f_02 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(p0100f_02+120000)) if p_person_flag_02 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_2_02 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_2_02 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2;



* 	2002 ********************************************************************;
** 	consumer credits ***********************************************************;

gen miss_flag = c02000_02;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t i {;
gen xmiss_flag_402_`comp' = `comp'02000_02;
recode xmiss_flag_402_`comp' (. 1 0 = 0) (2 = 1);
};
gen 	c_person_flag_02 = 0;
replace c_person_flag_02 = 1 if (snetto < 20) & (miss_flag == 0) & (xmiss_flag_402_f == 0) & (xmiss_flag_402_p == 0);  

gen c0100f_02 = c0100a_02 if c0100a_02 > 0;
sum c0100f_02 if c_person_flag_02 == 1, de;
replace c0100f_02 = r(p95) if c0100f_02 > r(p95) & c0100f_02 < .;
replace c0100f_02 = r(p1) if  c0100f_02 < r(p1) & c0100f_02 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(c0100f_02+8000)) if c_person_flag_02 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_4_02 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_4_02 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2;



keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* indicators of response other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*


/* NR simulation vars*/ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;
sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;





* 	2007 ********************************************************************;
** 	Financial assets ***********************************************************;
use 	 $folder4/reg_a_07.dta, clear; 
keep  persnr xnetto;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;
merge persnr using $IMP_DATA;
sort persnr;


gen miss_flag = f02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;

foreach comp in p e b t c l h {;
gen xmiss_flag_107_`comp' = `comp'02000_07;
recode xmiss_flag_107_`comp' (. 1 0 = 0) (2 = 1);
};

gen 	f_person_flag_07 = 0;
replace f_person_flag_07 = 1 if (xnetto < 20) & (miss_flag == 0) & (xmiss_flag_107_p == 0) & (xmiss_flag_107_c == 0);  

gen f0100f_07 = f0100a_07 if f0100a_07 > 0;
sum f0100f_07 if f_person_flag_07 == 1, de;
replace f0100f_07 = r(p95) if f0100f_07 > r(p95) & f0100f_07 < .;
replace f0100f_07 = r(p1) if  f0100f_07 < r(p1) & f0100f_07 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(f0100f_07+6000)) if f_person_flag_07 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_1_07 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_1_07 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag _merge miss_ind miss_ind2 f0100f_07;



* 	2007 ********************************************************************;
** 	Home market value ***********************************************************;
gen miss_flag = p02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c l h {;
gen xmiss_flag_207_`comp' = `comp'02000_07;
recode xmiss_flag_207_`comp' (. 1 0 = 0) (2 = 1);
};
gen 	p_person_flag_07 = 0;
replace p_person_flag_07 = 1 if (xnetto < 20) &  (miss_flag == 0) & (xmiss_flag_207_f == 0) & (xmiss_flag_207_c == 0);  

gen p0100f_07 = p0100a_07 if p0100a_07 > 0;
sum p0100f_07 if p_person_flag_07 == 1, de;
replace p0100f_07 = r(p95) if p0100f_07 > r(p95) & p0100f_07 < .;
replace p0100f_07 = r(p1)  if p0100f_07 < r(p1) &  p0100f_07 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(p0100f_07+120000)) if p_person_flag_07 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_2_07 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_2_07 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2 p0100f_07;




* 	2007 ********************************************************************;
** 	consumer credits ***********************************************************;
gen miss_flag = c02000_07;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t {;
gen xmiss_flag_407_`comp' = `comp'02000_07;
recode xmiss_flag_407_`comp' (. 1 0 = 0) (2 = 1);
};
gen 	c_person_flag_07 = 0;
replace c_person_flag_07 = 1 if (xnetto < 20) &  (miss_flag == 0)  & (xmiss_flag_407_f == 0) & (xmiss_flag_407_p == 0); 

gen c0100f_07 = c0100a_07 if c0100a_07 > 0;
sum c0100f_07 if c_person_flag_07 == 1, de;
replace c0100f_07 = r(p95) if c0100f_07 > r(p95) & c0100f_07 < .;
replace c0100f_07 = r(p1) if  c0100f_07 < r(p1) & c0100f_07 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(c0100f_07+8000)) if c_person_flag_07 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_4_07 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_4_07 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2 c0100f_07;



keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* indicators of response other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation vars*/ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;




* 2012 ********************************************************************;
** Financial assets ***********************************************************;


use 	 $folder8/reg_a_12.dta, clear; 
keep  persnr bcnetto;
sort persnr;
save 	 $folderx/reg_temp.dta, replace;
merge persnr using $IMP_DATA;
sort persnr;
drop _merge;

gen miss_flag = f02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p e b t c l h {;
gen xmiss_flag_112_`comp' = `comp'02000_12;
recode xmiss_flag_112_`comp' (. 1 0 = 0) (2 = 1);
};
gen f_person_flag_12 = 0;
replace f_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_112_p == 0) & (xmiss_flag_112_c == 0);  

gen f0100f_12 = f0100a_12 if f0100a_12 > 0;
sum f0100f_12 if f_person_flag_12 == 1, de;
replace f0100f_12 = r(p95) if f0100f_12 > r(p95) & f0100f_12 < .;
replace f0100f_12 = r(p1) if  f0100f_12 < r(p1) & f0100f_12 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(f0100f_12+6000)) if f_person_flag_12 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_1_12 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_1_12 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2 f0100f_12;



* 2012 ********************************************************************;
** Home market value ***********************************************************;

gen miss_flag = p02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in f e b t c l h {;
gen xmiss_flag_212_`comp' = `comp'02000_12;
recode xmiss_flag_212_`comp' (. 1 0 = 0) (2 = 1);
};
gen p_person_flag_12 = 0;
replace p_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_212_f == 0)  & (xmiss_flag_212_c == 0);   

gen p0100f_12 = p0100a_12 if p0100a_12 > 0;
sum p0100f_12 if p_person_flag_12 == 1, de;
replace p0100f_12 = r(p95) if p0100f_12 > r(p95) & p0100f_12 < .;
replace p0100f_12 = r(p1) if  p0100f_12 < r(p1) & p0100f_12 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(p0100f_12+120000)) if p_person_flag_12 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_2_12 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_2_12 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2 p0100f_12;



* 2012 ********************************************************************;
** Consumer credits ***********************************************************;

gen miss_flag = c02000_12;
recode miss_flag (1 0 = 0) (2 = 1);
tab miss_flag;
foreach comp in p f e b t {;
gen xmiss_flag_412_`comp' = `comp'02000_12;
recode xmiss_flag_412_`comp' (. 1 0 = 0) (2 = 1);
};
gen 	c_person_flag_12 = 0;
replace c_person_flag_12 = 1 if (bcnetto < 20) & (miss_flag == 0) & (xmiss_flag_412_f == 0)  & (xmiss_flag_412_p == 0);   

gen c0100f_12 = c0100a_12 if c0100a_12 > 0;
sum c0100f_12 if c_person_flag_12 == 1, de;
replace c0100f_12 = r(p95) if c0100f_12 > r(p95) & c0100f_12 < .;
replace c0100f_12 = r(p1) if c0100f_12 < r(p1) & c0100f_12 > 0;

/* Static prob of missingness decreasing with asset value */;
gen miss_ind = (1/(c0100f_12+8000)) if c_person_flag_12 == 1;
sum miss_ind, de;
local scale = 0.1 / r(mean);
di `scale';
replace miss_ind = miss_ind*`scale';
sum miss_ind, de;

/* Random component */;
gen miss_ind2 = uniform(); 
gen miss_flag_4_12 = 0 if miss_ind != 0 & miss_ind < .;
replace miss_flag_4_12 = 1 if miss_ind2 <= miss_ind & miss_ind < .;

drop miss_flag miss_ind miss_ind2 c0100f_12;


keep 
/* imputation vars */ 
persnr shhnr xhhnr bchhnr p0100* p0010* p00200* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e0100* e0010* i0100* b0100* t0100* h0100* l0100* e10000* i10000* b10000* t10000* h10000* l10000*

/* indicators of response other wealth vars */ 
e00200* e02000* e1000* l02000* h02000* b02000* t02000* c1000* c0100* c02000* i02000*

/* NR simulation vars*/ miss_flag* f_person_flag_* p_person_flag_* c_person_flag_* xmiss_flag_*;

sort persnr shhnr xhhnr bchhnr p0100* p0010* p2000* p10000* p02000* f0100* f20000* f10000* f02000* 
e02000* l0200* h02000* b02000* t02000* c02000* c1000* c0100* i02000*  miss_flag* f_person_flag_* p_person_flag_* xmiss_flag_* c_person_flag_*;

sort persnr;
save $IMP_DATA, replace;
};

di `xyz';
local xyz = `xyz' + 1;

};



