*******************************************************
** JJ Created 18 / 08 / 2014 **************************
** JJ updated 03 / 03 / 2016 **************************
*******************************************************

*********************************************************************
*--- This do-file performs estimates the different components of ---*
*--- the TSTSLS inconsistency --------------------------------------*
*********************************************************************

*-------------------------------*
* 1. Open the up the dataset ---*
*-------------------------------*
	*1A. Open the data
	cd "C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\"
	use DATA_WITH_IMPUTED_EARNINGS, clear												/*** Open up the combined dataset ***/

	*1B. Keep the main dataset only
	keep if DATASET == 0


*-------------------------------*
* 2. Set-up a postfile ---------*
*-------------------------------*
	*2A. Drop any postfile already open with this name
	capture postclose bias_decomp 													/*** Drop any post-file already with this name ***/

	*2B. Define contents of the new postfile
	postfile bias_decomp ///														/*** Create a new post-file to put the results into ***/												
		str10 MODEL ///																/*** Name of the TSTSLS regression model used ***/
		TRUE_BETA  TSTSLS_BETA INCONSISTENT_BETA ///								/*** Estimates of Beta ***/
		TRUE_RHO TSTSLS_RHO ///														/*** Estimates of Rho ***/	
		INCONSISTENT_RHO_PART_A INCONSISTENT_RHO_PART_B INCONSISTENT_RHO ///		/*** Inconsistency of Rho ***/	
		SD_FATHER_HAT VAR_FATHER_HAT ///											/*** Standard deviation / variance of IMPUTED father's earnings ***/
		SD_SONS ///																	/*** Standard deviation of son's earnings ***/
		SD_FATHER VAR_FATHER ///													/*** Standard deviation / variance of ACTUAL father's earnings ***/
		LAMBDA_1 LAMBDA_2 ///														/*** The estimate of the endogeniety ***/
		COV_ACTUAL_IMPUTED ///														/*** Covariance between ACTUAL and IMPUTED father's earnings ***/
		ETA ETA_SQU ///																/*** Estimate of ETA... ***/
		INCONSISTENT_BETA_ALT ///
			using ////
			"BIAS_DECOMPOSITION" ///
				, ///
				replace																	/*** Name of new dataset to be created ***/
	
*---------------------------------------------*
* 3. Get the components of the inconsistency--*
*---------------------------------------------*
*`i' = Refers to the TSTSLS model

forvalues i = 1(1)10{																/*** Looping over imputation models 1 to 10 ***/
	
	*A. OLS ESTIMATE OF BETA														/*** This is basically equation 1 ***/
	regress ///																		/*** OLS regression model ***/
		Log_Child_Earnings  ///														/*** Log sons earnings = dependent variable ***/											
		Log_Fa_Perm_Earn															/*** Use ACTUAL permanent father's earnings ***/

	capture gen TRUE_BETA = _b[Log_Fa_Perm_Earn]									/*** This is the TRUE estimate of beta obtained via OLS ***/	

	*B. TSTSLS ESTIMATE OF BETA														/*** This is basically equation 1 ***/
	regress ///																		/*** OLS regression model ***/
		Log_Child_Earnings  ///														/*** Log sons earnings = dependent variable ***/											
		TSTSLS_Predicted_M`i' 														/*** Use IMPUTED permanent father's earnings ***/

	capture gen TSTSLS_BETA = _b[TSTSLS_Predicted_M`i']								/*** This is the TSTSLS estimate of beta **/	
	capture gen INCONSISTENT_BETA = TSTSLS_BETA - TRUE_BETA							/*** Get the inconsistency of Beta (difference between OLS and TSTSLS estimate) ***/
		
	*C. Get standard deviation of IMPUTED father's earnings
	sum TSTSLS_Predicted_M`i' , d													/*** Summary statistics for the imputed variable ***/
	gen SD_FATHER_HAT_M`i' = r(sd)													/*** Standard deviation of IMPUTED father's earnings ***/
	gen VAR_FATHER_HAT_M`i' = r(Var)												/*** Variance of IMPUTED father's earnings ***/

	*D. Get standard deviation of actual son's earnings
	sum Log_Child_Earnings , d														/*** Summary statistics for sons earnings ***/
	capture gen SD_SONS = r(sd)														/*** Standard deviation of sons earnings ***/
	
	*E. Get standard deviation of ACTUAL father's earnings
	sum Log_Fa_Perm_Earn , d														/*** Summary statistics for the actual variable ***/
	capture gen SD_FATHER = r(sd)													/*** Standard deviation of ACTUAL father's earnings ***/
	capture gen VAR_FATHER = r(Var)													/*** Variance of ACTUAL father's earnings ***/
	
	*F. LAMDA_2 PARAMETER															/*** Endogeniety of the imputed father's earnings variable ***/
	regress ///																		/*** OLS regression model ***/
	Log_Child_Earnings  ///															/*** Log sons earnings = dependent variable ***/
		Log_Fa_Perm_Earn ///														/*** ACTUAL father's earnings. Will give Lambda 1 ***/
		TSTSLS_Predicted_M`i'														/*** IMPUTED father's earnings. Will give Lambda 2 ***/

	gen LAMBDA_1_M`i' = _b[Log_Fa_Perm_Earn]										/*** Create new variable. Equal to LAMBDA 1 ***/
	gen LAMBDA_2_M`i' = _b[TSTSLS_Predicted_M`i']									/*** Create new variable. Equal to LAMBDA 2 ***/
	
	*G. Get the covariance between imputed and actual father's earnings
	corr ///																		/*** Correlation / covariance Stata command ***/
		Log_Fa_Perm_Earn ///														/*** ACTUAL father's earnings ***/
		TSTSLS_Predicted_M`i' ///													/*** IMPUTED father's earnings ***/
		, ///
		cov																			/*** Give me the covariance rather than the correlation ***/

	gen COV_ACTUAL_IMPUTED_M`i' = r(cov_12)											/*** New variable = Covarience between imputed and actual ***/
		
	*H. Calculate ETA variable (see equation 9) ***/
	gen ETA_M`i' = ///
		( COV_ACTUAL_IMPUTED_M`i' / (SD_FATHER_HAT_M`i' * SD_FATHER) )
		
	gen ETA_SQU_M`i' = ETA_M`i'* ETA_M`i'											/*** Should equal R2 for most models ***/	
	
	*I. Get true value of Rho
	capture gen TRUE_RHO = TRUE_BETA * (SD_FATHER / SD_SONS)
	
	*J. Get TSTSLS Rho
	capture gen TSTSLS_RHO = TSTSLS_BETA * (SD_FATHER_HAT_M`i' / SD_SONS)

	*K. Inconsistency of Rho
	gen INCONSISTENT_RHO_PART_A = ///
		TRUE_BETA * ///																/* 'True' OLS estimate of intergenerational beta */
		( (SD_FATHER_HAT_M`i' / SD_SONS) - (SD_FATHER / SD_SONS) )					/* See equation 17 */

	gen INCONSISTENT_RHO_PART_B = ///												/* See equation 18 */
		LAMBDA_2_M`i' * ///
		(SD_FATHER_HAT_M`i' / SD_SONS) * ///	
		(1 - ETA_SQU_M`i')
	
	gen INCONSISTENT_RHO = TSTSLS_RHO - TRUE_RHO									/* Difference between true rho and TSTSLS rho */
	
	*L. INCONSISTENCY BETA ALT
	gen INCONSISTENT_BETA_ALT = LAMBDA_2_M`i' * ///
		SD_FATHER_HAT_M`i' * ///
		( (1 - ETA_SQU_M`i')  ///
			/ (ETA_M`i' * SD_FATHER))
	
	*M. Post results out to file
	post bias_decomp ///
		("M`i'") ///																/*** Name of the TSTSLS regression model used ***/
		(TRUE_BETA) (TSTSLS_BETA) (INCONSISTENT_BETA) ///							/*** Estimates of Beta ***/
		(TRUE_RHO) (TSTSLS_RHO)  ///												/*** Estimates of Rho ***/
		(INCONSISTENT_RHO_PART_A) (INCONSISTENT_RHO_PART_B) (INCONSISTENT_RHO) ///	/*** Inconsistency of Rho ***/
		(SD_FATHER_HAT_M`i') (VAR_FATHER_HAT_M`i') ///								/*** Standard deviation / variance of IMPUTED father's earnings ***/
		(SD_SONS) ///																/*** Standard deviation of son's earnings ***/
		(SD_FATHER) (VAR_FATHER) ///												/*** Standard deviation / variance of ACTUAL father's earnings ***/
		(LAMBDA_1_M`i') (LAMBDA_2_M`i') ///											/*** The estimate of the endogeniety ***/
		(COV_ACTUAL_IMPUTED_M`i') ///												/*** Covariance between ACTUAL and IMPUTED father's earnings ***/
		(ETA_M`i') (ETA_SQU_M`i') ///												/*** Estimate of ETA... ***/
		(INCONSISTENT_BETA_ALT)
	
	*N. Drop variables created within the loop
	drop ///																		/*** Drop the variables created within the loop ***/
		TRUE_* TSTSLS_B* TSTSLS_R* INCONSISTENT_* ///
		SD_* VAR_* ///
		LAMBDA_* ///
		COV_* ///
		ETA_*
}																					/*** CLOSE THE LOOP ***/
	
	*O. Close the post-file
	postclose bias_decomp 															/*** CLOSE THE POST-FILE ***/


*---------------------------------------------*
* 4. Export results to Excel -----------------*
*---------------------------------------------*
use BIAS_DECOMPOSITION , clear														/*** Open up the file where I have posted the results too ***/

export excel ///																	/*** Export the results to excel ***/
	using "C:\Users\john\OneDrive\Documents\TSTSLS\FINAL_MARCH_2016\Excel_Results_Files\BIAS_DECOMP" ///															/*** Name of the excel file ***/
	, ///																			/*** Options.... ***/
	sheet("BIAS") ///																/*** Name of the excel sheet ***/						
	firstrow(variables) ///															/*** Variable names in the first row ***/
	sheetreplace																	/*** Overwrite the sheet ***/

