*******************************************************
** JJ Created 29 / 08 / 2014 **************************
** JJ updated 03 / 03 / 2016 **************************
*******************************************************

********************************************************************************
*--- This do-file estimates  different components of the TSTSLS inconsistency--*
*--- when using X-SINGLE as first-stage dependent variable --------------------*
********************************************************************************

*--------------------------------------------------------------*
* 1. Open up the dataset --------------------------------------*
*--------------------------------------------------------------*
	*1A. Open the data
	cd "C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\"
	use ROBUSTNESS_DATA_WITH_IMPUTED_EARNINGS, clear								/*** Open up the combined dataset ***/

	*1B. Keep the main dataset only
	keep if DATASET == 0															/*** Keep only the main dataset ***/


*--------------------------------------------------------------*
* 2. Create a post-file to put results into -------------------*
*--------------------------------------------------------------*
	*2A. Drop any postfile already open with this name
	capture postclose bias_decomp 													/*** Drop any post-file already with this name ***/

	*2B. Define contents of the new postfile
	postfile bias_decomp ///														/*** Create a new post - fle ***/
		Model ///																	/* TSTSLS model number */
		BETA  BETA_TSTSLS ///														/* Beta estimates (OLS and TSTSLS ) */
		COV_X_Y ///																	/* COvariance between observed X and Y */
		VAR_X  SD_X ///																/* Variance / standard deviation of observed X */
		COV_Xhat_Y ///																/* Covariance between TSTSLS X and Y */
		VAR_Xhat  SD_Xhat ///														/* Variance / standard deviation of TSTSLS X */
		VAR_Y  SD_Y ///																/* Variance / standard deviation of Y */
		BETA_INCON  BETA_INCON_ALT  ///												/* Inconsistency of beta */
		RHO_INCON  RHO_INCON_ALT ///												/* Inconsistency of rho */
			using ///
			"ROBUSTNESS_BIAS_DECOMP_XSINGLE"  ///												/* Name of the new results file */
				, ///
				replace																/* Replace the file if it already exists */
	
	
forvalues i = 1(1)10 {																/*** Looping over the TSTSLS regression models ****/	
	
*--------------------------------------------------------------*
* 3. Get OLS results ------------------------------------------*
*--------------------------------------------------------------*
	*A. Run OLS model
	regress ///																		/*** OLS regression model ***/
		Log_Child_Earnings  ///														/*** Log sons earnings = dependent variable ***/											
		Log_Fa_Perm_Earn															/*** Use ACTUAL permanent father's earnings ***/
	
	*B. Create new variable 
	gen BETA = _b[Log_Fa_Perm_Earn]
		
		
*--------------------------------------------------------------*
* 4. Get TSTSLS results ---------------------------------------*
*--------------------------------------------------------------*		
	*A. Run TSTSLS model
	regress ///																		/*** OLS regression model ***/
		Log_Child_Earnings  ///														/*** Log sons earnings = dependent variable ***/											
		TSTSLS_Predicted_M`i'														/*** Use ACTUAL permanent father's earnings ***/

	*B. Create new variable 
	gen BETA_TSTSLS = _b[TSTSLS_Predicted_M`i']		
		
*--------------------------------------------------------------*
* 5. COV (X-TRUE, Y-TRUE)--------------------------------------*
*--------------------------------------------------------------*		
	*A. Covariance between father's actual and sons actual earnings
	corr ///																		/*** Correlation / covariance Stata command ***/
		Log_Child_Earnings  ///														/*** Log sons earnings = dependent variable ***/											
		Log_Fa_Perm_Earn ///														/*** Use ACTUAL permanent father's earnings ***/
		, ///
		cov																			/*** Give me the covariance rather than the correlation ***/
	
	*B. Create new variable 	
		gen COV_X_Y = r(cov_12)
	
*--------------------------------------------------------------*
* 5. VAR (X-TRUE) ---------------------------------------------*
*--------------------------------------------------------------*	
	*A. Summary stats of father's actual earnings
	sum Log_Fa_Perm_Earn, d
	
	*B. Create new variables 		
	gen VAR_X = r(Var)
	gen SD_X = r(sd)

	
*--------------------------------------------------------------*
* 6. COV (X-HAT, Y-TRUE)--------------------------------------*
*--------------------------------------------------------------*		
	*A. Covariance between father's TSTSLS predicted and sons actual earnings
	corr ///																		/*** Correlation / covariance Stata command ***/
		TSTSLS_Predicted_M`i' ///
		Log_Child_Earnings ///														/*** ACTUAL father's earnings ***/
		, ///
		cov																			/*** Give me the covariance rather than the correlation ***/
	
	*B. Create new variable 			
	gen COV_Xhat_Y = r(cov_12)
	
	
*--------------------------------------------------------------*
* 7. VAR (X-HAT) ----------------------------------------------*
*--------------------------------------------------------------*	
	*A. Summary stats of father's actual earnings
	sum TSTSLS_Predicted_M`i', d
	
	*B. Create new variable 		
	gen VAR_Xhat = r(Var)	
	gen SD_Xhat = r(sd)	
	
	
*--------------------------------------------------------------*
* 8. SD (Y) ---------------------------------------------------*
*--------------------------------------------------------------*	
	*A. Summary stats of father's actual earnings
	sum Log_Child_Earnings, d
	
	*B. Create new variable 		
	gen VAR_Y = r(Var)	
	gen SD_Y = r(sd)		

	
*--------------------------------------------------------------*
* 9. Create estimates of the inconsistency --------------------*
*--------------------------------------------------------------*	
	*A. Create main estimate of inconsistency of Beta	
	gen BETA_INCON = (BETA_TSTSLS - BETA)

	*B. Create alternative estimates using the component	
	gen BETA_INCON_ALT = (COV_Xhat_Y / VAR_Xhat) - (COV_X_Y / VAR_X)				/* See equation 23 */
	
	*C. Create main estimate of inconsistency of rho
	gen RHO_INCON = (BETA_TSTSLS*(SD_Xhat/SD_Y)) - (BETA*(SD_X / SD_Y))

	*D. Create alternative estimate of inconsistency of rho
	*NOTE: DIFFERENCE BETWEEN EQUATION 25 and 24.....
	gen RHO_INCON_ALT = ((COV_Xhat_Y / VAR_Xhat)*(SD_Xhat/SD_Y)) - ((COV_X_Y / VAR_X)*(SD_X / SD_Y))
	
	
*--------------------------------------------------------------*
* 10. Post the results out to a new file -----------------------*
*--------------------------------------------------------------*	
	post bias_decomp ///
		(`i') ///																	/* TSTSLS model number */
		(BETA)  (BETA_TSTSLS) ///													/* Beta estimates (OLS and TSTSLS ) */
		(COV_X_Y) ///																/* COvariance between observed X and Y */
		(VAR_X)  (SD_X) ///															/* Variance / standard deviation of observed X */
		(COV_Xhat_Y) ///															/* Covariance between TSTSLS X and Y */
		(VAR_Xhat)  (SD_Xhat) ///													/* Variance / standard deviation of TSTSLS X */
		(VAR_Y)  (SD_Y)	///															/* Variance / standard deviation of Y */
		(BETA_INCON)  (BETA_INCON_ALT)  ///											/* Inconsistency of beta */
		(RHO_INCON)  (RHO_INCON_ALT)												/* Inconsistency of rho */	

*--------------------------------------------------------------*
* 11. Drop any variables created and close the loop -----------*
*--------------------------------------------------------------*	
	*A. Drop variables created
	drop BETA* RHO* COV* VAR* SD*
	
	*B. Close the loop
	}																				/*** LOOP CLOSED ***/

*--------------------------------------------------------------*
* 12. Export the results to excel -----------------------------*
*--------------------------------------------------------------*		
	*12A. Close the postfile
	postclose bias_decomp

	*12B. Open up the results file
	use "ROBUSTNESS_BIAS_DECOMP_XSINGLE" , clear	
	
	*12C. Export the results to Excel
	export excel ///																/*** Export the results to excel ***/
		using "C:\Users\john\OneDrive\Documents\TSTSLS\FINAL_MARCH_2016\Excel_Results_Files\ROBUSTNESS\SPLIT_AUXILIARY_DATASET\BIAS_DECOMP_XSINGLE" ///												/*** Name of the excel file ***/
			, ///																	/*** Options.... ***/
			sheet("BIAS") ///														/*** Name of the excel sheet ***/						
			firstrow(variables) ///													/*** Variable names in the first row ***/
			sheetreplace															/*** Overwrite the sheet ***/	

			
			
/*			
	*12D. Var(X_hat) = Var(X) + Var(error)	
	sum TSTSLS_Predicted_M2 , d

	gen B = r(Var)
	
	
*C. (Cov X; Y)
	corr ///																		/*** Correlation / covariance Stata command ***/
		Log_Fa_Perm_Earn ///
		Log_Child_Earnings ///														/*** ACTUAL father's earnings ***/
		, ///
		cov		
	
	gen C = r(cov_12)
	
	
*D. Var(X)
	sum Log_Fa_Perm_Earn , d

	gen D = r(Var)

display (A/B)	
display (C/D)	
display (A/B) - (C/D)	
*/	
	
	