*******************************************************
** JJ Created 14 / 05 / 2014 **************************
** JJ updated 03 / 03 / 2016 **************************
*******************************************************

*--- This do-file provides alternative estimates adjusting child's earnings for 
*--- life-cycle bias

cd "C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\"
use DATA_WITH_IMPUTED_EARNINGS, clear												/*** Open up the combined dataset ***/


*****************************************************************
**** STEP 1 - CREATE NEW VARIABLE *******************************
*****************************************************************
	*1A. Log child's earnings (averaged by up to 5 years)
	gen Log_Child_Labor_Earnings_5year ///
		= ///
		log(Child_Labor_Earnings_5year)

	*1B. Keep only if they have at least 3 earnings measures available
	keep if Child_Labor_Earnings_5year_N > 2
		
*****************************************************************
**** STEP 2 - CREATE PROGRAM TO RUN ANALYSIS ********************
*****************************************************************
*`1' = Parental earnings variable

	*2A. Drop any porgram already with this name
	capture ///
		program drop ///
			do_analysis_appendix													/*** Drop any program that already exists ***/

	*2B. Create a new program to run the analysis
	program do_analysis_appendix			
	
			
		*i. Estimate intergenerational beta
			*a.Run the model
			regress `2' ///															/*** Regression model to estimate beta ***/
				`1' ///																/*** Key covariate = measure of parental earnings ***/
				if DATASET == 0														/*** Use just the "main" dataset ***/

			*b. Create the beta estimate and the SE
			gen Beta = _b[`1']														/*** Create elasticity ***/
			gen Beta_SE = _se[`1']													/*** Create SE ***/
		
		
		*ii. Estimate intergenerational rho
			*a. Summary statistics for the father earnings variable
			sum `1' ///
				if ///
				 DATASET == 0 ///
				 ,  d																/*** Get summary statistics of the parental earnings variable ***/
			
			*b. Record the standard deviation in a new variable
			gen SD_`1' = r(sd)														/*** New variable recording the standard deviation of this ***/

			*c. Summary statistics for the sons' earnings variable			
			sum `2' , d									/*** Get summary statistics for the child earnings variable ***/
	
			*d. Record the standard deviation in a new variable
			gen SD_Log_Child_Earnings = r(sd)										/*** New variable recording standard deviation of this... ****/

			*e. Create the 'rho' (intergenerational correlation)
			gen Rho ///
				= ///
				Beta*(SD_`1' / SD_Log_Child_Earnings)								/*** Calculate rho (intergen correlation) ***/
	
		*iii. Display the results
		display Beta
		display Rho
	
		*iv. Drop any variables that have been created
		drop Beta* SD_* Rho															/* Drop all the variables created */
	end																				/* END OF PROGRAM */


*****************************************************************
**** STEP 3 -  RUN PROGRAM **************************************
*****************************************************************
	*3A. Run the model using fathers observed income		
		*i. Child one year earnings, father permanent earnings 
		do_analysis_appendix	/// 
			Log_Fa_Perm_Earn ///													/* `1' = Name of father's earning variable used */	
				Log_Child_Earnings 
				
		*ii. Child 5 year earnings, father permanent earnings 
		do_analysis_appendix	/// 
			Log_Fa_Perm_Earn ///													/* `1' = Name of father's earning variable used */	
				Log_Child_Labor_Earnings_5year				

				
	*3B. Model using TSTSLS. Permanent earnings as dependent variable. 
	*    Father reports of the imputer variables.
		*i. Global macro with the different TSTSLS earnings measures in
		global earnings_measures1 ///
			TSTSLS_Predicted_M1 ///
			TSTSLS_Predicted_M2 ///
			TSTSLS_Predicted_M3 ///
			TSTSLS_Predicted_M4 ///
			TSTSLS_Predicted_M5 	

		*ii. Run the analysis for single child earnings
		foreach i of global earnings_measures1 {									/* For TSTSLS models M1 to M5 */
			do_analysis_appendix ///												/* Run the analysis */
				`i' ///																/* `i' = Name of the TSTSLS father earnings measure used */
				Log_Child_Earnings  												/* Whether permanent or 1980s earnings used */
		}																			/* CLOSE THE LOOP */	
			
			
		*iii. Run the analysis for 5 year child earnings
		foreach i of global earnings_measures1 {									/* For TSTSLS models M1 to M5 */
			do_analysis_appendix ///												/* Run the analysis */
				`i' ///																/* `i' = Name of the TSTSLS father earnings measure used */
				Log_Child_Labor_Earnings_5year  ///									/* Whether permanent or 1980s earnings used */
		}																			/* CLOSE THE LOOP */	
