*******************************************************
** JJ Created 14 / 05 / 2014 **************************
** JJ updated 03 / 03 / 2016 ***************************
*******************************************************

****************************************************************************
*--- This do-file creates the AUXILLIARY dataset --------------------------*
****************************************************************************
	*2A Open the data
	use C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\MAIN_DATASET , clear			/*** Upon up the main dataset ***/

	*2B. Drop a load of variables no longer needed
	drop Father_Head_1968  - Father_Labor_Income_2011

	*2C. Set the random number seed for replication
	set seed 4794573																	/*** SET RANDOM NUMBER SEED ***/

	*2D. Create a random number
	gen RANDOM = rnormal(0,1)

	*2E. Split into two halfs
	capture drop DATASET
	xtile DATASET = RANDOM ///
		, ///
		nq(2)
	
	*2F. Save the dataset
	save ///
		"C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_DATASET" ///
			, ///
			replace
			
	*2G. Create the MAIN dataset
		*i. Open the data just saved above
		use ///
			"C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_DATASET" ///
				, ///
				clear
		
		*ii. Keep only if the DATASET variable = 1
		keep if DATASET ==  1
	
		*iii. set as the main dataset
		replace DATASET = 0
		
		*iv. Save this data
		save ///
			"C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_MAIN_DATASET" ///
				, ///
				replace
		
	*2G. Create the AUXILIARY dataset
		*i. Open the data just saved above
		use ///
			"C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_DATASET" ///
				, ///
				clear
		
		*ii. Keep only if the DATASET variable = 1
		keep if DATASET ==  2
	
		*iii. set as the AUXILIARY dataset
		replace DATASET = 1
		
		*iv. Save this data
		save ///
			"C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_AUXILARY_DATASET" ///
				, ///
				replace		
		
*****************************************************************
*STEP 3 Create auxilliary data set ******************************
*****************************************************************	
	*3A. Append the 'main' dataset to the auxiliary dataset
	append ///
		using C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_MAIN_DATASET			/*** Append in the original dataset ***/

	*3B. Save the now appended 'main' and 'auxiliary' datasets
	save ///
		C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\ROBUSTNESS_DATA_FOR_ANALYSIS ///
		, ///
		replace	

