*******************************************************
** JJ Created 14 / 05 / 2014 **************************
** JJ updated 03 / 03 / 2016 ***************************
*******************************************************

*********************************************************************
*--- This do-file performs the analysis ---*
*********************************************************************

*****************************************************************
**** STEP 1 - CROSS-TABULATIONS *********************************
*****************************************************************
*`1' = Father reported variable
*`2' = Children reported variable
*`3' = Make sure less than this value to exclude missing observations	

	*1A. Drop any program that already has this name
	capture ///
		program drop ///
			cross_tabs

	*1B. Create a program to do cross-tabs
	program cross_tabs																/* Name of the new program */
		cd "C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\"						/* Location where data held */
		use DATA_FOR_ANALYSIS, clear												/* Open up the combined dataset */

		*i.	Keep only certain observations	
		keep if DATASET==0															/* Keep 'main' dataset only */
		keep if `2' > 0 															/* Only observations where sons value greater than 0 */
		keep if `2' < `3' 															/* Only observations where sons value non-missing */
		keep if `1' > 0 															/* Only observations where father's value greater than 0 */
		keep if `1' < `3' 															/* Only observations where father's value non-missing */
	
		*ii. Cross-tabulate the data
		tab `1' `2'	
		tab `1' `2'	, row nofreq

		*iii. Kappa statistics 
		kap `1' `2' 
		kap `1' `2' , wgt(w)		
	end																				/* CLOSE THE PROGRAM */

	*1C. Run the program for fathers education
	cross_tabs ///
		Father_Report_Father_Ed ///
		Child_Report_Father_Ed ///
		10

	*1D. Run program for father occupation
	cross_tabs ///
		Father_Report_Class_Age_15 ///
		Child_Report_Father_Class_1970 ///
		20

	*1E. Run program for father industry
	cross_tabs ///
		Father_Report_INDUSTRY /// 
		Child_Report_INDUSTRY ///
		13

		
*--------------------------------------------------------------------------------------*
* Investigate correspondence between mode and age 15 3 digit occupation reports -------*
*--------------------------------------------------------------------------------------*
	*A. Open the data
	use C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\MAIN_DATASET , clear

	*B. Create new variable. Set to 0 by default.
	gen Father_MODE_OCC_vs_15 = 0
	
	*C. Replace with value of 1 if mode category equals age 15 category
	replace Father_MODE_OCC_vs_15 = 1 if Father_Report_Occ_Age_15 == Father_Report_Occ_MODE

	*D. Look at the percentage where the same
	tab Father_MODE_OCC_vs_15


*--------------------------------------------------------------------------------------*
* Investigate correspondence between mode and age 15 SOCIAL CLASS reports -------------*
*--------------------------------------------------------------------------------------*	
	*A. Create new variable. Set to 0 by default
	gen Father_MODE_CLASS_vs_15 = 0

	*B. Replace with value of 1 if mode category equals age 15 category	
	replace Father_MODE_CLASS_vs_15 = 1 if Father_Report_Class_Age_15 == Father_Report_Class_MODE

	*C. Look at the percentage where the same	
	tab Father_MODE_CLASS_vs_15

	*D. Look at correspondence between parent MODAL report and offspring report
	tab ///
		Father_Report_Class_MODE ///
		Child_Report_Father_Class_1970 ///
		, row nofreq

	*E. Produce Kappa statistics
	kap Father_Report_Class_MODE Child_Report_Father_Class_1970
	kap Father_Report_Class_MODE Child_Report_Father_Class_1970 , wgt(w)	
		
		
*--------------------------------------------------------------------------------------*
* Investigate correspondence between mode and age 15 INDUSTRY reports -------------*
*--------------------------------------------------------------------------------------*	
	*A. Create new variable. Set to 0 by default
	gen Father_MODE_IND_vs_15 = 0

	*B. Replace with value of 1 if mode category equals age 15 category	
	replace Father_MODE_IND_vs_15 = 1 if Father_Report_INDUSTRY == Father_Report_INDUSTRY_MODE

	*C. Look at the percentage where the same	
	tab Father_MODE_IND_vs_15

	*D. Look at correspondence between parent MODAL report and offspring report
	tab ///
		Father_Report_INDUSTRY_MODE ///
		Child_Report_INDUSTRY ///
		, row nofreq

	*E. Produce Kappa statistics
	kap Father_Report_INDUSTRY_MODE Child_Report_INDUSTRY
	kap Father_Report_INDUSTRY_MODE Child_Report_INDUSTRY , wgt(w)	
				
		
		
		
		