*******************************************************
** JJ Created 14 / 05 / 2014 **************************
** JJ updated 03 / 03 / 2016 ***************************
*******************************************************

****************************************************************************
*--- This do-file creates the AUXILLIARY dataset --------------------------*
****************************************************************************

*****************************************************************
*STEP 1 INSTALL THE MOREMATA AND GSAMPLE STATA PACKAGES *********
*****************************************************************
*Note: moremata downloadable from *LINK*
*Note: gsample downloadable from *LINK*

	*A.Install moremata package
	net from C:\Users\john\Pictures\STATA_VERSION_9\PSID\moremata
	net install moremata, replace

	*B. Install gsample package
	net from C:\Users\john\Pictures\STATA_VERSION_9\PSID\gsample
	net install gsample, replace



*****************************************************************
*STEP 2 Create auxilliary data set ******************************
*****************************************************************
	*2A. Open the dataset created in the last do-file
	use C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\MAIN_DATASET , clear			/*** Upon up the main dataset ***/

	*2B. Drop a load of variables no longer needed
	drop Father_Head_1968  - Father_Labor_Income_2011

	*2C. Set the random number seed for replication
	set seed 4794573																	/*** SET RANDOM NUMBER SEED ***/

	*2D. Sample 500,000 with replacement.
	gsample 500000 																		/*** Create auxilliary dataset. 500,000 observations ***/

	*2E. We call this the 'auxiliary' dataset
	replace DATASET =1

	*2F. Save this dataset
	save ///
		C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\AUXILARY_DATASET ///
			, replace	

*****************************************************************
*STEP 3 Create auxilliary data set ******************************
*****************************************************************	
	*3A. Append the 'main' dataset to the auxiliary dataset
	append ///
		using C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\MAIN_DATASET			/*** Append in the original dataset ***/

	*3B. Save the now appended 'main' and 'auxiliary' datasets
	save ///
		C:\Users\john\Pictures\STATA_VERSION_9\PSID\DATA1\DATA_FOR_ANALYSIS ///
		, replace	

