#delimit ;
clear;
set more off;
log using e:\research\tus\replicate\cps9293.log, replace;


************** 1992 CPS Sep *******************;

infix double hrhhid	102-113
	huinttyp	12
	str hintrv	21-23
    hstatus		24
	  tenure	25
      telhhd	28
	faminc	26-27 		
	record	34
	mis		35
	hrmonth	3-4
	hryear	5
	huhhnum	6
	mstind	44-48
      region	78
	state       79-80
	smsa		99
	age		120-121
	marital	122
	sex		125
	educa		127-128
	race		130
	pulineno	114-115
      hisp		194-195
      mlr		198
	  chld		276
	smoked	361
	smoking	366
	intmethod		468
   	   	intrview	471
	smokstat	472
	self		444
	tuswgt	489-496
      tuswgt2	497-504
	using c:\cps\cps92sep\cpssep92.dat; 

tab mis intrview;
gen cps=1;
su;
save e:\research\tus\replicate\cps92sep.dta, replace;
clear;


************** 1993 CPS Jan *******************;

infix double hrhhid	102-113
	huinttyp	12
      str hintrv	21-23
    hstatus		24
	  tenure	25
      telhhd	28
	faminc	26-27 		
	record	34
	mis		35
	hrmonth	3-4
	hryear	5
	huhhnum	6
    mstind	44-48
      region	78
	state       79-80
	smsa		99
	age		120-121
	marital	122
	sex		125
	educa		127-128
	race		130
	pulineno	114-115
      hisp		194-195
      mlr		198
	  chld		276
	smoked	361
	smoking	366
   	intmethod		468
   	intrview	471
	smokstat	472
	self		444
	tuswgt	489-496
      tuswgt2	497-504
	using c:\cps\cps93jan\cpsjan93.dat; 

tab mis intrview;
gen cps=2;
su;
save e:\research\tus\replicate\cps93jan.dta, replace;
clear;


************** 1993 CPS May *******************;

infix double hrhhid	102-113
	huinttyp	12
      str hintrv	21-23
    hstatus		24
	  tenure	25
      telhhd	28
	faminc	26-27 		
	record	34
	mis		35
	hrmonth	3-4
	hryear	5
	huhhnum	6
    mstind	44-48
      region	78
	state       79-80
	smsa		99
	age		120-121
	marital	122
	sex		125
	educa		127-128
	race		130
	pulineno	114-115
      hisp		194-195
      mlr		198
	  chld		276
	smoked	361
	smoking	366
	intmethod		468
   	intrview	471
	smokstat	472
	self		444
	tuswgt	489-496
      tuswgt2	497-504
	using c:\cps\cps93may\cpsmay93.dat; 

tab mis intrview;
gen cps=3;
su;
save e:\research\tus\replicate\cps93may.dta, replace;
clear;


********************************************;

use e:\research\tus\replicate\cps92sep.dta, clear;
append using e:\research\tus\replicate\cps93jan.dta;
append using e:\research\tus\replicate\cps93may.dta;

tab intrview;
tab intrview if intrview~=-1;
tab mis huinttyp, row;
tab mis record, row;
tab mis intrview if intrview~=-1, row chi2;
tab mis intrview if intrview~=-1 & mis~=1 & mis~=5, row chi2;

tab intrview self if intrview~=-1 & cps==1, cel;
tab intrview self if intrview~=-1 & cps==2, cel;
tab intrview self if intrview~=-1 & cps==3, cel;

keep if intrview==1;
keep if smoked >=0 & smoked~=9 & smokstat~=9;

recode smoked (2=0) (3=0);
recode smoking (2=1) (3=0) (.=0);

gen never=(smokstat==1);
gen everyday=(smokstat==2);
gen someday=(smokstat==3);
gen former=(smokstat==4);

gen smokstat1=0;
replace smokstat1=1 if smokstat==1;
replace smokstat1=2 if smokstat==2 | smokstat==3;
replace smokstat1=3 if smokstat==4;

gen current=(smokstat1==2);

sort cps;
tab mis smoking if cps==1, missing;
tab mis smoking if cps==2, missing;
tab mis smoking if cps==3, missing;

keep if smoking >=0;
keep if age >=18;

tab smokstat smokstat1;

su;

gen wgt=tuswgt/30000;
gen wgt2=tuswgt2/30000;
sort cps hrhhid pulineno;
save e:\research\tus\replicate\cps9293.dta, replace;

use c:\cps\tus-cps\1992-93\repsep92.dta, clear;
append using c:\cps\tus-cps\1992-93\repjan93.dta, gen(c1);
append using c:\cps\tus-cps\1992-93\repmay93.dta, gen(c2);

destring h_id, gen(hrhhid);
gen pulineno=a_lineno;

forvalues i=1/48 {;
replace	repwgt`i'=repwgt`i'/3;
};

gen cps=1;
replace cps=2 if c1==1;
replace cps=3 if c2==1;
sort cps hrhhid pulineno;
merge 1:1 cps hrhhid pulineno using e:\research\tus\replicate\cps9293.dta;
keep if _merge==3;
drop _merge;

sort hrhhid huhhnum pulineno;
save e:\research\tus\replicate\cps9293.dta, replace;

/* You need to use the formula Fay=1-1/sqrt(adjfay) to convert the value of Fay's adjustment given in the documentation to the form that Stata wants.  
You need to use the -vce(brr)- and -mse- options to obtain the standard errors given by SUDAAN. 
http://www.ats.ucla.edu/stat/stata/faq/sample_survey_setups.htm

http://appliedresearch.cancer.gov/tus-cps/workshops/2009/tusuw2009_gibson.pdf

Also see https://usa.ipums.org/usa/repwt.shtml*/;

svyset [pweight = wgt], brrweight(repwgt1 - repwgt48) fay(.5) vce(brr) mse;

svy: tab mis smoking, row se ci;

**** Unweighted results ****;
gen con_wgt=1;
svyset [pweight=con_wgt];
svy: tab mis smoking, row se ci;

log close;
