#delimit ;
clear;
set more off;
log using e:\research\tus\replicate\cps9596.log, replace;


************** 1995 CPS Sep *******************;
******* chld is not in the data ***************;

infix double hrhhid	1-15
	huinttyp	16-17
      tenure	29-30
      telhhd	33-34
	faminc	39-40 		
	record	57-58
	mis		63-64
	hrmonth	65-66
	hryear	67-68
	hrlonglk	69-70
	str hrsample	71-74
	str hrsersuf	75-76 
	huhhnum	77-78
      region	89-90
	state       91-92
	smsa		105
	age		122-123
	marital	125-126
	sex		129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
      mlr		180-181
	smoked	815-816
	smoking	819-820
	intmethod	953-954
   	intrview	955-956
	smokstat	957-958
	self		949-950
	tuswgt	961-970
      tuswgt2	971-980
	mode		981-982  
	using c:\cps\cps95sep\cpssep95.dat; 

tab mis intrview;
replace self=2 if self>=2;
gen cps=1;
su;
save e:\research\tus\replicate\cps95sep.dta, replace;
clear;


************** 1996 CPS Jan *******************;
******* chld is not in the data ***************;

infix double hrhhid	1-15
	huinttyp	16-17
      tenure	29-30
      telhhd	33-34
	faminc	39-40 		
	record	57-58
	mis		63-64
	hrmonth	65-66
	hryear	67-68
	hrlonglk	69-70
	str hrsample	71-74
	str hrsersuf	75-76 
	huhhnum	77-78
      region	89-90
	state       91-92
	smsa		105
	age		122-123
	marital	125-126
	sex		129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
      mlr		180-181
	smoked	815-816
	smoking	819-820
	intmethod	953-954
   	intrview	955-956
	smokstat	957-958
	self		949-950
	tuswgt	961-970
      tuswgt2	971-980
	mode		981-982  
	using c:\cps\cps96jan\cpsjan96.dat; 

tab mis intrview;
replace self=2 if self>=2;
gen cps=2;
su;
save e:\research\tus\replicate\cps96jan.dta, replace;
clear;


************** 1996 CPS May *******************;
******* chld is not in the data ***************;

infix double hrhhid	1-15
	huinttyp	16-17
      tenure	29-30
      telhhd	33-34
	faminc	39-40 		
	record	57-58
	mis		63-64
	hrmonth	65-66
	hryear	67-68
	hrlonglk	69-70
	str hrsample	71-74
	str hrsersuf	75-76 
	huhhnum	77-78
      region	89-90
	state       91-92
	smsa		105
	age		122-123
	marital	125-126
	sex		129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
      mlr		180-181
	smoked	815-816
	smoking	819-820
   	intmethod	953-954
   	intrview	955-956
	smokstat	957-958
	self		949-950
	tuswgt	961-970
      tuswgt2	971-980
	mode		981-982  
	using c:\cps\cps96may\cpsmay96.dat; 

tab mis intrview;
replace self=2 if self>=2;
gen cps=3;
su;
save e:\research\tus\replicate\cps96may.dta, replace;
clear;



********************************************;

use e:\research\tus\replicate\cps95sep.dta, clear;
append using e:\research\tus\replicate\cps96jan.dta;
append using e:\research\tus\replicate\cps96may.dta;

tab intrview;
tab intrview if intrview~=-1;
tab mis huinttyp, row;
tab mis record, row;
tab mis intrview if intrview~=-1, row chi2;
tab mis intrview if intrview~=-1 & mis~=1 & mis~=5, row chi2;

tab intrview self if intrview~=-1 & cps==1, cel;
tab intrview self if intrview~=-1 & cps==2, cel;
tab intrview self if intrview~=-1 & cps==3, cel;

keep if intrview==1;
keep if smoked >=0;

recode smoked (2=0);
recode smoking (2=1) (3=0) (-1=0);

gen never=(smokstat==1);
gen everyday=(smokstat==2);
gen someday=(smokstat==3);
gen former=(smokstat==4);

gen smokstat1=0;
replace smokstat1=1 if smokstat==1;
replace smokstat1=2 if smokstat==2 | smokstat==3;
replace smokstat1=3 if smokstat==4;

gen current=(smokstat1==2);

sort cps;
tab mis smoking if cps==1, missing;
tab mis smoking if cps==2, missing;
tab mis smoking if cps==3, missing;

keep if smoking >=0;
keep if age >=18;

tab smokstat smokstat1;

su;

gen wgt=tuswgt/30000;
gen wgt2=tuswgt2/30000;
sort cps hrhhid hrsersuf pulineno;
save e:\research\tus\replicate\cps9596.dta, replace;

use c:\cps\tus-cps\1995-96\repsep95.dta, clear;
append using c:\cps\tus-cps\1995-96\repjan96.dta, gen(c1);
append using c:\cps\tus-cps\1995-96\repmay96.dta, gen(c2);

destring hrhhid, replace;

forvalues i=1/80 {;
replace	repwgt`i'=repwgt`i'/3;
};

gen cps=1;
replace cps=2 if c1==1;
replace cps=3 if c2==1;
sort cps hrhhid hrsersuf pulineno;
merge 1:1 cps hrhhid hrsersuf pulineno using e:\research\tus\replicate\cps9596.dta;
keep if _merge==3;
drop _merge;

sort hrhhid pulineno hrsersuf huhhnum hrsample;
save e:\research\tus\replicate\cps9596.dta, replace;

/* You need to use the formula Fay=1-1/sqrt(adjfay) to convert the value of Fay's adjustment given in the documentation to the form that Stata wants.  
You need to use the -vce(brr)- and -mse- options to obtain the standard errors given by SUDAAN. 
http://www.ats.ucla.edu/stat/stata/faq/sample_survey_setups.htm

Also see https://usa.ipums.org/usa/repwt.shtml*/;

svyset [pweight = wgt], brrweight(repwgt1 - repwgt80) fay(.5) vce(brr) mse;

svy: tab mis smoking, row se ci;

**** Unweighted results ****;
gen con_wgt=1;
svyset [pweight=con_wgt];
svy: tab mis smoking, row se ci;

log close;
