#delimit ;
clear;
set more off;
log using e:\research\tus\replicate\cps9293post7.log, replace;


************** 1993 CPS Nov *******************;

infix double hrhhid	145-156
      pmis		70
	huhhnum		2
	page		169-170
	psex		175
	prace		180
	pulineno	162-163
	using c:\cps\cps_basic\cpsb93\cpsb9311.; 

gen cps=1;
su;
save e:\research\tus\replicate\cpsb9311.dta, replace;
clear;

************** 1994 CPS Mar *******************;

infix double hrhhid	1-12
      pmis		63-64
	huhhnum		77-78
	page		122-123
	psex		129-130
	prace		139-140
	pulineno	147-148
	using c:\cps\cps_basic\cpsb94\cpsb9403.; 

gen cps=2;
su;
save e:\research\tus\replicate\cpsb9403.dta, replace;
clear;

************** 1994 CPS Jul *******************;

infix double hrhhid	1-12
      pmis		63-64
	huhhnum		77-78
	page		122-123
	psex		129-130
	prace		139-140
	pulineno	147-148
	using c:\cps\cps_basic\cpsb94\cpsb9407.; 

gen cps=3;
su;
save e:\research\tus\replicate\cpsb9407.dta, replace;
clear;

***********************************************;

use e:\research\tus\replicate\cpsb9311.dta, clear;
append using e:\research\tus\replicate\cpsb9403.dta;
append using e:\research\tus\replicate\cpsb9407.dta;

keep if pmis==7;
keep if page~=. & psex~=. & prace~=.;

sort hrhhid huhhnum pulineno cps;

duplicates report hrhhid huhhnum pulineno cps;

merge m:1 hrhhid huhhnum pulineno cps using e:\research\tus\replicate\cps9293.dta;

tab _merge;

keep if _merge~=1;
keep if _merge~=1 & mis==1;
tab _merge;

gen match1=((age==page | age==page-1 | age==page-2) & sex==psex & race==prace);

duplicates drop;
duplicates report hrhhid huhhnum pulineno cps;
duplicates drop hrhhid huhhnum pulineno cps if match1~=1, force;
duplicates drop hrhhid huhhnum pulineno cps if match1==1, force;
gsort hrhhid huhhnum pulineno cps -match1;
duplicates drop hrhhid huhhnum pulineno cps, force;

gen northeast=(region==1);
gen midwest=(region==2);
gen south=(region==3);
gen west=(region==4);

gen female=(sex==2);

gen married=(marital==1 | marital==2 | marital==3);
gen widowed=(marital==4);
gen div_sep=(marital==5 | marital==6);
gen nevermar=(marital==7);

recode hisp (1/7=1) (8/10=0);

gen white=(race==1 & hisp==0);
gen black=(race==2 & hisp==0);
gen ai_an=(race==3 & hisp==0);
gen aa_pi=(race==4 & hisp==0);
gen other=(race==5 & hisp==0);

gen less_hi=(educa < 39);
gen hi_sch=(educa==39);
gen some_col=(educa > 39 & educa < 43);
gen college=(educa >= 43);

tab faminc;

gen fincmis=(faminc < 0 | faminc==19);
gen finc1=(faminc==0);
gen finc2=(faminc==1);
gen finc3=(faminc==2);
gen finc4=(faminc==3);
gen finc5=(faminc==4);
gen finc6=(faminc==5);
gen finc7=(faminc==6);
gen finc8=(faminc==7);
gen finc9=(faminc==8);
gen finc10=(faminc==9);
gen finc11=(faminc==10);
gen finc12=(faminc==11);
gen finc13=(faminc==12);
gen finc14=(faminc==13);

gen employed=(mlr==1 | mlr==2);
gen unemployed=(mlr==3 | mlr==4);
gen nlf=(mlr==5 | mlr==6 | mlr==7);

gen owned=(tenure==1);

gen age1824=(age>=18 & age<=24);
gen age2544=(age>=25 & age<=44);
gen age4564=(age>=45 & age<=64);
gen age65=(age>=65);

gen cps1=(cps==1);
gen cps2=(cps==2);
gen cps3=(cps==3);

gen unknown_self=(self==9);
recode self (2 9=0);

gen metro=(smsa==1);
gen nonmetro=(smsa==2);
gen notident=(smsa==3);

gen personal=(intmethod==2);
gen unknown=(intmethod>2);
gen telephone=(intmethod==1);

*** telhhd NA in 9293 TUS-CPS ****;
recode telhhd (2=0);

local control "age1824 age2544 age4564 female black hisp ai_an aa_pi other hi_sch some_col college unemployed nlf
               married widowed div_sep fincmis finc2-finc14 owned
               nonmetro notident midwest south west cps2 cps3 self unknown_self personal unknown telhhd
               smoking";

local controla "age1824 age2544 age4564 female black hisp ai_an aa_pi other hi_sch some_col college unemployed nlf
               married widowed div_sep fincmis finc2-finc14 owned
               nonmetro notident midwest south west cps2 cps3 self unknown_self personal unknown telhhd
               i.smoking";
			   
su match1 `control';

svyset [pweight = wgt], brrweight(repwgt1 - repwgt48) fay(.5) vce(brr) mse;

svy: tab match1 smoking, row se ci;

capture program drop mymargins;
program mymargins, eclass;
	syntax anything [if] [iw pw];
	if "`weight'" != "" {;
	local wgtexp "[`weight' `exp']";
	};
	set buildfvinfo on;
	`anything' `if' `wgtexp';
	margins, dydx(*) post;
end;

svy brr _b: mymargins probit match1 `control';
outreg2 smoking using e:\research\tus\replicate\cps9293post.txt, bdec(3) word ap;

capture program drop mymargins2;
program mymargins2, eclass;
	syntax anything [if] [iw pw];
	if "`weight'" != "" {;
	local wgtexp "[`weight' `exp']";
	};
	set buildfvinfo on;
	`anything' `if' `wgtexp';
	margins smoking, post;
end;

svy brr _b: mymargins2 probit match1 `controla';

log close;
