#delimit ;
clear;
set more off;
log using e:\research\tus\replicate\cps9293reg.log, replace;

use e:\research\tus\replicate\cps9293.dta, clear;

gen mis1=(mis==1);
gen mis2=(mis==2);
gen mis3=(mis==3);
gen mis4=(mis==4);
gen mis5=(mis==5);
gen mis6=(mis==6);
gen mis7=(mis==7);
gen mis8=(mis==8);

gen northeast=(region==1);
gen midwest=(region==2);
gen south=(region==3);
gen west=(region==4);

gen female=(sex==2);

gen married=(marital==1 | marital==2 | marital==3);
gen widowed=(marital==4);
gen div_sep=(marital==5 | marital==6);
gen nevermar=(marital==7);

recode hisp (1/7=1) (8/10=0);

gen white=(race==1 & hisp==0);
gen black=(race==2 & hisp==0);
gen ai_an=(race==3 & hisp==0);
gen aa_pi=(race==4 & hisp==0);
gen other=(race==5 & hisp==0);

gen less_hi=(educa < 39);
gen hi_sch=(educa==39);
gen some_col=(educa > 39 & educa < 43);
gen college=(educa >= 43);

tab faminc;

gen fincmis=(faminc < 0 | faminc==19);
gen finc1=(faminc==0);
gen finc2=(faminc==1);
gen finc3=(faminc==2);
gen finc4=(faminc==3);
gen finc5=(faminc==4);
gen finc6=(faminc==5);
gen finc7=(faminc==6);
gen finc8=(faminc==7);
gen finc9=(faminc==8);
gen finc10=(faminc==9);
gen finc11=(faminc==10);
gen finc12=(faminc==11);
gen finc13=(faminc==12);
gen finc14=(faminc==13);

gen employed=(mlr==1 | mlr==2);
gen unemployed=(mlr==3 | mlr==4);
gen nlf=(mlr==5 | mlr==6 | mlr==7);

gen owned=(tenure==1);

gen age1824=(age>=18 & age<=24);
gen age2544=(age>=25 & age<=44);
gen age4564=(age>=45 & age<=64);
gen age65=(age>=65);

gen cps1=(cps==1);
gen cps2=(cps==2);
gen cps3=(cps==3);

tab self;
gen unknown_self=(self==9);
recode self (2 9=0);

gen metro=(smsa==1);
gen nonmetro=(smsa==2);
gen notident=(smsa==3);

tab intmethod;
gen personal=(intmethod==2);
gen unknown=(intmethod>2);
gen telephone=(intmethod==1);

gen replacement=(hstatus==1);

gen hhnum2=(huhhnum>=2);

local control "mis1 age1824 age2544 age4564 female black hisp ai_an aa_pi other hi_sch some_col college unemployed nlf
               married widowed div_sep fincmis finc2-finc14 owned
               nonmetro notident midwest south west cps2 cps3 self unknown_self personal unknown";

local controlall "mis1 age1824 age2544 age4564 age65 female white black hisp ai_an aa_pi other less_hi hi_sch some_col college employed unemployed nlf
               married widowed div_sep nevermar fincmis finc1-finc14 owned
               metro nonmetro notident northeast midwest south west cps1 cps2 cps3 self unknown_self personal unknown telephone";
		   
su smoking `controlall' hhnum2 replacement;
svyset [pweight = wgt], brrweight(repwgt1 - repwgt48) fay(.5) vce(brr) mse;

capture program drop mymargins;
program mymargins, eclass;
	syntax anything [if] [iw pw];
	if "`weight'" != "" {;
	local wgtexp "[`weight' `exp']";
	};
	set buildfvinfo on;
	`anything' `if' `wgtexp';
	margins, dydx(*) post;
end;

svy brr _b: mymargins probit smoking mis1;
outreg2 using e:\research\tus\replicate\table2a.txt, bdec(3) word replace;

svy brr _b: mymargins probit smoking `control';
outreg2 using e:\research\tus\replicate\table2b.txt, bdec(3) word replace;

**** Unweighted results ****;
gen con_wgt=1;
svyset [pweight=con_wgt];
svy: probit smoking mis1;
margins, dydx(*) vce(unconditional) post;
outreg2 using e:\research\tus\replicate\table2a_unweighted.txt, bdec(3) word replace;

svy: probit smoking `control';
margins, dydx(*) vce(unconditional) post;
outreg2 using e:\research\tus\replicate\table2b_unweighted.txt, bdec(3) word replace;

log close;
