#delimit ;
clear all;
set more off;
log using e:\research\tus\replicate\cps1011.log, replace;


************** 2010 CPS May *******************;

infix double hrhhid	1-15
	hrmonth		16-17
	hryear4		18-21
    tenure		29-30
    telhhd		33-34
	faminc		39-40 		
	record		57-58
	mis			63-64
	huinttyp	65-66
	hrlonglk	69-70
	str hrhhid2	71-75
	huhhnum		75
    region		89-90
	state       91-92
	smsa		105
	age			122-123
	marital		125-126
	sex			129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
    mlr			180-181
	chld		635-636
	qstnum		815-819
	occurnum	820-821
	smoked		955-956
    smoking		967-968
	intmethod	1573-1574
	intrview	1575-1576
	mode		1577-1578
	smokstat	1579-1580
	self		1585-1586
	tuswgt		1617-1626
    tuswgt2		1627-1636
	using c:\cps\cps10may\cpsmay10.dat; 

tab mis intrview;
gen cps=1;
su;
save e:\research\tus\replicate\cps10may.dta, replace;
clear;


************** 2010 CPS Aug *******************;

infix double hrhhid	1-15
	hrmonth		16-17
	hryear4		18-21
    tenure		29-30
    telhhd		33-34
	faminc		39-40 		
	record		57-58
	mis			63-64
	huinttyp	65-66
	hrlonglk	69-70
	str hrhhid2	71-75
	huhhnum		75
    region		89-90
	state       91-92
	smsa		105
	age			122-123
	marital		125-126
	sex			129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
    mlr			180-181
	chld		635-636
	qstnum		815-819
	occurnum	820-821
	smoked		955-956
    smoking		967-968
	intmethod	1573-1574
	intrview	1575-1576
	mode		1577-1578
	smokstat	1579-1580
	self		1585-1586
	tuswgt		1617-1626
    tuswgt2		1627-1636
	using c:\cps\cps10aug\cpsaug10.dat; 

tab mis intrview;
gen cps=2;
su;
save e:\research\tus\replicate\cps10aug.dta, replace;
clear;

************** 2011 CPS Jan *******************;

infix double hrhhid	1-15
	hrmonth		16-17
	hryear4		18-21
    tenure		29-30
    telhhd		33-34
	faminc		39-40 		
	record		57-58
	mis			63-64
	huinttyp	65-66
	hrlonglk	69-70
	str hrhhid2	71-75
	huhhnum		75
    region		89-90
	state       91-92
	smsa		105
	age			122-123
	marital		125-126
	sex			129-130
	educa		137-138
	race		139-140
	pulineno	147-148
	hisp		157-158
    mlr			180-181
	chld		635-636
	qstnum		815-819
	occurnum	820-821
	smoked		955-956
    smoking		967-968
	intmethod	1573-1574
	intrview	1575-1576
	mode		1577-1578
	smokstat	1579-1580
	self		1585-1586
	tuswgt		1617-1626
    tuswgt2		1627-1636
	using c:\cps\cps11jan\cpsjan11.dat; 

tab mis intrview;
gen cps=3;
su;
save e:\research\tus\replicate\cps11jan.dta, replace;
clear;


**************************************************;

use e:\research\tus\replicate\cps10may.dta, clear;
append using e:\research\tus\replicate\cps10aug.dta;
append using e:\research\tus\replicate\cps11jan.dta;

tab intrview;
tab intrview if intrview~=-1;
tab mis huinttyp, row;
tab mis record, row;
tab mis intrview if intrview~=-1, row chi2;
tab mis intrview if intrview~=-1 & mis~=1 & mis~=5, row chi2;

tab intrview self if intrview~=-1 & cps==1, cel;
tab intrview self if intrview~=-1 & cps==2, cel;
tab intrview self if intrview~=-1 & cps==3, cel;
tab intrview self if intrview~=-1 & cps==1 & age>=18, cel;
tab intrview self if intrview~=-1 & cps==2 & age>=18, cel;
tab intrview self if intrview~=-1 & cps==3 & age>=18, cel;

keep if intrview==1;
keep if smoked >=0;

recode smoked (2=0);
recode smoking (2=1) (3=0) (-1=0);

gen never=(smokstat==1);
gen everyday=(smokstat==2);
gen someday=(smokstat==3);
gen former=(smokstat==4);

gen smokstat1=0;
replace smokstat1=1 if smokstat==1;
replace smokstat1=2 if smokstat==2 | smokstat==3;
replace smokstat1=3 if smokstat==4;

gen current=(smokstat1==2);

sort cps;
tab mis smoking if cps==1, missing;
tab mis smoking if cps==2, missing;
tab mis smoking if cps==3, missing;

keep if smoking >=0;
keep if age >=18;

tab smokstat smokstat1;

su;

gen wgt=tuswgt/30000;
gen wgt2=tuswgt2/30000;
sort cps qstnum occurnum;
save e:\research\tus\replicate\cps1011.dta, replace;

use c:\cps\tus-cps\2010-11\repwgt_may2010.dta, clear;
append using c:\cps\tus-cps\2010-11\repwgt_aug2010.dta, gen(c1);
append using c:\cps\tus-cps\2010-11\repwgt_jan2011.dta, gen(c2);

forvalues i=1/160 {;
replace	repwgt`i'=repwgt`i'/3;
};

gen cps=1;
replace cps=2 if c1==1;
replace cps=3 if c2==1;
sort cps qstnum occurnum;
merge 1:1 cps qstnum occurnum using e:\research\tus\replicate\cps1011.dta;
keep if _merge==3;
drop _merge;
sort cps hrhhid hrhhid2 pulineno;
save e:\research\tus\replicate\cps1011.dta, replace;

/* You need to use the formula Fay=1-1/sqrt(adjfay) to convert the value of Fay's adjustment given in the documentation to the form that Stata wants.  
You need to use the -vce(brr)- and -mse- options to obtain the standard errors given by SUDAAN. 
http://www.ats.ucla.edu/stat/stata/faq/sample_survey_setups.htm

Also see https://usa.ipums.org/usa/repwt.shtml*/;

svyset [pweight = wgt], brrweight(repwgt1 - repwgt160) fay(.5) vce(brr) mse;

svy: tab mis smoking, row se ci;

**** Unweighted results ****;
gen con_wgt=1;
svyset [pweight=con_wgt];
svy: tab mis smoking, row se ci;

log close;
