#delimit ;
clear;
set more off;
log using e:\research\tus\replicate\cps00post6.log, replace;


************** 2001 CPS Feb *******************;

infix double hrhhid	1-15
      pmis		63-64
	str hrsample	71-74
	str hrsersuf	75-76 
	huhhnum	77-78
	page		122-123
	psex		129-130
	prace		139-140
	pulineno	147-148
	using c:\cps\cps_basic\cpsb01\cpsb0102.; 

gen pcps=1;
su;
save e:\research\tus\replicate\cpsb0102.dta, replace;
clear;

************** 2001 CPS Jun *******************;

infix double hrhhid	1-15
      pmis		63-64
	str hrsample	71-74
	str hrsersuf	75-76 
	huhhnum	77-78
	page		122-123
	psex		129-130
	prace		139-140
	pulineno	147-148
	using c:\cps\cps_basic\cpsb01\cpsb0106.; 

gen pcps=2;
su;
save e:\research\tus\replicate\cpsb0106.dta, replace;
clear;

***********************************************;

use e:\research\tus\replicate\cpsb0102.dta, clear;
append using e:\research\tus\replicate\cpsb0106.dta;

keep if pmis==6;

replace hrsersuf="" if hrsersuf=="-1";
sort hrhhid hrsersuf huhhnum hrsample pulineno;

merge 1:1 hrhhid hrsersuf huhhnum hrsample pulineno using e:\research\tus\replicate\cps00.dta;

tab _merge;

keep if _merge~=1;
keep if _merge~=1 & mis==1;
tab _merge;

gen match1=((age==page | age==page-1 | age==page-2) & sex==psex & race==prace);

gen northeast=(region==1);
gen midwest=(region==2);
gen south=(region==3);
gen west=(region==4);

gen female=(sex==2);

gen married=(marital==1 | marital==2);
gen widowed=(marital==3);
gen div_sep=(marital==4 | marital==5);
gen nevermar=(marital==6);

recode hisp (2=0);

gen white=(race==1 & hisp==0);
gen black=(race==2 & hisp==0);
gen ai_an=(race==3 & hisp==0);
gen aa_pi=(race==4 & hisp==0);
gen other=(race==5 & hisp==0);

gen less_hi=(educa < 39);
gen hi_sch=(educa==39);
gen some_col=(educa > 39 & educa < 43);
gen college=(educa >= 43);

tab faminc;

gen fincmis=(faminc < 0);
gen finc1=(faminc==1);
gen finc2=(faminc==2);
gen finc3=(faminc==3);
gen finc4=(faminc==4);
gen finc5=(faminc==5);
gen finc6=(faminc==6);
gen finc7=(faminc==7);
gen finc8=(faminc==8);
gen finc9=(faminc==9);
gen finc10=(faminc==10);
gen finc11=(faminc==11);
gen finc12=(faminc==12);
gen finc13=(faminc==13);
gen finc14=(faminc==14);

gen employed=(mlr==1 | mlr==2);
gen unemployed=(mlr==3 | mlr==4);
gen nlf=(mlr==5 | mlr==6 | mlr==7);

gen owned=(tenure==1);

gen age1824=(age>=18 & age<=24);
gen age2544=(age>=25 & age<=44);
gen age4564=(age>=45 & age<=64);
gen age65=(age>=65);

gen cps1=(cps==1);
gen cps2=(cps==2);
gen cps3=(cps==3);

recode chld (-1=0);
recode self (2=0);

gen metro=(smsa==1);
gen nonmetro=(smsa==2);
gen notident=(smsa==3);

gen personal=(intmethod==2);
gen unknown=(intmethod==-1 & mode==1);
gen telephone=(intmethod==1 | (intmethod==-1 & mode==2));

recode telhhd (2=0);

local control "age1824 age2544 age4564 female black hisp ai_an aa_pi hi_sch some_col college unemployed nlf
               married widowed div_sep fincmis finc2-finc14 owned
               nonmetro notident midwest south west cps2 cps3 self personal unknown telhhd
               smoking";

local controla "age1824 age2544 age4564 female black hisp ai_an aa_pi hi_sch some_col college unemployed nlf
               married widowed div_sep fincmis finc2-finc14 owned
               nonmetro notident midwest south west cps2 cps3 self personal unknown telhhd
               i.smoking";

su match `control';

svyset [pweight = wgt], brrweight(repwgt1 - repwgt80) fay(.5) vce(brr) mse;

svy: tab match1 smoking, row se ci;

capture program drop mymargins;
program mymargins, eclass;
	syntax anything [if] [iw pw];
	if "`weight'" != "" {;
	local wgtexp "[`weight' `exp']";
	};
	set buildfvinfo on;
	`anything' `if' `wgtexp';
	margins, dydx(*) post;
end;

svy brr _b: mymargins probit match1 `control';
outreg2 smoking using e:\research\tus\replicate\cps00post.txt, bdec(3) word ap;

capture program drop mymargins2;
program mymargins2, eclass;
	syntax anything [if] [iw pw];
	if "`weight'" != "" {;
	local wgtexp "[`weight' `exp']";
	};
	set buildfvinfo on;
	`anything' `if' `wgtexp';
	margins smoking, post;
end;

svy brr _b: mymargins2 probit match1 `controla';

log close;
