***********************************section_4.1************************************

* Comparison of single-equation techniques and Mplus Model 01 (section_4.1_01.inp)

***********************************

use soep2009_long.dta

* Base model

logit Disp2 alter zbil D_erw2 D_erw3 zufr risk D_Wohns h_Wohnd c.zhhgr##c.zhhgr ahinc h_local Kind0_5 Kind6_16 D_Mob08
bysort sex: logit Disp2 alter zbil D_erw2 D_erw3 zufr risk D_Wohns h_Wohnd c.zhhgr##c.zhhgr ahinc h_local Kind0_5 Kind6_16 D_Mob08

* Allison 1999

capture program drop palogit
program define palogit
	args lnf theta delta
	quietly replace `lnf' = $ML_y1*`theta'*(1+`delta') - ln(1+exp(`theta'*(1+`delta')))
end
ml model lf palogit (Disp2 = alter zbil D_erw2 D_erw3 zufr risk D_Wohns h_Wohnd c.zhhgr##c.zhhgr ahinc h_local Kind0_5 Kind6_16 D_Mob08 D_Frau)(delta: D_Frau, nocons), maximize
ml display
local delta "-.0507869"
estimates store m1

* Hauser / Andrew 2006

capture program drop lrpc
program define lrpc
	tempvar theta
	args lnf betas intercepts lambdas
	gen double `theta' = `intercepts' + (`lambdas' * `betas')
	quietly replace `lnf' = ln(exp(`theta')/(1+exp(`theta'))) if $ML_y1==1
	quietly replace `lnf' = ln(1/(1+exp(`theta'))) if $ML_y1==0
end
constraint 1 [lambdas]D_Mann = 1
ml model lf lrpc (betas: alter zbil D_erw2 D_erw3 zufr risk D_Wohns h_Wohnd c.zhhgr##c.zhhgr ahinc h_local Kind0_5 Kind6_16 D_Mob08, nocons)(intercepts: Disp2 = D_Frau D_Mann, nocons)(lambdas: D_Frau D_Mann, nocons), maximize constraint(1)
ml display
local lambda ".949213"
estimates store m2

* Williams 2009

oglm Disp2 alter zbil D_erw2 D_erw3 zufr risk D_Wohns h_Wohnd c.zhhgr##c.zhhgr ahinc h_local Kind0_5 Kind6_16 D_Mob08 D_Frau, het(D_Frau)
local lnsigma ".0521222"
estimates store m3

estimates stats m1 m2 m3

* Sigma via Allison 1999
di 1 / (1 + `delta')
* Sigma via Hauser / Andrew 2006
di 1 / `lambda'
* Sigma via Williams 2009
di exp(`lnsigma')

estimates clear
exit
